/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import socks.Proxy;
import socks.Socks5DatagramSocket;
import socks.Socks5Proxy;
import socks.SocksDialog;
import socks.SocksServerSocket;
import socks.SocksSocket;

public class SocksEcho
extends Frame
implements ActionListener,
Runnable,
WindowListener {
    TextField host_text;
    TextField port_text;
    TextField input_text;
    Button proxy_button;
    Button accept_button;
    Button clear_button;
    Button connect_button;
    Button udp_button;
    Button quit_button;
    TextArea output_textarea;
    Label status_label;
    SocksDialog socks_dialog;
    Proxy proxy = null;
    int port;
    String host;
    Thread net_thread = null;
    InputStream in = null;
    OutputStream out = null;
    Socket sock = null;
    ServerSocket server_sock = null;
    Socks5DatagramSocket udp_sock;
    Object net_lock = new Object();
    int mode = 3;
    static final int LISTEN_MODE = 0;
    static final int CONNECT_MODE = 1;
    static final int UDP_MODE = 2;
    static final int COMMAND_MODE = 3;
    static final int ABORT_MODE = 4;
    static final int MAX_DATAGRAM_SIZE = 1024;

    public SocksEcho() {
        super("SocksEcho");
        this.guiInit();
        this.socks_dialog = new SocksDialog(this);
        SocksDialog.useThreads = false;
        URL icon_url = SocksEcho.class.getResource("SocksEcho.gif");
        if (icon_url != null) {
            try {
                Object content = icon_url.getContent();
                if (content instanceof ImageProducer) {
                    this.setIconImage(this.createImage((ImageProducer)content));
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.addWindowListener(this);
        Component[] component = this.getComponents();
        for (int i = 0; i < component.length; ++i) {
            if (component[i] instanceof Button) {
                ((Button)component[i]).addActionListener(this);
                continue;
            }
            if (!(component[i] instanceof TextField)) continue;
            ((TextField)component[i]).addActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.proxy_button) {
            this.onProxy();
        } else if (source == this.quit_button) {
            this.onQuit();
        } else if (source == this.connect_button || source == this.port_text || source == this.host_text) {
            this.onConnect();
        } else if (source == this.input_text) {
            this.onInput();
        } else if (source == this.accept_button) {
            this.onAccept();
        } else if (source == this.udp_button) {
            this.onUDP();
        } else if (source == this.clear_button) {
            this.onClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        boolean finished_OK = true;
        try {
            switch (this.mode) {
                case 2: {
                    this.startUDP();
                    this.doUDPPipe();
                    return;
                }
                case 0: {
                    this.doAccept();
                    this.doPipe();
                    return;
                }
                case 1: {
                    this.doConnect();
                    this.doPipe();
                    return;
                }
                default: {
                    this.warn("Unexpected mode in run() method");
                    return;
                }
            }
        }
        catch (UnknownHostException uh_ex) {
            if (this.mode == 4) return;
            finished_OK = false;
            this.status("Host " + this.host + " has no DNS entry.");
            uh_ex.printStackTrace();
            return;
        }
        catch (IOException io_ex) {
            if (this.mode == 4) return;
            finished_OK = false;
            this.status("" + io_ex);
            io_ex.printStackTrace();
            return;
        }
        finally {
            if (this.mode == 4) {
                this.status("Connection closed");
            } else if (finished_OK) {
                this.status("Connection closed by foreign host.");
            }
            this.onDisconnect();
        }
    }

    private void onConnect() {
        if (this.mode == 1) {
            this.status("Diconnecting...");
            this.abort_connection();
            return;
        }
        if (this.mode != 3) {
            return;
        }
        if (!this.readHost()) {
            return;
        }
        if (!this.readPort()) {
            return;
        }
        if (this.proxy == null) {
            this.warn("Proxy is not set");
            this.onProxy();
            return;
        }
        this.startNetThread(1);
        this.status("Connecting to " + this.host + ":" + this.port + "  ...");
        this.connect_button.setLabel("Disconnect");
        this.connect_button.invalidate();
        this.accept_button.setEnabled(false);
        this.udp_button.setEnabled(false);
        this.doLayout();
        this.input_text.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisconnect() {
        Object object = this.net_lock;
        synchronized (object) {
            this.mode = 3;
            this.connect_button.setLabel("Connect");
            this.accept_button.setLabel("Accept");
            this.udp_button.setLabel("UDP");
            this.accept_button.setEnabled(true);
            this.connect_button.setEnabled(true);
            this.udp_button.setEnabled(true);
            this.server_sock = null;
            this.sock = null;
            this.out = null;
            this.in = null;
            this.net_thread = null;
        }
    }

    private void onAccept() {
        if (this.mode == 0) {
            this.abort_connection();
            return;
        }
        if (this.mode != 3) {
            return;
        }
        if (!this.readHost()) {
            return;
        }
        if (!this.readPort()) {
            this.port = 0;
        }
        if (this.proxy == null) {
            this.warn("Proxy is not set");
            this.onProxy();
            return;
        }
        this.startNetThread(0);
        this.accept_button.setLabel("Abort");
        this.connect_button.setEnabled(false);
        this.udp_button.setEnabled(false);
        this.input_text.requestFocus();
    }

    private void onUDP() {
        if (this.mode == 2) {
            this.abort_connection();
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.proxy == null) {
            this.warn("Proxy is not set");
            this.onProxy();
            return;
        }
        this.startNetThread(2);
        this.udp_button.setLabel("Abort");
        this.connect_button.setEnabled(false);
        this.accept_button.setEnabled(false);
        this.udp_button.invalidate();
        this.doLayout();
        this.input_text.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInput() {
        String send_string = this.input_text.getText() + "\n";
        switch (this.mode) {
            case 3: 
            case 4: {
                return;
            }
            case 0: 
            case 1: {
                Object object = this.net_lock;
                synchronized (object) {
                    if (this.out == null) {
                        return;
                    }
                    this.send(send_string);
                    break;
                }
            }
            case 2: {
                if (!this.readHost()) {
                    return;
                }
                if (!this.readPort()) {
                    return;
                }
                this.sendUDP(send_string, this.host, this.port);
                break;
            }
            default: {
                this.print("Unknown mode in onInput():" + this.mode);
            }
        }
        this.input_text.setText("");
        this.print(send_string);
    }

    private void onClear() {
        this.output_textarea.setText("");
    }

    private void onProxy() {
        Proxy p = this.socks_dialog.getProxy(this.proxy);
        if (p != null) {
            this.proxy = p;
        }
        if (this.proxy != null && this.proxy instanceof Socks5Proxy) {
            ((Socks5Proxy)this.proxy).resolveAddrLocally(false);
        }
    }

    private void onQuit() {
        this.dispose();
        System.exit(0);
    }

    private boolean readPort() {
        try {
            this.port = Integer.parseInt(this.port_text.getText());
        }
        catch (NumberFormatException nfe) {
            this.warn("Port invalid!");
            return false;
        }
        return true;
    }

    private boolean readHost() {
        this.host = this.host_text.getText();
        this.host.trim();
        if (this.host.length() < 1) {
            this.warn("Host is not set");
            return false;
        }
        return true;
    }

    private void status(String s) {
        this.status_label.setText(s);
    }

    private void println(String s) {
        this.output_textarea.append(s + "\n");
    }

    private void print(String s) {
        this.output_textarea.append(s);
    }

    private void warn(String s) {
        this.status(s);
    }

    private void startNetThread(int m) {
        this.mode = m;
        this.net_thread = new Thread(this);
        this.net_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort_connection() {
        Object object = this.net_lock;
        synchronized (object) {
            if (this.mode == 3) {
                return;
            }
            this.mode = 4;
            if (this.net_thread != null) {
                try {
                    if (this.sock != null) {
                        this.sock.close();
                    }
                    if (this.server_sock != null) {
                        this.server_sock.close();
                    }
                    if (this.udp_sock != null) {
                        this.udp_sock.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.net_thread.interrupt();
                this.net_thread = null;
            }
        }
    }

    private void doAccept() throws IOException {
        this.println("Trying to accept from " + this.host);
        this.status("Trying to accept from " + this.host);
        this.println("Using proxy:" + this.proxy);
        this.server_sock = new SocksServerSocket(this.proxy, this.host, this.port);
        this.println("Listenning on: " + this.server_sock.getInetAddress() + ":" + this.server_sock.getLocalPort());
        this.sock = this.server_sock.accept();
        this.println("Accepted from:" + this.sock.getInetAddress() + ":" + this.sock.getPort());
        this.status("Accepted from:" + this.sock.getInetAddress().getHostAddress() + ":" + this.sock.getPort());
        this.server_sock.close();
    }

    private void doConnect() throws IOException {
        this.println("Trying to connect to:" + this.host + ":" + this.port);
        this.println("Using proxy:" + this.proxy);
        this.sock = new SocksSocket(this.proxy, this.host, this.port);
        this.println("Connected to:" + this.sock.getInetAddress() + ":" + this.port);
        this.status("Connected to: " + this.sock.getInetAddress().getHostAddress() + ":" + this.port);
        this.println("Via-Proxy:" + this.sock.getLocalAddress() + ":" + this.sock.getLocalPort());
    }

    private void doPipe() throws IOException {
        int bytes_read;
        this.out = this.sock.getOutputStream();
        this.in = this.sock.getInputStream();
        byte[] buf = new byte[1024];
        while ((bytes_read = this.in.read(buf)) > 0) {
            this.print(new String(buf, 0, bytes_read));
        }
    }

    private void startUDP() throws IOException {
        this.udp_sock = new Socks5DatagramSocket(this.proxy, 0, null);
        this.println("UDP started on " + this.udp_sock.getLocalAddress() + ":" + this.udp_sock.getLocalPort());
        this.status("UDP:" + this.udp_sock.getLocalAddress().getHostAddress() + ":" + this.udp_sock.getLocalPort());
    }

    private void doUDPPipe() throws IOException {
        DatagramPacket dp = new DatagramPacket(new byte[1024], 1024);
        while (true) {
            this.udp_sock.receive(dp);
            this.print("UDP\nFrom:" + dp.getAddress() + ":" + dp.getPort() + "\n" + "\n" + new String(dp.getData(), 0, dp.getLength()) + "\n");
            dp.setLength(1024);
        }
    }

    private void sendUDP(String message, String host, int port) {
        if (!this.udp_sock.isProxyAlive(100)) {
            this.status("Proxy closed connection");
            this.abort_connection();
            return;
        }
        try {
            byte[] data = message.getBytes();
            DatagramPacket dp = new DatagramPacket(data, data.length, null, port);
            this.udp_sock.send(dp, host);
        }
        catch (UnknownHostException uhe) {
            this.status("Host " + host + " has no DNS entry.");
        }
        catch (IOException ioe) {
            this.status("IOException:" + ioe);
            this.abort_connection();
        }
    }

    private void send(String s) {
        try {
            this.out.write(s.getBytes());
        }
        catch (IOException io_ex) {
            this.println("IOException:" + io_ex);
            this.abort_connection();
        }
    }

    void guiInit() {
        GridBagConstraints c = new GridBagConstraints();
        SocksEcho container = this;
        container.setLayout(new GridBagLayout());
        ((Component)container).setBackground(SystemColor.menu);
        c.insets = new Insets(3, 3, 3, 3);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 12;
        Label label = new Label("Host:");
        container.add((Component)label, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 12;
        label = new Label("Port:");
        container.add((Component)label, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.status_label = new Label("");
        container.add((Component)this.status_label, c);
        c.insets = new Insets(3, 3, 3, 3);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.anchor = 18;
        c.fill = 2;
        this.host_text = new TextField("");
        container.add((Component)this.host_text, c);
        c.weightx = 1.0;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        this.port_text = new TextField("", 5);
        container.add((Component)this.port_text, c);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.anchor = 18;
        this.input_text = new TextField("");
        container.add((Component)this.input_text, c);
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 12;
        this.connect_button = new Button("Connect");
        container.add((Component)this.connect_button, c);
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        this.accept_button = new Button("Accept");
        container.add((Component)this.accept_button, c);
        c.gridx = 4;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        this.udp_button = new Button("UDP");
        container.add((Component)this.udp_button, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        this.proxy_button = new Button("Proxy...");
        container.add((Component)this.proxy_button, c);
        c.gridx = 3;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 12;
        this.clear_button = new Button("Clear");
        container.add((Component)this.clear_button, c);
        c.gridx = 4;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        this.quit_button = new Button("Quit");
        container.add((Component)this.quit_button, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.anchor = 18;
        this.output_textarea = new TextArea("", 10, 50);
        this.output_textarea.setFont(new Font("Monospaced", 0, 11));
        this.output_textarea.setEditable(false);
        container.add((Component)this.output_textarea, c);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getWindow() == this) {
            this.onQuit();
        } else {
            e.getWindow().dispose();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public static void main(String[] args) {
        SocksEcho socksecho = new SocksEcho();
        socksecho.pack();
        socksecho.show();
    }
}

