/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.HostPort;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.From;
import java.text.ParseException;
import javax.sip.header.ToHeader;

public final class To
extends AddressParametersHeader
implements ToHeader {
    private static final long serialVersionUID = -4057413800584586316L;

    public To() {
        super("To", true);
    }

    public To(From from) {
        super("To");
        this.setAddress(from.address);
        this.setParameters(from.parameters);
    }

    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer stringBuffer) {
        if (this.address != null) {
            if (this.address.getAddressType() == 2) {
                stringBuffer.append("<");
            }
            this.address.encode(stringBuffer);
            if (this.address.getAddressType() == 2) {
                stringBuffer.append(">");
            }
            if (!this.parameters.isEmpty()) {
                stringBuffer.append(";");
                this.parameters.encode(stringBuffer);
            }
        }
        return stringBuffer;
    }

    public HostPort getHostPort() {
        if (this.address == null) {
            return null;
        }
        return this.address.getHostPort();
    }

    public String getDisplayName() {
        if (this.address == null) {
            return null;
        }
        return this.address.getDisplayName();
    }

    public String getTag() {
        if (this.parameters == null) {
            return null;
        }
        return this.getParameter("tag");
    }

    public boolean hasTag() {
        if (this.parameters == null) {
            return false;
        }
        return this.hasParameter("tag");
    }

    public void removeTag() {
        if (this.parameters != null) {
            this.parameters.delete("tag");
        }
    }

    public void setTag(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null tag ");
        }
        if (string.trim().equals("")) {
            throw new ParseException("bad tag", 0);
        }
        this.setParameter("tag", string);
    }

    public String getUserAtHostPort() {
        if (this.address == null) {
            return null;
        }
        return this.address.getUserAtHostPort();
    }

    public boolean equals(Object object) {
        return object instanceof ToHeader && super.equals(object);
    }
}

