/*
 * Decompiled with CFR 0.152.
 */
package socks.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.DatagramPacket;
import java.net.Socket;
import socks.ProxyMessage;
import socks.UDPEncapsulation;
import socks.server.ServerAuthenticator;

public class ServerAuthenticatorNone
implements ServerAuthenticator {
    static final byte[] socks5response = new byte[]{5, 0};
    InputStream in;
    OutputStream out;

    public ServerAuthenticatorNone() {
        this.in = null;
        this.out = null;
    }

    public ServerAuthenticatorNone(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public ServerAuthenticator startSession(Socket s) throws IOException {
        PushbackInputStream in = new PushbackInputStream(s.getInputStream());
        OutputStream out = s.getOutputStream();
        int version = in.read();
        if (version == 5) {
            if (!ServerAuthenticatorNone.selectSocks5Authentication(in, out, 0)) {
                return null;
            }
        } else if (version == 4) {
            in.unread(version);
        } else {
            return null;
        }
        return new ServerAuthenticatorNone(in, out);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public UDPEncapsulation getUdpEncapsulation() {
        return null;
    }

    public boolean checkRequest(ProxyMessage msg) {
        return true;
    }

    public boolean checkRequest(DatagramPacket dp, boolean out) {
        return true;
    }

    public void endSession() {
    }

    public static boolean selectSocks5Authentication(InputStream in, OutputStream out, int methodId) throws IOException {
        int num_methods = in.read();
        if (num_methods <= 0) {
            return false;
        }
        byte[] method_ids = new byte[num_methods];
        byte[] response = new byte[2];
        boolean found = false;
        response[0] = 5;
        response[1] = -1;
        for (int bread = 0; bread < num_methods; bread += in.read(method_ids, bread, num_methods - bread)) {
        }
        for (int i = 0; i < num_methods; ++i) {
            if (method_ids[i] != methodId) continue;
            found = true;
            response[1] = (byte)methodId;
            break;
        }
        out.write(response);
        return found;
    }
}

