/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import socks.SocksException;

public abstract class ProxyMessage {
    public InetAddress ip = null;
    public int version;
    public int port;
    public int command;
    public String host = null;
    public String user = null;

    ProxyMessage(int command, InetAddress ip, int port) {
        this.command = command;
        this.ip = ip;
        this.port = port;
    }

    ProxyMessage() {
    }

    public abstract void read(InputStream var1) throws SocksException, IOException;

    public abstract void read(InputStream var1, boolean var2) throws SocksException, IOException;

    public abstract void write(OutputStream var1) throws SocksException, IOException;

    public InetAddress getInetAddress() throws UnknownHostException {
        return this.ip;
    }

    public String toString() {
        return "Proxy Message:\nVersion:" + this.version + "\n" + "Command:" + this.command + "\n" + "IP:     " + this.ip + "\n" + "Port:   " + this.port + "\n" + "User:   " + this.user + "\n";
    }

    static final String bytes2IPV4(byte[] addr, int offset) {
        String hostName = "" + (addr[offset] & 0xFF);
        for (int i = offset + 1; i < offset + 4; ++i) {
            hostName = hostName + "." + (addr[i] & 0xFF);
        }
        return hostName;
    }

    static final String bytes2IPV6(byte[] addr, int offset) {
        return null;
    }
}

