/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import net.sf.jml.Email;
import net.sf.jml.MsnClientId;
import net.sf.jml.MsnObject;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringUtils;

public class IncomingILN
extends MsnIncomingMessage {
    public IncomingILN(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    public MsnUserStatus getUserStatus() {
        return MsnUserStatus.parseStr(this.getParam(0));
    }

    public Email getEmail() {
        return Email.parseStr(this.getParam(1));
    }

    public String getDisplayName() {
        if (this.protocol.after(MsnProtocol.MSNP13)) {
            return StringUtils.urlDecode(this.getParam(3));
        }
        return StringUtils.urlDecode(this.getParam(2));
    }

    public int getClientId() {
        if (this.protocol.after(MsnProtocol.MSNP14)) {
            return NumberUtils.stringToInt(this.getParam(4));
        }
        return NumberUtils.stringToInt(this.getParam(3));
    }

    public MsnObject getMsnObject() {
        String string = null;
        string = this.protocol.before(MsnProtocol.MSNP13) ? this.getParam(4) : this.getParam(5);
        if (string != null && !string.equals("0")) {
            return MsnObject.parseMsnObject(StringUtils.urlDecode(string));
        }
        return null;
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnContactImpl msnContactImpl = (MsnContactImpl)msnSession.getMessenger().getContactList().getContactByEmail(this.getEmail());
        if (msnContactImpl != null) {
            msnContactImpl.setDisplayName(this.getDisplayName());
            msnContactImpl.setClientId(MsnClientId.parseInt(this.getClientId()));
            msnContactImpl.setStatus(this.getUserStatus());
            MsnObject msnObject = this.getMsnObject();
            if (msnObject != null) {
                msnContactImpl.setAvatar(msnObject);
            }
            ((AbstractMessenger)msnSession.getMessenger()).fireContactStatusChanged(msnContactImpl);
        }
    }
}

