/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.openymsg.network.PropertyConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util
implements PropertyConstants {
    private static final String[] ENTITIES_STR = new String[]{"apos", "quot", "amp", "lt", "gt", "nbsp", "curren", "cent", "pound", "yen", "copy"};
    private static final char[] ENTITIES_CHR = new char[]{'\'', '\"', '&', '<', '>', ' ', '\u00a4', '\u00a2', '\u00a3', '\u00a5', '\u00a9'};

    public static int loginTimeout(int def) {
        int loginTimeout = Integer.parseInt(System.getProperty("openymsg.network.loginTimeout", "" + def)) * 1000;
        if (loginTimeout <= 0) {
            loginTimeout = Integer.MAX_VALUE;
        }
        return loginTimeout;
    }

    public static String directHost() {
        return System.getProperty("openymsg.network.directHost", "scs.msg.yahoo.com");
    }

    static int[] directPorts() {
        String s = System.getProperty("openymsg.network.directPorts");
        if (s == null) {
            return DIRECT_PORTS_DEFAULT;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        int[] arr = new int[st.countTokens()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Integer.parseInt(st.nextToken());
        }
        return arr;
    }

    public static int directPort() {
        return Util.directPorts()[0];
    }

    public static String httpHost() {
        return System.getProperty("openymsg.network.httpHost", "http.pager.yahoo.com");
    }

    public static String httpProxyAuth() {
        return System.getProperty("openymsg.network.httpProxyAuth");
    }

    public static String fileTransferHost() {
        return System.getProperty("openymsg.network.fileTransferHost", "filetransfer.msg.yahoo.com");
    }

    public static String httpProxyHost() {
        String host = System.getProperty("http.proxyHost");
        if (host == null) {
            host = System.getProperty("proxyHost");
        }
        return host;
    }

    public static int httpProxyPort() {
        String port = System.getProperty("http.proxyPort");
        if (port == null) {
            port = System.getProperty("proxyPort");
        }
        if (port == null) {
            port = "8080";
        }
        return Integer.parseInt(port);
    }

    public static void initURLConnection(URLConnection uc) {
        String proxyAuthContent = Util.httpProxyAuth();
        if (proxyAuthContent != null) {
            uc.setRequestProperty("Proxy-Authorization", proxyAuthContent);
        }
    }

    public static String _base64(String table, char pad, byte[] buffer) {
        int i;
        int limit = buffer.length - buffer.length % 3;
        StringBuffer out = new StringBuffer();
        int[] buff = new int[buffer.length];
        for (i = 0; i < buffer.length; ++i) {
            buff[i] = buffer[i] & 0xFF;
        }
        for (i = 0; i < limit; i += 3) {
            out.append(table.charAt(buff[i] >> 2));
            out.append(table.charAt(buff[i] << 4 & 0x30 | buff[i + 1] >> 4));
            out.append(table.charAt(buff[i + 1] << 2 & 0x3C | buff[i + 2] >> 6));
            out.append(table.charAt(buff[i + 2] & 0x3F));
        }
        i = limit;
        switch (buff.length - i) {
            case 1: {
                out.append(table.charAt(buff[i] >> 2));
                out.append(table.charAt(buff[i] << 4 & 0x30));
                out.append(pad).append(pad);
                break;
            }
            case 2: {
                out.append(table.charAt(buff[i] >> 2));
                out.append(table.charAt(buff[i] << 4 & 0x30 | buff[i + 1] >> 4));
                out.append(table.charAt(buff[i + 1] << 2 & 0x3C));
                out.append(pad);
            }
        }
        return out.toString();
    }

    public static String base64(byte[] buffer) {
        return Util._base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", '=', buffer);
    }

    public static final boolean isUtf8(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static String entityDecode(String s) {
        StringBuffer result = new StringBuffer();
        int i1 = s.indexOf("&");
        while (i1 >= 0) {
            int i2 = s.indexOf(";");
            if (i2 >= 0 && i2 > i1 + 1) {
                result.append(s.substring(0, i1));
                String ent = s.substring(i1 + 1, i2).toLowerCase();
                int j = 0;
                for (j = 0; j < ENTITIES_STR.length; ++j) {
                    if (!ENTITIES_STR[j].equals(ent)) continue;
                    result.append(ENTITIES_CHR[j]);
                    break;
                }
                if (j >= ENTITIES_STR.length) {
                    result.append('&');
                    result.append(ent);
                    result.append(';');
                }
                s = s.substring(i2 + 1);
            } else {
                result.append(s.substring(0, i1 + 1));
                s = s.substring(i1 + 1);
            }
            i1 = s.indexOf("&");
        }
        result.append(s);
        return result.toString();
    }

    public static int[] yahoo64Decode(String s) {
        if (s.length() % 4 != 0) {
            throw new IllegalArgumentException("Source string incomplete");
        }
        int len = s.length() / 4;
        if (s.endsWith("--")) {
            len -= 2;
        } else if (s.endsWith("-")) {
            --len;
        }
        int[] buffer = new int[len];
        int[] c = new int[4];
        int bpos = 0;
        try {
            for (int i = 0; i < s.length(); i += 4) {
                int j = 0;
                while (i < c.length) {
                    c[j] = Util._c2b(s.charAt(i + j));
                    ++j;
                }
                buffer[bpos + 0] = (c[0] << 2) + (c[1] >> 4) & 0xFF;
                buffer[bpos + 1] = (c[1] & 0xF) << 4 + (c[2] >> 2) & 0xFF;
                buffer[bpos + 2] = (c[2] & 3) << 6 + c[3] & 0xFF;
                bpos += 3;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return buffer;
    }

    private static int _c2b(int c) {
        if (c >= 65 && c <= 90) {
            return c - 65;
        }
        if (c >= 97 && c <= 122) {
            return c - 97 + 26;
        }
        if (c >= 48 && c <= 57) {
            return c - 48 + 52;
        }
        if (c == 46) {
            return 62;
        }
        if (c == 95) {
            return 63;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = null;
        try {
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static String getValue(Hashtable<String, String> table, String key, String defaultValue) {
        if (table.containsKey(key)) {
            return table.get(key);
        }
        return defaultValue;
    }
}

