/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.Writable;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class InvitationMessage
implements LiveWritable {
    private static final int TYPE_LANGUAGE = 14;
    private static final int TYPE_CHARSET = 13;
    private static final int TYPE_MESSAGE = 12;
    private final Locale language;
    private final String message;

    public static InvitationMessage readInvitationMessage(TlvChain chain) {
        DefensiveTools.checkNull((Object)chain, (String)"chain");
        String charset = chain.getString(13);
        String message = charset == null ? chain.getString(12) : chain.getString(12, charset);
        String languageStr = chain.getString(14);
        Locale language = languageStr == null ? null : new Locale(languageStr);
        return new InvitationMessage(message, language);
    }

    public InvitationMessage(String message) {
        this(message, Locale.getDefault());
    }

    public InvitationMessage(String message, Locale language) {
        this.language = language;
        this.message = message;
    }

    public final Locale getLanguage() {
        return this.language;
    }

    public final String getMessage() {
        return this.message;
    }

    public void write(OutputStream out) throws IOException {
        if (this.language != null) {
            String lang = this.language.getLanguage();
            Tlv.getStringInstance(14, lang).write(out);
        }
        if (this.message != null) {
            EncodedStringInfo encInfo = MinimalEncoder.encodeMinimally(this.message);
            String charset = encInfo.getCharset();
            Tlv.getStringInstance(13, charset).write(out);
            new Tlv(12, (Writable)ByteBlock.wrap((byte[])encInfo.getData())).write(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvitationMessage)) {
            return false;
        }
        InvitationMessage other = (InvitationMessage)o;
        if (this.language != null ? !this.language.getLanguage().equals(other.language.getLanguage()) : other.language != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(other.message) : other.message != null);
    }

    public int hashCode() {
        int result = this.language != null ? this.language.hashCode() : 0;
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "InvitationMessage: \"" + this.message + "\" (" + (this.language == null ? "language=null" : "in " + this.language.getLanguage()) + ")";
    }
}

