/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmyspaceiml;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.sf.jmyspaceiml.RC4EncryptionExample;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class LoginResponse {
    static final int HASH_SIZE = 20;
    static final int NONCE_SIZE = 32;
    static final char[] MSIM_LOGIN_IP_LIST = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0005', '\u007f', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\n', '\u0000', '\u0000', '@', '\u00c0', '\u00a8', 'X', '\u0001', '\u00c0', '\u00a8', '<', '\u0001'};

    public byte[] compute(byte[] nc, String email, String password) throws Exception {
        byte[] nonce0 = new byte[32];
        byte[] nonce1 = new byte[32];
        for (int i = 0; i < 32; ++i) {
            nonce0[i] = nc[i];
            nonce1[i] = nc[i + 32];
        }
        byte[] hashedPassword = this.hashPassword(password.toLowerCase());
        byte[] key = this.createKey(hashedPassword, nonce1);
        return this.encryptMessage(key, nonce0, email);
    }

    byte[] createKey(byte[] hashedPassword, byte[] nonce) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(hashedPassword, 0, 20);
        md.update(nonce, 0, 32);
        byte[] hash = md.digest();
        byte[] retval = new byte[16];
        for (int i = 0; i < 16; ++i) {
            retval[i] = hash[i];
        }
        return retval;
    }

    byte[] hashPassword(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(s.getBytes("UTF-16LE"));
        return md.digest();
    }

    byte[] encryptMessage(byte[] key, byte[] nonce, String email) throws RC4EncryptionExample.EncryptionException {
        String data = new String(nonce) + email + new String(MSIM_LOGIN_IP_LIST);
        RC4EncryptionExample rc4 = new RC4EncryptionExample(key);
        return rc4.encrypt(data.getBytes());
    }

    public byte[] decode64(String encryptedBytes64) throws IOException {
        return new BASE64Decoder().decodeBuffer(encryptedBytes64);
    }

    public String encode64(byte[] data) {
        return new BASE64Encoder().encode(data);
    }
}

