/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexModifier {
    protected IndexWriter indexWriter = null;
    protected IndexReader indexReader = null;
    protected Directory directory = null;
    protected Analyzer analyzer = null;
    protected boolean open = false;
    protected PrintStream infoStream = null;
    protected boolean useCompoundFile = true;
    protected int maxBufferedDocs = 10;
    protected int maxFieldLength = 10000;
    protected int mergeFactor = 10;

    public IndexModifier(Directory directory, Analyzer analyzer, boolean create) throws IOException {
        this.init(directory, analyzer, create);
    }

    public IndexModifier(String dirName, Analyzer analyzer, boolean create) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(dirName, create);
        this.init(dir, analyzer, create);
    }

    public IndexModifier(File file, Analyzer analyzer, boolean create) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(file, create);
        this.init(dir, analyzer, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(Directory directory, Analyzer analyzer, boolean create) throws IOException {
        Directory directory2 = this.directory = directory;
        synchronized (directory2) {
            this.analyzer = analyzer;
            this.indexWriter = new IndexWriter(directory, analyzer, create);
            this.open = true;
        }
    }

    protected void assureOpen() {
        if (!this.open) {
            throw new IllegalStateException("Index is closed");
        }
    }

    protected void createIndexWriter() throws IOException {
        if (this.indexWriter == null) {
            if (this.indexReader != null) {
                this.indexReader.close();
                this.indexReader = null;
            }
            this.indexWriter = new IndexWriter(this.directory, this.analyzer, false);
            this.indexWriter.setInfoStream(this.infoStream);
            this.indexWriter.setUseCompoundFile(this.useCompoundFile);
            this.indexWriter.setMaxBufferedDocs(this.maxBufferedDocs);
            this.indexWriter.setMaxFieldLength(this.maxFieldLength);
            this.indexWriter.setMergeFactor(this.mergeFactor);
        }
    }

    protected void createIndexReader() throws IOException {
        if (this.indexReader == null) {
            if (this.indexWriter != null) {
                this.indexWriter.close();
                this.indexWriter = null;
            }
            this.indexReader = IndexReader.open(this.directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            if (this.indexWriter != null) {
                this.indexWriter.close();
                this.indexWriter = null;
                this.createIndexWriter();
            } else {
                this.indexReader.close();
                this.indexReader = null;
                this.createIndexReader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer docAnalyzer) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexWriter();
            if (docAnalyzer != null) {
                this.indexWriter.addDocument(doc, docAnalyzer);
            } else {
                this.indexWriter.addDocument(doc);
            }
        }
    }

    public void addDocument(Document doc) throws IOException {
        this.addDocument(doc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteDocuments(Term term) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexReader();
            return this.indexReader.deleteDocuments(term);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDocument(int docNum) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexReader();
            this.indexReader.deleteDocument(docNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int docCount() {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            if (this.indexWriter != null) {
                return this.indexWriter.docCount();
            }
            return this.indexReader.numDocs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexWriter();
            this.indexWriter.optimize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfoStream(PrintStream infoStream) {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            if (this.indexWriter != null) {
                this.indexWriter.setInfoStream(infoStream);
            }
            this.infoStream = infoStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream getInfoStream() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexWriter();
            return this.indexWriter.getInfoStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseCompoundFile(boolean useCompoundFile) {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            if (this.indexWriter != null) {
                this.indexWriter.setUseCompoundFile(useCompoundFile);
            }
            this.useCompoundFile = useCompoundFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseCompoundFile() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexWriter();
            return this.indexWriter.getUseCompoundFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldLength(int maxFieldLength) {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            if (this.indexWriter != null) {
                this.indexWriter.setMaxFieldLength(maxFieldLength);
            }
            this.maxFieldLength = maxFieldLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxFieldLength() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexWriter();
            return this.indexWriter.getMaxFieldLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBufferedDocs(int maxBufferedDocs) {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            if (this.indexWriter != null) {
                this.indexWriter.setMaxBufferedDocs(maxBufferedDocs);
            }
            this.maxBufferedDocs = maxBufferedDocs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxBufferedDocs() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexWriter();
            return this.indexWriter.getMaxBufferedDocs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMergeFactor(int mergeFactor) {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            if (this.indexWriter != null) {
                this.indexWriter.setMergeFactor(mergeFactor);
            }
            this.mergeFactor = mergeFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMergeFactor() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.assureOpen();
            this.createIndexWriter();
            return this.indexWriter.getMergeFactor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            if (!this.open) {
                throw new IllegalStateException("Index is closed already");
            }
            if (this.indexWriter != null) {
                this.indexWriter.close();
                this.indexWriter = null;
            } else {
                this.indexReader.close();
                this.indexReader = null;
            }
            this.open = false;
        }
    }

    public String toString() {
        return "Index@" + this.directory;
    }
}

