/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.CompositeConfigurationListener;
import org.logicalcobwebs.proxool.CompositeProxoolListener;
import org.logicalcobwebs.proxool.ConfigurationListenerIF;
import org.logicalcobwebs.proxool.ConnectionListenerIF;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.ConnectionPoolStatisticsIF;
import org.logicalcobwebs.proxool.HouseKeeperController;
import org.logicalcobwebs.proxool.PrototyperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolListenerIF;
import org.logicalcobwebs.proxool.ProxyFactory;
import org.logicalcobwebs.proxool.ShutdownHook;
import org.logicalcobwebs.proxool.StateListenerIF;
import org.logicalcobwebs.proxool.Version;
import org.logicalcobwebs.proxool.WrappedConnection;
import org.logicalcobwebs.proxool.admin.Admin;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.logicalcobwebs.proxool.admin.StatisticsIF;
import org.logicalcobwebs.proxool.admin.StatisticsListenerIF;

public class ProxoolFacade {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$ProxoolFacade == null ? (class$org$logicalcobwebs$proxool$ProxoolFacade = ProxoolFacade.class$("org.logicalcobwebs.proxool.ProxoolFacade")) : class$org$logicalcobwebs$proxool$ProxoolFacade));
    private static Map configurators = new HashMap();
    private static CompositeProxoolListener compositeProxoolListener = new CompositeProxoolListener();
    private static boolean versionLogged = false;
    private static Thread shutdownHook;
    private static boolean shutdownHookEnabled;
    private static final boolean MERCIFUL = true;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxoolFacade;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxoolDriver;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;

    public static synchronized String registerConnectionPool(String url, Properties info) throws ProxoolException {
        return ProxoolFacade.registerConnectionPool(url, info, true);
    }

    protected static synchronized String registerConnectionPool(String url, Properties info, boolean explicitRegister) throws ProxoolException {
        String alias = ProxoolFacade.getAlias(url);
        if (!versionLogged) {
            versionLogged = true;
            LOG.info((Object)("Proxool " + Version.getVersion()));
        }
        try {
            Class.forName((class$org$logicalcobwebs$proxool$ProxoolDriver == null ? (class$org$logicalcobwebs$proxool$ProxoolDriver = ProxoolFacade.class$("org.logicalcobwebs.proxool.ProxoolDriver")) : class$org$logicalcobwebs$proxool$ProxoolDriver).getName());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Couldn't load " + (class$org$logicalcobwebs$proxool$ProxoolDriver == null ? (class$org$logicalcobwebs$proxool$ProxoolDriver = ProxoolFacade.class$("org.logicalcobwebs.proxool.ProxoolDriver")) : class$org$logicalcobwebs$proxool$ProxoolDriver).getName()));
        }
        if (ConnectionPoolManager.getInstance().isPoolExists(alias)) {
            throw new ProxoolException("Attempt to register duplicate pool called '" + alias + "'");
        }
        ConnectionPoolDefinition cpd = new ConnectionPoolDefinition(url, info, explicitRegister);
        ProxoolFacade.registerConnectionPool(cpd);
        return alias;
    }

    protected static synchronized void registerConnectionPool(ConnectionPoolDefinition connectionPoolDefinition) throws ProxoolException {
        if (!ConnectionPoolManager.getInstance().isPoolExists(connectionPoolDefinition.getAlias())) {
            Properties jndiProperties = ProxoolFacade.extractJndiProperties(connectionPoolDefinition);
            ConnectionPool connectionPool = ConnectionPoolManager.getInstance().createConnectionPool(connectionPoolDefinition);
            connectionPool.start();
            compositeProxoolListener.onRegistration(connectionPoolDefinition, connectionPoolDefinition.getCompleteInfo());
            if (ProxoolFacade.isConfiguredForJMX(connectionPoolDefinition.getCompleteInfo())) {
                ProxoolFacade.registerForJmx(connectionPoolDefinition.getAlias(), connectionPoolDefinition.getCompleteInfo());
            }
            if (jndiProperties != null) {
                ProxoolFacade.registerDataSource(connectionPoolDefinition.getAlias(), jndiProperties);
            }
        } else {
            LOG.debug((Object)("Ignoring duplicate attempt to register " + connectionPoolDefinition.getAlias() + " pool"));
        }
    }

    public static void registerConnectionPool(String url) throws ProxoolException {
        ProxoolFacade.registerConnectionPool(url, null);
    }

    protected static String getAlias(String url) throws ProxoolException {
        String alias = null;
        String prefix = "proxool.";
        if (url.startsWith("proxool.")) {
            int endOfPrefix = url.indexOf(":");
            alias = endOfPrefix > -1 ? url.substring("proxool.".length(), endOfPrefix) : url.substring("proxool.".length());
        }
        if (alias == null || alias.length() == 0) {
            throw new ProxoolException("The URL '" + url + "' is not in the correct form. It should be: 'proxool.alias:driver:url'");
        }
        return alias;
    }

    private static void removeConnectionPool(String finalizer, ConnectionPool connectionPool, int delay) {
        String alias = connectionPool.getDefinition().getAlias();
        if (connectionPool != null) {
            try {
                compositeProxoolListener.onShutdown(alias);
                connectionPool.shutdown(delay, finalizer);
            }
            catch (Throwable t) {
                LOG.error((Object)("Problem trying to shutdown '" + alias + "' connection pool"), t);
            }
        }
        connectionPool = null;
    }

    public static void removeConnectionPool(String alias, int delay) throws ProxoolException {
        ProxoolFacade.removeConnectionPool(Thread.currentThread().getName(), ConnectionPoolManager.getInstance().getConnectionPool(alias), delay);
    }

    public static void removeAllConnectionPools(int delay) {
        ProxoolFacade.shutdown(Thread.currentThread().getName(), delay);
    }

    public static void shutdown() {
        ProxoolFacade.shutdown(Thread.currentThread().getName(), 0);
    }

    public static void shutdown(int delay) {
        ProxoolFacade.shutdown(Thread.currentThread().getName(), delay);
    }

    protected static void shutdown(String finalizer, int delay) {
        block4: {
            ConnectionPool[] cps = ConnectionPoolManager.getInstance().getConnectionPools();
            for (int i = 0; i < cps.length; ++i) {
                ProxoolFacade.removeConnectionPool(finalizer, cps[i], delay);
            }
            try {
                if (shutdownHook != null) {
                    ShutdownHook.remove(shutdownHook);
                }
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"Unanticipated error during removal of ShutdownHook. Ignoring it.", t);
            }
        }
        PrototyperController.shutdown();
        HouseKeeperController.shutdown();
    }

    public static void disableShutdownHook() {
        shutdownHookEnabled = false;
    }

    public static void enableShutdownHook() {
        shutdownHookEnabled = true;
    }

    public static boolean isShutdownHookEnabled() {
        return shutdownHookEnabled;
    }

    public static void removeConnectionPool(String alias) throws ProxoolException {
        ProxoolFacade.removeConnectionPool(alias, 0);
    }

    public static ConnectionPoolStatisticsIF getConnectionPoolStatistics(String alias) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(alias);
    }

    public static String getConnectionPoolStatisticsDump(String alias) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(alias).displayStatistics();
    }

    public static ConnectionPoolDefinitionIF getConnectionPoolDefinition(String alias) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(alias).getDefinition();
    }

    public static Collection getConnectionInfos(String alias) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(alias).getConnectionInfos();
    }

    public static void killAllConnections(String alias, boolean merciful) throws ProxoolException {
        ProxoolFacade.killAllConnections(alias, "of thread " + Thread.currentThread().getName(), merciful);
    }

    public static void killAllConnections(String alias, String reason, boolean merciful) throws ProxoolException {
        ConnectionPoolManager.getInstance().getConnectionPool(alias).expireAllConnections(2, reason, merciful);
    }

    public static void killAllConnections(String alias) throws ProxoolException {
        ProxoolFacade.killAllConnections(alias, "of thread " + Thread.currentThread().getName(), true);
    }

    public static void killAllConnections(String alias, String reason) throws ProxoolException {
        ProxoolFacade.killAllConnections(alias, reason, true);
    }

    public static boolean killConnecton(String alias, long id, boolean merciful) throws ProxoolException {
        boolean forceExpiry = !merciful;
        return ConnectionPoolManager.getInstance().getConnectionPool(alias).expireConnection(id, forceExpiry);
    }

    public static boolean killConnecton(Connection connection, boolean merciful) throws ProxoolException {
        WrappedConnection wrappedConnection = ProxyFactory.getWrappedConnection(connection);
        if (wrappedConnection != null) {
            long id = wrappedConnection.getId();
            String alias = wrappedConnection.getAlias();
            return ProxoolFacade.killConnecton(alias, id, merciful);
        }
        throw new ProxoolException("Attempt to kill unrecognised exception " + connection);
    }

    public static void addProxoolListener(ProxoolListenerIF proxoolListener) {
        compositeProxoolListener.addListener(proxoolListener);
    }

    public static boolean removeProxoolListener(ProxoolListenerIF proxoolListener) {
        return compositeProxoolListener.removeListener(proxoolListener);
    }

    public static void setStateListener(String alias, StateListenerIF stateListener) throws ProxoolException {
        ProxoolFacade.addStateListener(alias, stateListener);
    }

    public static void addStateListener(String alias, StateListenerIF stateListener) throws ProxoolException {
        ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
        cp.addStateListener(stateListener);
    }

    public static boolean removeStateListener(String alias, StateListenerIF stateListener) throws ProxoolException {
        ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
        return cp.removeStateListener(stateListener);
    }

    public static void setConnectionListener(String alias, ConnectionListenerIF connectionListener) throws ProxoolException {
        ProxoolFacade.addConnectionListener(alias, connectionListener);
    }

    public static void addConnectionListener(String alias, ConnectionListenerIF connectionListener) throws ProxoolException {
        ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
        cp.addConnectionListener(connectionListener);
    }

    public static boolean removeConnectionListener(String alias, ConnectionListenerIF connectionListener) throws ProxoolException {
        ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
        return cp.removeConnectionListener(connectionListener);
    }

    public static void setConfigurationListener(String alias, ConfigurationListenerIF configurationListener) throws ProxoolException {
        ProxoolFacade.addConfigurationListener(alias, configurationListener);
    }

    public static void addConfigurationListener(String alias, ConfigurationListenerIF configurationListener) throws ProxoolException {
        CompositeConfigurationListener compositeConfigurationListener;
        if (ConnectionPoolManager.getInstance().isPoolExists(alias)) {
            compositeConfigurationListener = (CompositeConfigurationListener)configurators.get(alias);
            if (compositeConfigurationListener == null) {
                compositeConfigurationListener = new CompositeConfigurationListener();
                configurators.put(alias, compositeConfigurationListener);
            }
        } else {
            throw new ProxoolException(ConnectionPoolManager.getInstance().getKnownPools(alias));
        }
        compositeConfigurationListener.addListener(configurationListener);
    }

    protected static void definitionUpdated(String alias, ConnectionPoolDefinitionIF connectionPoolDefinition, Properties completeInfo, Properties changedInfo) {
        CompositeConfigurationListener ccl = (CompositeConfigurationListener)configurators.get(alias);
        if (ccl != null) {
            ccl.definitionUpdated(connectionPoolDefinition, completeInfo, changedInfo);
        }
    }

    public static boolean removeConfigurationListener(String alias, ConfigurationListenerIF configurationListener) throws ProxoolException {
        boolean removed = false;
        if (ConnectionPoolManager.getInstance().isPoolExists(alias)) {
            CompositeConfigurationListener compositeConfigurationListener = (CompositeConfigurationListener)configurators.get(alias);
            if (compositeConfigurationListener != null) {
                removed = compositeConfigurationListener.removeListener(configurationListener);
            }
        } else {
            throw new ProxoolException(ConnectionPoolManager.getInstance().getKnownPools(alias));
        }
        return removed;
    }

    public static void redefineConnectionPool(String url, Properties info) throws ProxoolException {
        String alias = ProxoolFacade.getAlias(url);
        ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
        try {
            ConnectionPoolDefinition cpd = (ConnectionPoolDefinition)cp.getDefinition().clone();
            cpd.redefine(url, info);
            cp.setDefinition(cpd);
        }
        catch (CloneNotSupportedException e) {
            throw new ProxoolException("Funny, why couldn't we clone a definition?", e);
        }
    }

    public static void updateConnectionPool(String url, Properties info) throws ProxoolException {
        String alias = ProxoolFacade.getAlias(url);
        ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
        try {
            ConnectionPoolDefinition cpd = (ConnectionPoolDefinition)cp.getDefinition().clone();
            cpd.update(url, info);
            cp.setDefinition(cpd);
        }
        catch (CloneNotSupportedException e) {
            throw new ProxoolException("Funny, why couldn't we clone a definition?", e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug((Object)"Finalising");
    }

    public static Statement getDelegateStatement(Statement statement) throws ProxoolException {
        try {
            return ProxyFactory.getDelegateStatement(statement);
        }
        catch (IllegalArgumentException e) {
            throw new ProxoolException("Statement argument is not one provided by Proxool (it's a " + statement.getClass() + ")");
        }
    }

    public static Connection getDelegateConnection(Connection connection) throws ProxoolException {
        try {
            return ProxyFactory.getDelegateConnection(connection);
        }
        catch (IllegalArgumentException e) {
            throw new ProxoolException("Connection argument is not one provided by Proxool (it's a " + connection.getClass() + ")");
        }
    }

    public static long getId(Connection connection) throws ProxoolException {
        try {
            return ProxyFactory.getWrappedConnection(connection).getId();
        }
        catch (NullPointerException e) {
            throw new ProxoolException("Connection argument is not one provided by Proxool (it's a " + connection.getClass() + ")");
        }
        catch (IllegalArgumentException e) {
            throw new ProxoolException("Connection argument is not one provided by Proxool (it's a " + connection.getClass() + ")");
        }
    }

    public static String getAlias(Connection connection) throws ProxoolException {
        try {
            return ProxyFactory.getWrappedConnection(connection).getAlias();
        }
        catch (NullPointerException e) {
            throw new ProxoolException("Connection argument is not one provided by Proxool (it's a " + connection.getClass() + ")");
        }
        catch (IllegalArgumentException e) {
            throw new ProxoolException("Connection argument is not one provided by Proxool (it's a " + connection.getClass() + ")");
        }
    }

    public static String[] getAliases() {
        return ConnectionPoolManager.getInstance().getConnectionPoolNames();
    }

    public static StatisticsIF getStatistics(String alias, String token) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(alias).getAdmin().getStatistics(token);
    }

    public static StatisticsIF[] getStatistics(String alias) throws ProxoolException {
        Admin monitor = ConnectionPoolManager.getInstance().getConnectionPool(alias).getAdmin();
        if (monitor != null) {
            return monitor.getStatistics();
        }
        return new StatisticsIF[0];
    }

    public static void addStatisticsListener(String alias, StatisticsListenerIF statisticsListener) throws ProxoolException {
        Admin monitor = ConnectionPoolManager.getInstance().getConnectionPool(alias).getAdmin();
        if (monitor == null) {
            throw new ProxoolException("Statistics are switched off, your can't add a listener");
        }
        monitor.addStatisticsListener(statisticsListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnapshotIF getSnapshot(String alias, boolean detail) throws ProxoolException {
        SnapshotIF snapshot = null;
        ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
        if (detail) {
            try {
                long start = System.currentTimeMillis();
                if (cp.attemptConnectionStatusReadLock(10000L)) {
                    snapshot = Admin.getSnapshot(cp, cp.getDefinition(), cp.getConnectionInfos());
                } else {
                    LOG.warn((Object)("Give up waiting for detailed snapshot after " + (System.currentTimeMillis() - start) + " milliseconds. Serving standard snapshot instead."));
                }
            }
            finally {
                cp.releaseConnectionStatusReadLock();
            }
        }
        if (snapshot == null) {
            snapshot = Admin.getSnapshot(cp, cp.getDefinition(), null);
        }
        return snapshot;
    }

    public static SnapshotIF getSnapshot(String alias) throws ProxoolException {
        return ProxoolFacade.getSnapshot(alias, false);
    }

    private static boolean registerForJmx(String alias, Properties properties) {
        boolean success = false;
        try {
            Class<?> jmxHelperClass = Class.forName("org.logicalcobwebs.proxool.admin.jmx.ProxoolJMXHelper");
            Method registerMethod = jmxHelperClass.getDeclaredMethod("registerPool", class$java$lang$String == null ? (class$java$lang$String = ProxoolFacade.class$("java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = ProxoolFacade.class$("java.util.Properties")) : class$java$util$Properties);
            registerMethod.invoke(null, alias, properties);
            success = true;
        }
        catch (Exception e) {
            LOG.error((Object)("JMX registration of " + alias + " pool failed."), (Throwable)e);
        }
        return success;
    }

    private static boolean registerDataSource(String alias, Properties jndiProperties) {
        boolean success = false;
        try {
            Class<?> jndiHelperClass = Class.forName("org.logicalcobwebs.proxool.admin.jndi.ProxoolJNDIHelper");
            Method registerMethod = jndiHelperClass.getDeclaredMethod("registerDatasource", class$java$lang$String == null ? (class$java$lang$String = ProxoolFacade.class$("java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = ProxoolFacade.class$("java.util.Properties")) : class$java$util$Properties);
            registerMethod.invoke(null, alias, jndiProperties);
            success = true;
        }
        catch (Exception e) {
            LOG.error((Object)("JNDI DataSource binding of " + alias + " pool failed."), (Throwable)e);
        }
        return success;
    }

    private static Properties extractJndiProperties(ConnectionPoolDefinition connectionPoolDefinition) {
        if (connectionPoolDefinition.getJndiName() == null) {
            return null;
        }
        Properties jndiProperties = new Properties();
        jndiProperties.setProperty("jndi-name", connectionPoolDefinition.getJndiName());
        if (connectionPoolDefinition.getDelegateProperties() != null) {
            Properties delegateProperties = connectionPoolDefinition.getDelegateProperties();
            String propertyName = null;
            ArrayList<String> propertyNamesList = new ArrayList<String>(10);
            Iterator<Object> keySetIterator = delegateProperties.keySet().iterator();
            while (keySetIterator.hasNext()) {
                propertyName = (String)keySetIterator.next();
                if (!propertyName.startsWith("jndi-")) continue;
                propertyNamesList.add(propertyName);
            }
            for (int i = 0; i < propertyNamesList.size(); ++i) {
                propertyName = (String)propertyNamesList.get(i);
                if (!propertyName.startsWith("jndi-")) continue;
                jndiProperties.setProperty(propertyName.substring("jndi-".length()), delegateProperties.getProperty(propertyName));
                delegateProperties.remove(propertyName);
            }
        }
        return jndiProperties;
    }

    private static boolean isConfiguredForJMX(Properties poolProperties) {
        String jmxProperty = poolProperties.getProperty("proxool.jmx");
        return jmxProperty != null && jmxProperty.equalsIgnoreCase("true");
    }

    protected static void setShutdownHook(Thread t) {
        shutdownHook = t;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        shutdownHookEnabled = true;
    }
}

