/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.config.Config;
import com.hazelcast.impl.NodeType;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;

public class JoinInfo
extends JoinRequest
implements DataSerializable {
    private boolean request = true;
    private int memberCount = 0;
    private int tryCount = 0;
    final ILogger logger;

    public JoinInfo() {
        this.logger = Logger.getLogger(JoinInfo.class.getName());
    }

    public JoinInfo(ILogger logger, boolean request, Address address, Config config, NodeType type, byte packetVersion, int buildNumber, int memberCount, int tryCount, String nodeUuid) {
        super(address, config, type, packetVersion, buildNumber, nodeUuid);
        this.request = request;
        this.memberCount = memberCount;
        this.tryCount = tryCount;
        this.logger = logger;
    }

    public JoinInfo copy(boolean newRequest, Address newAddress, int memberCount) {
        return new JoinInfo(this.logger, newRequest, newAddress, this.config, this.nodeType, this.packetVersion, this.buildNumber, memberCount, this.tryCount, this.uuid);
    }

    public void readData(DataInput dis) throws IOException {
        super.readData(dis);
        this.request = dis.readBoolean();
        this.memberCount = dis.readInt();
        this.tryCount = dis.readInt();
    }

    public void writeData(DataOutput out) throws IOException {
        try {
            super.writeData(out);
            out.writeBoolean(this.isRequest());
            out.writeInt(this.memberCount);
            out.writeInt(this.tryCount);
        }
        catch (IOException e) {
            this.logger.log(Level.FINEST, e.getMessage(), e);
        }
    }

    public void setRequest(boolean request) {
        this.request = request;
    }

    public boolean isRequest() {
        return this.request;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public String toString() {
        return "JoinInfo{request=" + this.isRequest() + ", memberCount=" + this.memberCount + "  " + super.toString() + '}';
    }
}

