/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NominationStrategy;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.StunCandidateHarvester;
import org.ice4j.ice.harvest.TurnCandidateHarvester;
import org.ice4j.ice.harvest.UPNPHarvester;
import org.ice4j.security.LongTermCredential;

public class Ice {
    private static final boolean START_CONNECTIVITY_ESTABLISHMENT_OF_REMOTE_PEER = false;
    static long startTime;

    public static void main(String[] args) throws Throwable {
        startTime = System.currentTimeMillis();
        Agent localAgent = Ice.createAgent(9090);
        localAgent.setNominationStrategy(NominationStrategy.NOMINATE_HIGHEST_PRIO);
        Agent remotePeer = Ice.createAgent(6060);
        localAgent.addStateChangeListener(new IceProcessingListener());
        localAgent.setControlling(true);
        remotePeer.setControlling(false);
        long endTime = System.currentTimeMillis();
        Ice.transferRemoteCandidates(localAgent, remotePeer);
        for (IceMediaStream stream : localAgent.getStreams()) {
            stream.setRemoteUfrag(remotePeer.getLocalUfrag());
            stream.setRemotePassword(remotePeer.getLocalPassword());
        }
        for (IceMediaStream stream : remotePeer.getStreams()) {
            stream.setRemoteUfrag(localAgent.getLocalUfrag());
            stream.setRemotePassword(localAgent.getLocalPassword());
        }
        System.out.println("Total candidate gathering time: " + (endTime - startTime) + "ms");
        System.out.println("LocalAgent:\n" + localAgent);
        localAgent.startConnectivityEstablishment();
        System.out.println("Local audio clist:\n" + localAgent.getStream("audio").getCheckList());
        IceMediaStream videoStream = localAgent.getStream("video");
        if (videoStream != null) {
            System.out.println("Local video clist:\n" + videoStream.getCheckList());
        }
        Thread.sleep(60000L);
    }

    static void transferRemoteCandidates(Agent localAgent, Agent remotePeer) {
        List<IceMediaStream> streams = localAgent.getStreams();
        for (IceMediaStream localStream : streams) {
            String streamName = localStream.getName();
            IceMediaStream remoteStream = remotePeer.getStream(streamName);
            if (remoteStream != null) {
                Ice.transferRemoteCandidates(localStream, remoteStream);
                continue;
            }
            localAgent.removeStream(localStream);
        }
    }

    private static void transferRemoteCandidates(IceMediaStream localStream, IceMediaStream remoteStream) {
        List<Component> localComponents = localStream.getComponents();
        for (Component localComponent : localComponents) {
            int id = localComponent.getComponentID();
            Component remoteComponent = remoteStream.getComponent(id);
            if (remoteComponent != null) {
                Ice.transferRemoteCandidates(localComponent, remoteComponent);
                continue;
            }
            localStream.removeComponent(localComponent);
        }
    }

    private static void transferRemoteCandidates(Component localComponent, Component remoteComponent) {
        List<LocalCandidate> remoteCandidates = remoteComponent.getLocalCandidates();
        localComponent.setDefaultRemoteCandidate(remoteComponent.getDefaultCandidate());
        for (Candidate candidate : remoteCandidates) {
            localComponent.addRemoteCandidate(new RemoteCandidate(candidate.getTransportAddress(), localComponent, candidate.getType(), candidate.getFoundation(), candidate.getPriority(), null));
        }
    }

    protected static Agent createAgent(int rtpPort) throws Throwable {
        return Ice.createAgent(rtpPort, false);
    }

    protected static Agent createAgent(int rtpPort, boolean isTrickling) throws Throwable {
        long startTime = System.currentTimeMillis();
        Agent agent = new Agent();
        agent.setTrickling(isTrickling);
        StunCandidateHarvester stunHarv = new StunCandidateHarvester(new TransportAddress("stun.jitsi.net", 3478, Transport.UDP));
        StunCandidateHarvester stun6Harv = new StunCandidateHarvester(new TransportAddress("stun6.jitsi.net", 3478, Transport.UDP));
        agent.addCandidateHarvester(stunHarv);
        agent.addCandidateHarvester(stun6Harv);
        String[] hostnames = new String[]{"stun.jitsi.net", "stun6.jitsi.net"};
        int port = 3478;
        LongTermCredential longTermCredential = new LongTermCredential("guest", "anonymouspower!!");
        for (String hostname : hostnames) {
            agent.addCandidateHarvester(new TurnCandidateHarvester(new TransportAddress(hostname, port, Transport.UDP), longTermCredential));
        }
        agent.addCandidateHarvester(new UPNPHarvester());
        Ice.createStream(rtpPort, "audio", agent);
        Ice.createStream(rtpPort + 2, "video", agent);
        long endTime = System.currentTimeMillis();
        long total = endTime - startTime;
        System.out.println("Total harvesting time: " + total + "ms.");
        return agent;
    }

    private static IceMediaStream createStream(int rtpPort, String streamName, Agent agent) throws Throwable {
        IceMediaStream stream = agent.createMediaStream(streamName);
        long startTime = System.currentTimeMillis();
        agent.createComponent(stream, Transport.UDP, rtpPort, rtpPort, rtpPort + 100);
        long endTime = System.currentTimeMillis();
        System.out.println("RTP Component created in " + (endTime - startTime) + " ms");
        startTime = endTime;
        agent.createComponent(stream, Transport.UDP, rtpPort + 1, rtpPort + 1, rtpPort + 101);
        endTime = System.currentTimeMillis();
        System.out.println("RTCP Component created in " + (endTime - startTime) + " ms");
        return stream;
    }

    public static final class IceProcessingListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            long processingEndTime = System.currentTimeMillis();
            Object iceProcessingState = evt.getNewValue();
            System.out.println("Agent entered the " + iceProcessingState + " state.");
            if (iceProcessingState == IceProcessingState.COMPLETED) {
                String streamName;
                System.out.println("Total ICE processing time: " + (processingEndTime - startTime) + "ms");
                Agent agent = (Agent)evt.getSource();
                List<IceMediaStream> streams = agent.getStreams();
                for (IceMediaStream stream : streams) {
                    streamName = stream.getName();
                    System.out.println("Pairs selected for stream: " + streamName);
                    List<Component> components = stream.getComponents();
                    for (Component cmp : components) {
                        String cmpName = cmp.getName();
                        System.out.println(cmpName + ": " + cmp.getSelectedPair());
                    }
                }
                System.out.println("Printing the completed check lists:");
                for (IceMediaStream stream : streams) {
                    streamName = stream.getName();
                    System.out.println("Check list for  stream: " + streamName);
                    System.out.println(stream.getCheckList());
                }
            } else if (iceProcessingState == IceProcessingState.TERMINATED || iceProcessingState == IceProcessingState.FAILED) {
                ((Agent)evt.getSource()).free();
                System.exit(0);
            }
        }
    }
}

