/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.account;

import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusService;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.UtilActivator;

public class AccountStatusUtils {
    private static GlobalStatusService globalStatusService;

    public static Object getProtocolProviderLastStatus(ProtocolProviderService protocolProvider) {
        if (AccountStatusUtils.getProtocolPresenceOpSet(protocolProvider) != null) {
            return AccountStatusUtils.getLastPresenceStatus(protocolProvider);
        }
        return AccountStatusUtils.getGlobalStatusService().getLastStatusString(protocolProvider);
    }

    public static OperationSetPresence getProtocolPresenceOpSet(ProtocolProviderService protocolProvider) {
        OperationSet opSet = protocolProvider.getOperationSet(OperationSetPresence.class);
        return opSet instanceof OperationSetPresence ? (OperationSetPresence)opSet : null;
    }

    public static PresenceStatus getLastPresenceStatus(ProtocolProviderService protocolProvider) {
        if (AccountStatusUtils.getGlobalStatusService() != null) {
            return AccountStatusUtils.getGlobalStatusService().getLastPresenceStatus(protocolProvider);
        }
        return null;
    }

    public String getLastStatusString(ProtocolProviderService protocolProvider) {
        return AccountStatusUtils.getGlobalStatusService().getLastStatusString(protocolProvider);
    }

    public static GlobalStatusService getGlobalStatusService() {
        if (globalStatusService == null) {
            globalStatusService = ServiceUtils.getService(UtilActivator.bundleContext, GlobalStatusService.class);
        }
        return globalStatusService;
    }
}

