/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import java.util.Arrays;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.ArrayIOUtils;
import org.jitsi.impl.neomedia.conference.AudioMixerPushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.util.Logger;

public class AudioMixingPushBufferStream
extends ControlsAdapter
implements PushBufferStream {
    private static final Logger logger = Logger.getLogger(AudioMixingPushBufferStream.class);
    private final AudioMixerPushBufferStream audioMixerStream;
    private final AudioMixingPushBufferDataSource dataSource;
    private int[][] inSamples;
    private int maxInSampleCount;
    private final Object readSyncRoot = new Object();
    private long timeStamp;
    private BufferTransferHandler transferHandler;

    private static int getMaxOutSample(AudioFormat outFormat) throws UnsupportedFormatException {
        switch (outFormat.getSampleSizeInBits()) {
            case 8: {
                return 127;
            }
            case 16: {
                return Short.MAX_VALUE;
            }
            case 32: {
                return Integer.MAX_VALUE;
            }
        }
        throw new UnsupportedFormatException("Format.getSampleSizeInBits()", outFormat);
    }

    AudioMixingPushBufferStream(AudioMixerPushBufferStream audioMixerStream, AudioMixingPushBufferDataSource dataSource) {
        this.audioMixerStream = audioMixerStream;
        this.dataSource = dataSource;
    }

    @Override
    public boolean endOfStream() {
        return this.audioMixerStream.endOfStream();
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        return this.audioMixerStream.getContentDescriptor();
    }

    @Override
    public long getContentLength() {
        return this.audioMixerStream.getContentLength();
    }

    public AudioMixingPushBufferDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public AudioFormat getFormat() {
        return this.audioMixerStream.getFormat();
    }

    private int[] mix(int[][] inSamples, AudioFormat outFormat, int outSampleCount) {
        int maxOutSample;
        int[] outSamples = this.dataSource.audioMixer.intArrayCache.allocateIntArray(outSampleCount);
        if (inSamples.length == 1 || inSamples[1] == null) {
            int inStreamSampleCount;
            int[] inStreamSamples = inSamples[0];
            if (inStreamSamples == null) {
                inStreamSampleCount = 0;
            } else {
                inStreamSampleCount = Math.min(inStreamSamples.length, outSampleCount);
                System.arraycopy(inStreamSamples, 0, outSamples, 0, inStreamSampleCount);
            }
            if (inStreamSampleCount != outSampleCount) {
                Arrays.fill(outSamples, inStreamSampleCount, outSampleCount, 0);
            }
            return outSamples;
        }
        try {
            maxOutSample = AudioMixingPushBufferStream.getMaxOutSample(outFormat);
        }
        catch (UnsupportedFormatException ufex) {
            throw new UnsupportedOperationException(ufex);
        }
        Arrays.fill(outSamples, 0, outSampleCount, 0);
        for (int[] inStreamSamples : inSamples) {
            int inStreamSampleCount;
            if (inStreamSamples == null || (inStreamSampleCount = Math.min(inStreamSamples.length, outSampleCount)) == 0) continue;
            for (int i = 0; i < inStreamSampleCount; ++i) {
                int inStreamSample = inStreamSamples[i];
                int outSample = outSamples[i];
                outSamples[i] = inStreamSample + outSample - Math.round((float)inStreamSample * ((float)outSample / (float)maxOutSample));
            }
        }
        return outSamples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Buffer buffer) throws IOException {
        int outLength;
        byte[] outData;
        long timeStamp;
        int maxInSampleCount;
        int[][] inSamples;
        Object object = this.readSyncRoot;
        synchronized (object) {
            inSamples = this.inSamples;
            maxInSampleCount = this.maxInSampleCount;
            timeStamp = this.timeStamp;
            this.inSamples = null;
            this.maxInSampleCount = 0;
            this.timeStamp = -1L;
        }
        if (inSamples == null || inSamples.length == 0 || maxInSampleCount <= 0) {
            buffer.setDiscard(true);
            return;
        }
        AudioFormat outFormat = this.getFormat();
        int[] outSamples = this.mix(inSamples, outFormat, maxInSampleCount);
        int outSampleCount = Math.min(maxInSampleCount, outSamples.length);
        if (Format.byteArray.equals(outFormat.getDataType())) {
            Object o = buffer.getData();
            outData = null;
            if (o instanceof byte[]) {
                outData = (byte[])o;
            }
            switch (outFormat.getSampleSizeInBits()) {
                case 16: {
                    outLength = outSampleCount * 2;
                    if (outData == null || outData.length < outLength) {
                        outData = new byte[outLength];
                    }
                    for (int i = 0; i < outSampleCount; ++i) {
                        ArrayIOUtils.writeInt16(outSamples[i], outData, i * 2);
                    }
                    break;
                }
                case 32: {
                    outLength = outSampleCount * 4;
                    if (outData == null || outData.length < outLength) {
                        outData = new byte[outLength];
                    }
                    for (int i = 0; i < outSampleCount; ++i) {
                        ArrayIOUtils.writeInt(outSamples[i], outData, i * 4);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("AudioMixingPushBufferStream.read(Buffer)");
                }
            }
        } else {
            throw new UnsupportedOperationException("AudioMixingPushBufferStream.read(Buffer)");
        }
        buffer.setData(outData);
        buffer.setFormat(outFormat);
        buffer.setLength(outLength);
        buffer.setOffset(0);
        buffer.setTimeStamp(timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInSamples(int[][] inSamples, int maxInSampleCount, long timeStamp) {
        Object object = this.readSyncRoot;
        synchronized (object) {
            this.inSamples = inSamples;
            this.maxInSampleCount = maxInSampleCount;
        }
        BufferTransferHandler transferHandler = this.transferHandler;
        if (transferHandler != null) {
            transferHandler.transferData(this);
        }
    }

    @Override
    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.transferHandler = transferHandler;
    }

    synchronized void start() throws IOException {
        this.audioMixerStream.addOutStream(this);
        if (logger.isTraceEnabled()) {
            logger.trace("Started " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode());
        }
    }

    synchronized void stop() throws IOException {
        this.audioMixerStream.removeOutStream(this);
        if (logger.isTraceEnabled()) {
            logger.trace("Stopped " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode());
        }
    }
}

