/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.opus;

import java.awt.Component;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.opus.Opus;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.control.FormatParametersAwareCodec;
import org.jitsi.service.neomedia.control.PacketLossAwareEncoder;
import org.jitsi.util.Logger;

public class JNIEncoder
extends AbstractCodec2
implements FormatParametersAwareCodec,
PacketLossAwareEncoder {
    private static final Logger logger = Logger.getLogger(JNIEncoder.class);
    private static final Format[] SUPPORTED_INPUT_FORMATS;
    static final double[] SUPPORTED_INPUT_SAMPLE_RATES;
    private static final Format[] SUPPORTED_OUTPUT_FORMATS;
    private int bandwidthConfig;
    private int bitrate;
    private int channels = 1;
    private int complexityConfig;
    private long encoder = 0L;
    private int frameSizeInBytes;
    private final int frameSizeInMillis = 20;
    private int frameSizeInSamplesPerChannel;
    private int minPacketLoss = 0;
    private byte[] prevIn = null;
    private int prevInLength = 0;
    private boolean useDtxConfig;
    private boolean useFecConfig;

    public JNIEncoder() {
        super("Opus JNI Encoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
        this.addControl(this);
    }

    @Override
    protected void doClose() {
        if (this.encoder != 0L) {
            Opus.encoder_destroy(this.encoder);
            this.encoder = 0L;
        }
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        AudioFormat inputFormat = (AudioFormat)this.getInputFormat();
        int sampleRate = (int)inputFormat.getSampleRate();
        this.channels = inputFormat.getChannels();
        this.encoder = Opus.encoder_create(sampleRate, this.channels);
        if (this.encoder == 0L) {
            throw new ResourceUnavailableException("opus_encoder_create()");
        }
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        String str = cfg.getString("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.AUDIO_BANDWIDTH", "auto");
        this.bandwidthConfig = -1000;
        if ("fb".equals(str)) {
            this.bandwidthConfig = 1105;
        } else if ("swb".equals(str)) {
            this.bandwidthConfig = 1104;
        } else if ("wb".equals(str)) {
            this.bandwidthConfig = 1103;
        } else if ("mb".equals(str)) {
            this.bandwidthConfig = 1102;
        } else if ("nb".equals(str)) {
            this.bandwidthConfig = 1101;
        }
        Opus.encoder_set_bandwidth(this.encoder, this.bandwidthConfig);
        this.bitrate = 1000 * cfg.getInt("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.BITRATE", 32);
        if (this.bitrate < 500) {
            this.bitrate = 500;
        }
        if (this.bitrate > 512000) {
            this.bitrate = 512000;
        }
        Opus.encoder_set_bitrate(this.encoder, this.bitrate);
        this.complexityConfig = cfg.getInt("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.COMPLEXITY", 10);
        Opus.encoder_set_complexity(this.encoder, this.complexityConfig);
        this.useFecConfig = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.FEC", true);
        Opus.encoder_set_inband_fec(this.encoder, this.useFecConfig ? 1 : 0);
        this.minPacketLoss = cfg.getInt("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.MIN_EXPECTED_PACKET_LOSS", 1);
        Opus.encoder_set_packet_loss_perc(this.encoder, this.minPacketLoss);
        this.useDtxConfig = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.DTX", true);
        Opus.encoder_set_dtx(this.encoder, this.useDtxConfig ? 1 : 0);
        if (logger.isDebugEnabled()) {
            int b = Opus.encoder_get_bandwidth(this.encoder);
            logger.debug("Encoder settings: audio bandwidth " + (b == 1105 ? "fb" : (b == 1104 ? "swb" : (b == 1103 ? "wb" : (b == 1102 ? "mb" : "nb")))) + ", bitrate " + Opus.encoder_get_bitrate(this.encoder) + ", DTX " + Opus.encoder_get_dtx(this.encoder) + ", FEC " + Opus.encoder_get_inband_fec(this.encoder));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        int inOffset;
        int inLength;
        byte[] in;
        block14: {
            Format inFormat = inBuffer.getFormat();
            if (inFormat != null && inFormat != this.inputFormat && !inFormat.equals(this.inputFormat) && null == this.setInputFormat(inFormat)) {
                return 1;
            }
            in = (byte[])inBuffer.getData();
            inLength = inBuffer.getLength();
            inOffset = inBuffer.getOffset();
            if (this.prevIn != null && this.prevInLength > 0) {
                if (this.prevInLength < this.frameSizeInBytes) {
                    int bytesToCopyFromInToPrevInput;
                    if (this.prevIn.length < this.frameSizeInBytes) {
                        byte[] newPrevInput = new byte[this.frameSizeInBytes];
                        System.arraycopy(this.prevIn, 0, newPrevInput, 0, this.prevIn.length);
                        this.prevIn = newPrevInput;
                    }
                    if ((bytesToCopyFromInToPrevInput = Math.min(this.frameSizeInBytes - this.prevInLength, inLength)) > 0) {
                        System.arraycopy(in, inOffset, this.prevIn, this.prevInLength, bytesToCopyFromInToPrevInput);
                        this.prevInLength += bytesToCopyFromInToPrevInput;
                        inBuffer.setLength(inLength -= bytesToCopyFromInToPrevInput);
                        inBuffer.setOffset(inOffset + bytesToCopyFromInToPrevInput);
                    }
                }
                if (this.prevInLength == this.frameSizeInBytes) {
                    in = this.prevIn;
                    inOffset = 0;
                    this.prevInLength = 0;
                    break block14;
                } else {
                    outBuffer.setLength(0);
                    this.discardOutputBuffer(outBuffer);
                    if (inLength < 1) {
                        return 0;
                    }
                    return 2;
                }
            }
            if (inLength < 1) {
                outBuffer.setLength(0);
                this.discardOutputBuffer(outBuffer);
                return 0;
            }
            if (inLength < this.frameSizeInBytes) {
                if (this.prevIn == null || this.prevIn.length < inLength) {
                    this.prevIn = new byte[this.frameSizeInBytes];
                }
                System.arraycopy(in, inOffset, this.prevIn, 0, inLength);
                this.prevInLength = inLength;
                outBuffer.setLength(0);
                this.discardOutputBuffer(outBuffer);
                return 0;
            }
            inBuffer.setLength(inLength -= this.frameSizeInBytes);
            inBuffer.setOffset(inOffset + this.frameSizeInBytes);
        }
        byte[] out = JNIEncoder.validateByteArraySize(outBuffer, 1276, false);
        int outLength = Opus.encode(this.encoder, in, inOffset, this.frameSizeInSamplesPerChannel, out, 0, out.length);
        if (outLength < 0) {
            return 1;
        }
        if (outLength > 0) {
            outBuffer.setDuration(20000000L);
            outBuffer.setFormat(this.getOutputFormat());
            outBuffer.setLength(outLength);
            outBuffer.setOffset(0);
        }
        if (inLength < 1) {
            return 0;
        }
        return 2;
    }

    @Override
    public Component getControlComponent() {
        return null;
    }

    @Override
    public Format getOutputFormat() {
        Format f = super.getOutputFormat();
        if (f != null && f.getClass() == AudioFormat.class) {
            AudioFormat af = (AudioFormat)f;
            f = this.setOutputFormat(new AudioFormat(af.getEncoding(), af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), af.getEndian(), af.getSigned(), af.getFrameSizeInBits(), af.getFrameRate(), af.getDataType()){
                private static final long serialVersionUID = 0L;

                @Override
                public long computeDuration(long length) {
                    return 20000000L;
                }
            });
        }
        return f;
    }

    @Override
    public void setExpectedPacketLoss(int percentage) {
        if (this.opened) {
            Opus.encoder_set_packet_loss_perc(this.encoder, percentage > this.minPacketLoss ? percentage : this.minPacketLoss);
            if (logger.isTraceEnabled()) {
                logger.trace("Updating expected packet loss: " + percentage + " (minimum " + this.minPacketLoss + ")");
            }
        }
    }

    @Override
    public void setFormatParameters(Map<String, String> fmtps) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting format parameters: " + fmtps);
        }
        int maxaveragebitrate = 40000;
        try {
            String s = fmtps.get("maxaveragebitrate");
            if (s != null && s.length() != 0) {
                maxaveragebitrate = Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Opus.encoder_set_bitrate(this.encoder, maxaveragebitrate < this.bitrate ? maxaveragebitrate : this.bitrate);
        boolean useDtx = "1".equals(fmtps.get("usedtx"));
        Opus.encoder_set_dtx(this.encoder, useDtx && this.useDtxConfig ? 1 : 0);
        String s = fmtps.get("useinbandfec");
        boolean useFec = s == null || s.equals("1");
        Opus.encoder_set_inband_fec(this.encoder, useFec && this.useFecConfig ? 1 : 0);
    }

    @Override
    public Format setInputFormat(Format format) {
        Format oldValue = this.getInputFormat();
        Format setInputFormat = super.setInputFormat(format);
        Format newValue = this.getInputFormat();
        if (oldValue != newValue) {
            AudioFormat af = (AudioFormat)newValue;
            int sampleRate = (int)af.getSampleRate();
            this.frameSizeInSamplesPerChannel = sampleRate * 20 / 1000;
            this.frameSizeInBytes = 2 * this.channels * this.frameSizeInSamplesPerChannel;
        }
        return setInputFormat;
    }

    static {
        SUPPORTED_INPUT_SAMPLE_RATES = new double[]{48000.0};
        SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("opus/rtp", 48000.0, -1, 2, -1, -1, -1, -1.0, Format.byteArray)};
        Opus.assertOpusIsFunctional();
        int supportedInputCount = SUPPORTED_INPUT_SAMPLE_RATES.length;
        SUPPORTED_INPUT_FORMATS = new Format[supportedInputCount];
        for (int i = 0; i < supportedInputCount; ++i) {
            JNIEncoder.SUPPORTED_INPUT_FORMATS[i] = new AudioFormat("LINEAR", SUPPORTED_INPUT_SAMPLE_RATES[i], 16, 1, 0, 1, -1, -1.0, Format.byteArray);
        }
    }
}

