/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.ComponentImpl;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.osgi.framework.BundleContext;

public class Videobridge {
    static final Random RANDOM = new Random();
    private static String defaultTransportManager;
    private final ComponentImpl component;
    private final Map<String, Conference> conferences = new HashMap<String, Conference>();

    public Videobridge(ComponentImpl component) {
        if (component == null) {
            throw new NullPointerException("component");
        }
        this.component = component;
        new ExpireThread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference createConference(String focus) {
        Conference conference = null;
        do {
            String id = this.generateConferenceID();
            Map<String, Conference> map = this.conferences;
            synchronized (map) {
                if (!this.conferences.containsKey(id)) {
                    conference = new Conference(this, id, focus);
                    this.conferences.put(id, conference);
                }
            }
        } while (conference == null);
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireConference(Conference conference) {
        boolean expireConference;
        String id = conference.getID();
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            if (conference.equals(this.conferences.get(id))) {
                this.conferences.remove(id);
                expireConference = true;
            } else {
                expireConference = false;
            }
        }
        if (expireConference) {
            conference.expire();
        }
    }

    private String generateConferenceID() {
        return Long.toHexString(System.currentTimeMillis() + RANDOM.nextLong());
    }

    public ComponentImpl getComponent() {
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference getConference(String id, String focus) {
        Conference conference;
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            conference = this.conferences.get(id);
        }
        if (conference != null) {
            if (conference.getFocus().equals(focus)) {
                conference.touch();
            } else {
                conference = null;
            }
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference[] getConferences() {
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            Collection<Conference> values = this.conferences.values();
            return values.toArray(new Conference[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultTransportManager() {
        Class<Videobridge> clazz = Videobridge.class;
        synchronized (Videobridge.class) {
            if (defaultTransportManager == null) {
                ConfigurationService cfg;
                BundleContext bundleContext = this.getComponent().getBundleContext();
                if (bundleContext != null && (cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class)) != null) {
                    defaultTransportManager = cfg.getString(Videobridge.class.getName() + ".defaultTransportManager");
                }
                if (!"urn:xmpp:jingle:transports:ice-udp:1".equals(defaultTransportManager) && !"urn:xmpp:jingle:transports:raw-udp:1".equals(defaultTransportManager)) {
                    defaultTransportManager = "urn:xmpp:jingle:transports:ice-udp:1";
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultTransportManager;
        }
    }

    private static class ExpireThread
    extends Thread {
        private final WeakReference<Videobridge> videoBridge;

        public ExpireThread(Videobridge videoBridge) {
            this.videoBridge = new WeakReference<Videobridge>(videoBridge);
            this.setDaemon(true);
            this.setName(this.getClass().getName());
        }

        private void expire(Videobridge videoBridge) {
            for (Conference conference : videoBridge.getConferences()) {
                Content[] contents = conference.getContents();
                if (contents.length == 0) {
                    if (conference.getLastActivityTime() + 60000L >= System.currentTimeMillis()) continue;
                    try {
                        conference.expire();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
                for (Content content : conference.getContents()) {
                    Channel[] channels = content.getChannels();
                    if (channels.length == 0) {
                        if (content.getLastActivityTime() + 60000L >= System.currentTimeMillis()) continue;
                        try {
                            content.expire();
                            continue;
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                            if (!(t instanceof ThreadDeath)) continue;
                            throw (ThreadDeath)t;
                        }
                    }
                    for (Channel channel : channels) {
                        if (channel.getLastActivityTime() + 1000L * (long)channel.getExpire() >= System.currentTimeMillis()) continue;
                        try {
                            channel.expire();
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                            if (!(t instanceof ThreadDeath)) continue;
                            throw (ThreadDeath)t;
                        }
                    }
                }
            }
        }

        public void run() {
            Videobridge videoBridge;
            long wakeup = -1L;
            long sleep = 60000L;
            while ((videoBridge = (Videobridge)this.videoBridge.get()) != null) {
                long slept;
                long now = System.currentTimeMillis();
                if (wakeup != -1L && (slept = now - wakeup) < 60000L) {
                    boolean interrupted = false;
                    try {
                        Thread.sleep(60000L - slept);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                wakeup = now;
                try {
                    this.expire(videoBridge);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
        }
    }
}

