/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.PortTracker;
import org.ice4j.ice.Agent;
import org.ice4j.ice.LocalCandidate;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.StreamConnector;

public abstract class TransportManager<U extends MediaAwareCallPeer<?, ?, ?>> {
    private static final Logger logger = Logger.getLogger(TransportManager.class);
    private static PortTracker defaultPortTracker = new PortTracker(5000, 6000);
    private static PortTracker videoPortTracker = null;
    private static PortTracker dataChannelPortTracker = null;
    private static PortTracker audioPortTracker = null;
    private static final String RTP_AUDIO_DSCP_PROPERTY = "net.java.sip.communicator.impl.protocol.RTP_AUDIO_DSCP";
    private static final String RTP_VIDEO_DSCP_PROPERTY = "net.java.sip.communicator.impl.protocol.RTP_VIDEO_DSCP";
    private static final String HOLE_PUNCH_PKT_COUNT_PROPERTY = "net.java.sip.communicator.impl.protocol.HOLE_PUNCH_PKT_COUNT";
    private static final int DEFAULT_HOLE_PUNCH_PKT_COUNT = 3;
    private U callPeer;
    private final StreamConnector[] streamConnectors = new StreamConnector[MediaType.values().length];

    protected TransportManager(U callPeer) {
        this.callPeer = callPeer;
    }

    public StreamConnector getStreamConnector(MediaType mediaType) throws OperationFailedException {
        Socket controlTCPSocket;
        int streamConnectorIndex = mediaType.ordinal();
        StreamConnector streamConnector = this.streamConnectors[streamConnectorIndex];
        if (streamConnector == null || streamConnector.getProtocol() == StreamConnector.Protocol.UDP) {
            DatagramSocket controlSocket;
            if (streamConnector == null || streamConnector.getDataSocket().isClosed() || (controlSocket = streamConnector.getControlSocket()) != null && controlSocket.isClosed()) {
                this.streamConnectors[streamConnectorIndex] = streamConnector = this.createStreamConnector(mediaType);
            }
        } else if (streamConnector.getProtocol() == StreamConnector.Protocol.TCP && (streamConnector.getDataTCPSocket().isClosed() || (controlTCPSocket = streamConnector.getControlTCPSocket()) != null && controlTCPSocket.isClosed())) {
            this.streamConnectors[streamConnectorIndex] = streamConnector = this.createStreamConnector(mediaType);
        }
        return streamConnector;
    }

    public void closeStreamConnector(MediaType mediaType) {
        int index = mediaType.ordinal();
        StreamConnector streamConnector = this.streamConnectors[index];
        if (streamConnector != null) {
            this.closeStreamConnector(mediaType, streamConnector);
            this.streamConnectors[index] = null;
        }
    }

    protected void closeStreamConnector(MediaType mediaType, StreamConnector streamConnector) {
        streamConnector.close();
    }

    protected StreamConnector createStreamConnector(MediaType mediaType) throws OperationFailedException {
        NetworkAddressManagerService nam = ProtocolMediaActivator.getNetworkAddressManagerService();
        InetAddress intendedDestination = this.getIntendedDestination(this.getCallPeer());
        InetAddress localHostForPeer = nam.getLocalHost(intendedDestination);
        TransportManager.initializePortNumbers();
        PortTracker portTracker = TransportManager.getPortTracker(mediaType);
        DatagramSocket rtpSocket = null;
        try {
            rtpSocket = nam.createDatagramSocket(localHostForPeer, portTracker.getPort(), portTracker.getMinPort(), portTracker.getMaxPort());
        }
        catch (Exception exc) {
            throw new OperationFailedException("Failed to allocate the network ports necessary for the call.", 4, exc);
        }
        portTracker.setNextPort(rtpSocket.getLocalPort() + 1, false);
        DatagramSocket rtcpSocket = null;
        try {
            rtcpSocket = nam.createDatagramSocket(localHostForPeer, portTracker.getPort(), portTracker.getMinPort(), portTracker.getMaxPort());
        }
        catch (Exception exc) {
            throw new OperationFailedException("Failed to allocate the network ports necessary for the call.", 4, exc);
        }
        portTracker.setNextPort(rtcpSocket.getLocalPort() + 1);
        return new DefaultStreamConnector(rtpSocket, rtcpSocket);
    }

    protected static void initializePortNumbers() {
        ConfigurationService cfg = ProtocolMediaActivator.getConfigurationService();
        String minPortNumberStr = cfg.getString("net.java.sip.communicator.service.protocol.MIN_MEDIA_PORT_NUMBER");
        String maxPortNumberStr = cfg.getString("net.java.sip.communicator.service.protocol.MAX_MEDIA_PORT_NUMBER");
        defaultPortTracker.tryRange(minPortNumberStr, maxPortNumberStr);
        minPortNumberStr = cfg.getString("net.java.sip.communicator.service.protocol.MIN_VIDEO_PORT_NUMBER");
        maxPortNumberStr = cfg.getString("net.java.sip.communicator.service.protocol.MAX_VIDEO_PORT_NUMBER");
        videoPortTracker = PortTracker.createTracker((String)minPortNumberStr, (String)maxPortNumberStr);
        minPortNumberStr = cfg.getString("net.java.sip.communicator.service.protocol.MIN_AUDIO_PORT_NUMBER");
        maxPortNumberStr = cfg.getString("net.java.sip.communicator.service.protocol.MAX_AUDIO_PORT_NUMBER");
        audioPortTracker = PortTracker.createTracker((String)minPortNumberStr, (String)maxPortNumberStr);
        minPortNumberStr = cfg.getString("net.java.sip.communicator.service.protocol.MIN_DATA_CHANNEL_PORT_NUMBER");
        maxPortNumberStr = cfg.getString("net.java.sip.communicator.service.protocol.MAX_DATA_CHANNEL_PORT_NUMBER");
        dataChannelPortTracker = PortTracker.createTracker((String)minPortNumberStr, (String)maxPortNumberStr);
    }

    public InetAddress getLastUsedLocalHost() {
        for (MediaType mediaType : MediaType.values()) {
            StreamConnector streamConnector = this.streamConnectors[mediaType.ordinal()];
            if (streamConnector == null) continue;
            return streamConnector.getDataSocket().getLocalAddress();
        }
        NetworkAddressManagerService nam = ProtocolMediaActivator.getNetworkAddressManagerService();
        InetAddress intendedDestination = this.getIntendedDestination(this.getCallPeer());
        return nam.getLocalHost(intendedDestination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHolePunchPacket(MediaStreamTarget target, MediaType type) {
        logger.info((Object)"Send NAT hole punch packets");
        int packetCount = ProtocolMediaActivator.getConfigurationService().getInt(HOLE_PUNCH_PKT_COUNT_PROPERTY, 3);
        if (packetCount < 0) {
            packetCount = 3;
        }
        if (packetCount == 0) {
            return;
        }
        try {
            StreamConnector connector = this.getStreamConnector(type);
            if (connector.getProtocol() == StreamConnector.Protocol.TCP) {
                return;
            }
            byte[] buf = new byte[]{};
            StreamConnector streamConnector = connector;
            synchronized (streamConnector) {
                for (int i = 0; i < packetCount; ++i) {
                    DatagramSocket socket = connector.getDataSocket();
                    if (socket != null) {
                        InetSocketAddress dataAddress = target.getDataAddress();
                        socket.send(new DatagramPacket(buf, buf.length, dataAddress.getAddress(), dataAddress.getPort()));
                    }
                    if ((socket = connector.getControlSocket()) == null) continue;
                    InetSocketAddress controlAddress = target.getControlAddress();
                    socket.send(new DatagramPacket(buf, buf.length, controlAddress.getAddress(), controlAddress.getPort()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error cannot send to remote peer", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTrafficClass(MediaStreamTarget target, MediaType type) {
        int trafficClass = this.getDSCP(type);
        if (trafficClass <= 0) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Set traffic class for " + type + " to " + trafficClass));
        }
        try {
            StreamConnector connector;
            StreamConnector streamConnector = connector = this.getStreamConnector(type);
            synchronized (streamConnector) {
                if (connector.getProtocol() == StreamConnector.Protocol.TCP) {
                    connector.getDataTCPSocket().setTrafficClass(trafficClass);
                    Socket controlTCPSocket = connector.getControlTCPSocket();
                    if (controlTCPSocket != null) {
                        controlTCPSocket.setTrafficClass(trafficClass);
                    }
                } else {
                    connector.getDataSocket().setTrafficClass(trafficClass);
                    DatagramSocket controlSocket = connector.getControlSocket();
                    if (controlSocket != null) {
                        controlSocket.setTrafficClass(trafficClass);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to set traffic class for " + type + " to " + trafficClass), (Throwable)e);
        }
    }

    private int getDSCP(MediaType type) {
        String dscpPropertyName;
        switch (type) {
            case AUDIO: {
                dscpPropertyName = RTP_AUDIO_DSCP_PROPERTY;
                break;
            }
            case VIDEO: {
                dscpPropertyName = RTP_VIDEO_DSCP_PROPERTY;
                break;
            }
            default: {
                dscpPropertyName = null;
            }
        }
        return dscpPropertyName == null ? 0 : ProtocolMediaActivator.getConfigurationService().getInt(dscpPropertyName, 0) << 2;
    }

    protected abstract InetAddress getIntendedDestination(U var1);

    public U getCallPeer() {
        return this.callPeer;
    }

    protected static PortTracker getPortTracker(MediaType mediaType) {
        if (MediaType.AUDIO == mediaType) {
            if (audioPortTracker != null) {
                return audioPortTracker;
            }
        } else if (MediaType.VIDEO == mediaType && videoPortTracker != null) {
            return videoPortTracker;
        }
        return defaultPortTracker;
    }

    protected static PortTracker getPortTracker(String mediaTypeStr) {
        try {
            MediaType mediaType = MediaType.parseString((String)mediaTypeStr);
            return TransportManager.getPortTracker(mediaType);
        }
        catch (Exception exc) {
            logger.info((Object)("Returning default port tracker for unrecognized media type: " + mediaTypeStr));
            return defaultPortTracker;
        }
    }

    public abstract String getICECandidateExtendedType(String var1);

    public abstract String getICEState();

    public abstract InetSocketAddress getICELocalHostAddress(String var1);

    public abstract InetSocketAddress getICERemoteHostAddress(String var1);

    public abstract InetSocketAddress getICELocalReflexiveAddress(String var1);

    public abstract InetSocketAddress getICERemoteReflexiveAddress(String var1);

    public abstract InetSocketAddress getICELocalRelayedAddress(String var1);

    public abstract InetSocketAddress getICERemoteRelayedAddress(String var1);

    public abstract long getTotalHarvestingTime();

    public abstract long getHarvestingTime(String var1);

    public abstract int getNbHarvesting();

    public abstract int getNbHarvesting(String var1);

    public static String getICECandidateExtendedType(Agent iceAgent, String streamName) {
        LocalCandidate localCandidate;
        if (iceAgent != null && (localCandidate = iceAgent.getSelectedLocalCandidate(streamName)) != null) {
            return localCandidate.getExtendedType().toString();
        }
        return null;
    }
}

