/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.globalstatus;

import java.util.ArrayList;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;

public class GlobalStatusEnum
extends PresenceStatus {
    public static final String ONLINE_STATUS = "Online";
    public static final String OFFLINE_STATUS = "Offline";
    public static final String AWAY_STATUS = "Away";
    public static final String FREE_FOR_CHAT_STATUS = "Free For Chat";
    public static final String DO_NOT_DISTURB_STATUS = "Do Not Disturb";
    public static final GlobalStatusEnum ONLINE = new GlobalStatusEnum(65, "Online", GlobalStatusEnum.loadIcon("service.gui.statusicons.USER_ONLINE_ICON"), "service.gui.ONLINE");
    public static final GlobalStatusEnum FREE_FOR_CHAT = new GlobalStatusEnum(85, "Free For Chat", GlobalStatusEnum.loadIcon("service.gui.statusicons.USER_FFC_ICON"), "service.gui.FFC_STATUS");
    public static final GlobalStatusEnum AWAY = new GlobalStatusEnum(48, "Away", GlobalStatusEnum.loadIcon("service.gui.statusicons.USER_AWAY_ICON"), "service.gui.AWAY_STATUS");
    public static final GlobalStatusEnum DO_NOT_DISTURB = new GlobalStatusEnum(30, "Do Not Disturb", GlobalStatusEnum.loadIcon("service.gui.statusicons.USER_DND_ICON"), "service.gui.DND_STATUS");
    public static final GlobalStatusEnum OFFLINE = new GlobalStatusEnum(0, "Offline", GlobalStatusEnum.loadIcon("service.gui.statusicons.USER_OFFLINE_ICON"), "service.gui.OFFLINE");
    public static final ArrayList<GlobalStatusEnum> globalStatusSet = new ArrayList();
    private String i18NKey;

    protected GlobalStatusEnum(int status, String statusName, byte[] statusIcon, String i18NKey) {
        super(status, statusName, statusIcon);
        this.i18NKey = i18NKey;
    }

    public static byte[] loadIcon(String imagePath) {
        return ProtocolProviderActivator.getResourceService().getImageInBytes(imagePath);
    }

    public static String getI18NStatusName(GlobalStatusEnum status) {
        return ProtocolProviderActivator.getResourceService().getI18NString(status.i18NKey);
    }

    public static GlobalStatusEnum getStatusByName(String name) {
        for (GlobalStatusEnum gs : globalStatusSet) {
            if (!gs.getStatusName().equals(name)) continue;
            return gs;
        }
        return null;
    }

    static {
        globalStatusSet.add(ONLINE);
        globalStatusSet.add(FREE_FOR_CHAT);
        globalStatusSet.add(AWAY);
        globalStatusSet.add(DO_NOT_DISTURB);
        globalStatusSet.add(OFFLINE);
    }
}

