/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.pseudotcp.PseudoTCPBase;
import org.ice4j.pseudotcp.PseudoTcpTestBase;
import org.ice4j.pseudotcp.util.ByteFifoBuffer;

public class PseudoTcpTestPingPong
extends PseudoTcpTestBase {
    private static final Logger logger = Logger.getLogger(PseudoTCPBase.class.getName());
    private PseudoTCPBase sender;
    private PseudoTCPBase receiver;
    private int bytesPerSend;
    private int iterationsRemaining;
    ByteFifoBuffer send_stream;
    ByteFifoBuffer recv_stream;

    public void setBytesPerSend(int bytes_per_send) {
        this.bytesPerSend = bytes_per_send;
    }

    public void doTestPingPong(int size, int iterations) {
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.iterationsRemaining = iterations;
        this.receiver = this.getRemoteTcp();
        this.sender = this.getLocalTcp();
        byte[] dummy = PseudoTcpTestPingPong.createDummyData(size);
        this.send_stream = new ByteFifoBuffer(size);
        this.send_stream.write(dummy, size);
        this.recv_stream = new ByteFifoBuffer(size);
        long start = PseudoTCPBase.now();
        this.startClocks();
        try {
            this.connect();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            PseudoTcpTestPingPong.fail((String)ex.getMessage());
        }
        this.assert_Connected_wait(5000);
        this.assert_Disconnected_wait(1000L);
        long elapsed = PseudoTCPBase.now() - start;
        this.stopClocks();
        logger.log(Level.INFO, "Performed " + iterations + " pings in " + elapsed + " ms");
    }

    public void onTcpReadable(PseudoTCPBase tcp) {
        PseudoTcpTestPingPong.assertEquals((String)"Unexpected onTcpReadable", (Object)this.receiver, (Object)tcp);
        try {
            this.readData();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        int recvd = this.recv_stream.getBuffered();
        int required = this.send_stream.length();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "test - receivied: " + recvd + " required: " + required);
        }
        if (recvd == required) {
            if (this.receiver == this.getLocalTcp() && --this.iterationsRemaining == 0) {
                this.close();
                this.onTcpClosed(this.getRemoteTcp(), null);
                return;
            }
            PseudoTCPBase tmp = this.receiver;
            this.receiver = this.sender;
            this.sender = tmp;
            this.send_stream.resetReadPosition();
            this.send_stream.consumeWriteBuffer(this.send_stream.getWriteRemaining());
            this.recv_stream.resetWritePosition();
            this.onTcpWriteable(this.sender);
        }
    }

    public void onTcpWriteable(PseudoTCPBase tcp) {
        if (tcp != this.sender) {
            return;
        }
        logger.log(Level.FINER, "Flow Control Lifted");
        try {
            this.writeData();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void readData() throws IOException {
        byte[] block = new byte[4096];
        int rcvd = 0;
        do {
            if ((rcvd = this.receiver.recv(block, block.length)) <= 0) continue;
            this.recv_stream.write(block, rcvd);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "Receivied: " + this.recv_stream.getBuffered());
        } while (rcvd > 0);
    }

    private void writeData() throws IOException {
        int sent = 0;
        byte[] block = new byte[4096];
        do {
            int tosend = this.bytesPerSend != 0 ? this.bytesPerSend : block.length;
            if ((tosend = this.send_stream.read(block, tosend)) > 0) {
                sent = this.sender.send(block, tosend);
                this.updateLocalClock();
                if (sent != -1) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Sent: " + sent);
                    continue;
                }
                logger.log(Level.FINE, "Flow controlled");
                continue;
            }
            tosend = 0;
            sent = 0;
        } while (sent > 0);
    }

    public void testPingPong1xMtu() {
        PseudoTcpTestPingPong test = new PseudoTcpTestPingPong();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.doTestPingPong(100, 100);
    }

    public void testPingPong3xMtu() {
        PseudoTcpTestPingPong test = new PseudoTcpTestPingPong();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.doTestPingPong(400, 100);
    }

    public void testPingPong2xMtu() {
        PseudoTcpTestPingPong test = new PseudoTcpTestPingPong();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.doTestPingPong(2000, 5);
    }

    public void testPingPong2xMtuWithAckDelayOff() {
        PseudoTcpTestPingPong test = new PseudoTcpTestPingPong();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setOptAckDelay(0);
        test.doTestPingPong(2000, 100);
    }

    public void testPingPong2xMtuWithNaglingOff() {
        PseudoTcpTestPingPong test = new PseudoTcpTestPingPong();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setOptNagling(false);
        test.doTestPingPong(2000, 5);
    }

    public void testPingPongShortSegments() {
        PseudoTcpTestPingPong test = new PseudoTcpTestPingPong();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setOptAckDelay(5000);
        test.setBytesPerSend(50);
        test.doTestPingPong(100, 5);
    }

    public void testPingPongShortSegmentsWithNaglingOff() {
        PseudoTcpTestPingPong test = new PseudoTcpTestPingPong();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setOptNagling(false);
        test.setBytesPerSend(50);
        test.doTestPingPong(100, 5);
    }

    public void testPingPongShortSegmentsWithAckDelayOff() {
        PseudoTcpTestPingPong test = new PseudoTcpTestPingPong();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setBytesPerSend(50);
        test.setOptAckDelay(0);
        test.doTestPingPong(100, 5);
    }
}

