/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import javax.media.Buffer;
import javax.media.Controls;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.control.AbstractControls;
import org.jitsi.impl.neomedia.protocol.InbandDTMFDataSource;
import org.jitsi.impl.neomedia.protocol.MuteDataSource;
import org.jitsi.impl.neomedia.protocol.PushBufferDataSourceDelegate;
import org.jitsi.impl.neomedia.protocol.SourceStreamDelegate;
import org.jitsi.impl.neomedia.protocol.StreamSubstituteBufferTransferHandler;
import org.jitsi.service.neomedia.DTMFInbandTone;

public class RewritablePushBufferDataSource
extends PushBufferDataSourceDelegate<PushBufferDataSource>
implements MuteDataSource,
InbandDTMFDataSource {
    private boolean mute;
    private final LinkedList<DTMFInbandTone> tones = new LinkedList();

    public RewritablePushBufferDataSource(PushBufferDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Object getControl(String controlType) {
        if (InbandDTMFDataSource.class.getName().equals(controlType) || MuteDataSource.class.getName().equals(controlType)) {
            return this;
        }
        return AbstractControls.queryInterface((Controls)this.dataSource, controlType);
    }

    @Override
    public PushBufferStream[] getStreams() {
        PushBufferStream[] streams = ((PushBufferDataSource)this.dataSource).getStreams();
        if (streams != null) {
            for (int streamIndex = 0; streamIndex < streams.length; ++streamIndex) {
                PushBufferStream stream = streams[streamIndex];
                if (stream == null) continue;
                streams[streamIndex] = new MutePushBufferStream(stream);
            }
        }
        return streams;
    }

    @Override
    public synchronized boolean isMute() {
        return this.mute;
    }

    public static void mute(Buffer buffer) {
        Object data = buffer.getData();
        if (data != null) {
            Class<?> dataClass = data.getClass();
            int fromIndex = buffer.getOffset();
            int toIndex = fromIndex + buffer.getLength();
            if (Format.byteArray.equals(dataClass)) {
                Arrays.fill((byte[])data, fromIndex, toIndex, (byte)0);
            } else if (Format.intArray.equals(dataClass)) {
                Arrays.fill((int[])data, fromIndex, toIndex, 0);
            } else if (Format.shortArray.equals(dataClass)) {
                Arrays.fill((short[])data, fromIndex, toIndex, (short)0);
            }
            buffer.setData(data);
        }
    }

    @Override
    public synchronized void setMute(boolean mute) {
        this.mute = mute;
    }

    @Override
    public void addDTMF(DTMFInbandTone tone) {
        this.tones.add(tone);
    }

    public boolean isSendingDTMF() {
        return !this.tones.isEmpty();
    }

    public static void sendDTMF(Buffer buffer, DTMFInbandTone tone) {
        Object data = buffer.getData();
        if (data != null && buffer.getFormat() instanceof AudioFormat) {
            int i;
            Class<?> dataClass = data.getClass();
            int fromIndex = buffer.getOffset();
            AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
            double samplingFrequency = audioFormat.getSampleRate();
            int sampleSizeInBits = audioFormat.getSampleSizeInBits();
            int[] sampleData = tone.getAudioSamples(samplingFrequency, sampleSizeInBits);
            IntBuffer.wrap(sampleData);
            int toIndex = fromIndex + sampleData.length * (sampleSizeInBits / 8);
            ByteBuffer newData = ByteBuffer.allocate(toIndex);
            if (audioFormat.getEndian() == 1) {
                newData.order(ByteOrder.BIG_ENDIAN);
            } else {
                newData.order(ByteOrder.LITTLE_ENDIAN);
            }
            if (Format.byteArray.equals(dataClass)) {
                newData.put((byte[])data, 0, fromIndex);
            } else if (Format.shortArray.equals(dataClass)) {
                for (i = 0; i < fromIndex; ++i) {
                    newData.putShort(((short[])data)[i]);
                }
            } else if (Format.intArray.equals(dataClass)) {
                for (i = 0; i < fromIndex; ++i) {
                    newData.putInt(((int[])data)[i]);
                }
            }
            switch (sampleSizeInBits) {
                case 8: {
                    for (i = 0; i < sampleData.length; ++i) {
                        newData.put((byte)sampleData[i]);
                    }
                    break;
                }
                case 16: {
                    for (i = 0; i < sampleData.length; ++i) {
                        newData.putShort((short)sampleData[i]);
                    }
                    break;
                }
                case 32: {
                    for (i = 0; i < sampleData.length; ++i) {
                        newData.putInt(sampleData[i]);
                    }
                    break;
                }
            }
            if (Format.byteArray.equals(dataClass)) {
                buffer.setData(newData.array());
            } else if (Format.shortArray.equals(dataClass)) {
                buffer.setData(newData.asShortBuffer().array());
            } else if (Format.intArray.equals(dataClass)) {
                buffer.setData(newData.asIntBuffer().array());
            }
            buffer.setLength(toIndex - fromIndex);
        }
    }

    private class MutePushBufferStream
    extends SourceStreamDelegate<PushBufferStream>
    implements PushBufferStream {
        public MutePushBufferStream(PushBufferStream stream) {
            super(stream);
        }

        @Override
        public Format getFormat() {
            return ((PushBufferStream)this.stream).getFormat();
        }

        @Override
        public void read(Buffer buffer) throws IOException {
            ((PushBufferStream)this.stream).read(buffer);
            if (RewritablePushBufferDataSource.this.isSendingDTMF()) {
                RewritablePushBufferDataSource.sendDTMF(buffer, (DTMFInbandTone)RewritablePushBufferDataSource.this.tones.poll());
            } else if (RewritablePushBufferDataSource.this.isMute()) {
                RewritablePushBufferDataSource.mute(buffer);
            }
        }

        @Override
        public void setTransferHandler(BufferTransferHandler transferHandler) {
            ((PushBufferStream)this.stream).setTransferHandler(transferHandler == null ? null : new StreamSubstituteBufferTransferHandler(transferHandler, (PushBufferStream)this.stream, this));
        }
    }
}

