/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SourceRTPPacket;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.RTPPacket;

public class RTPDemultiplexer {
    private SSRCCache cache;
    private RTPRawReceiver rtpr;
    private Buffer buffer;
    private StreamSynch streamSynch;

    public RTPDemultiplexer(SSRCCache c, RTPRawReceiver r, StreamSynch streamSynch) {
        this.cache = c;
        this.rtpr = r;
        this.streamSynch = streamSynch;
        this.buffer = new Buffer();
    }

    public String consumerString() {
        return "RTP DeMultiplexer";
    }

    public void demuxpayload(SourceRTPPacket sp) {
        SSRCInfo info = sp.ssrcinfo;
        RTPPacket rtpPacket = sp.p;
        info.payloadType = rtpPacket.payloadType;
        if (info.dstream != null) {
            this.buffer.setData(rtpPacket.base.data);
            this.buffer.setFlags(0);
            if (rtpPacket.marker == 1) {
                this.buffer.setFlags(this.buffer.getFlags() | 0x800);
            }
            this.buffer.setLength(rtpPacket.payloadlength);
            this.buffer.setOffset(rtpPacket.payloadoffset);
            long ts = this.streamSynch.calcTimestamp(info.ssrc, rtpPacket.payloadType, rtpPacket.timestamp);
            this.buffer.setTimeStamp(ts);
            this.buffer.setFlags(this.buffer.getFlags() | 0x1000);
            this.buffer.setSequenceNumber(rtpPacket.seqnum);
            this.buffer.setFormat(info.dstream.getFormat());
            info.dstream.add(this.buffer, info.wrapped, this.rtpr);
        }
    }
}

