/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.BasicModule;
import net.sf.fmj.media.BasicMuxModule;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.BasicRendererModule;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.Module;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.control.ProgressControl;
import net.sf.fmj.media.control.StringControl;

public class BasicTrackControl
implements TrackControl {
    static final String realizeErr = "Cannot get CodecControl before reaching the realized state.";
    static final String connectErr = "Cannot set a PlugIn before reaching the configured state.";
    PlaybackEngine engine;
    Track track;
    OutputConnector firstOC;
    OutputConnector lastOC;
    protected Vector modules = new Vector(7);
    protected BasicRendererModule rendererModule;
    protected BasicMuxModule muxModule = null;
    protected boolean prefetchFailed = false;
    protected boolean rendererFailed = false;
    float lastFrameRate = 0.0f;
    long lastStatsTime = 0L;

    public BasicTrackControl(PlaybackEngine engine, Track track, OutputConnector oc) {
        this.engine = engine;
        this.track = track;
        this.firstOC = oc;
        this.lastOC = oc;
        this.setEnabled(track.isEnabled());
    }

    public boolean buildTrack(int trackID, int numTracks) {
        return false;
    }

    protected FrameRateControl frameRateControl() {
        return null;
    }

    public Object getControl(String type) {
        Class<?> cls;
        try {
            cls = BasicPlugIn.getClassForName(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Object[] cs = this.getControls();
        for (int i = 0; i < cs.length; ++i) {
            if (!cls.isInstance(cs[i])) continue;
            return cs[i];
        }
        return null;
    }

    public Component getControlComponent() {
        return null;
    }

    public Object[] getControls() throws NotRealizedError {
        int i;
        InputConnector ic;
        if (this.engine.getState() < 300) {
            throw new NotRealizedError(realizeErr);
        }
        OutputConnector oc = this.firstOC;
        Object p = null;
        Vector<Object> cv = new Vector<Object>();
        while (oc != null && (ic = oc.getInputConnector()) != null) {
            Module m = ic.getModule();
            Object[] cs = m.getControls();
            if (cs != null) {
                for (i = 0; i < cs.length; ++i) {
                    cv.addElement(cs[i]);
                }
            }
            oc = m.getOutputConnector(null);
        }
        int size = cv.size();
        Object[] controls = new Control[size];
        for (i = 0; i < size; ++i) {
            controls[i] = (Control)cv.elementAt(i);
        }
        return controls;
    }

    public Format getFormat() {
        return this.track.getFormat();
    }

    public Format getOriginalFormat() {
        return this.track.getFormat();
    }

    public Format[] getSupportedFormats() {
        return new Format[]{this.track.getFormat()};
    }

    public boolean isCustomized() {
        return false;
    }

    public boolean isEnabled() {
        return this.track.isEnabled();
    }

    public boolean isTimeBase() {
        return false;
    }

    public boolean prefetchTrack() {
        for (int j = 0; j < this.modules.size(); ++j) {
            BasicModule bm = (BasicModule)this.modules.elementAt(j);
            if (bm.doPrefetch()) continue;
            this.setEnabled(false);
            this.prefetchFailed = true;
            if (bm instanceof BasicRendererModule) {
                this.rendererFailed = true;
            }
            return false;
        }
        if (this.prefetchFailed) {
            this.setEnabled(true);
            this.prefetchFailed = false;
            this.rendererFailed = false;
        }
        return true;
    }

    public void prError() {
        Log.error("  Unable to handle format: " + this.getOriginalFormat());
        Log.write("\n");
    }

    protected ProgressControl progressControl() {
        return null;
    }

    public void setCodecChain(Codec[] codec) throws NotConfiguredError, UnsupportedPlugInException {
        if (this.engine.getState() > 180) {
            throw new NotConfiguredError(connectErr);
        }
        if (codec.length < 1) {
            throw new UnsupportedPlugInException("No codec specified in the array.");
        }
    }

    public void setEnabled(boolean enabled) {
        this.track.setEnabled(enabled);
    }

    public Format setFormat(Format format) {
        if (format != null && format.matches(this.getFormat())) {
            return this.getFormat();
        }
        return null;
    }

    public void setRenderer(Renderer renderer) throws NotConfiguredError {
        if (this.engine.getState() > 180) {
            throw new NotConfiguredError(connectErr);
        }
    }

    public void startTrack() {
        for (int j = 0; j < this.modules.size(); ++j) {
            ((BasicModule)this.modules.elementAt(j)).doStart();
        }
    }

    public void stopTrack() {
        for (int j = 0; j < this.modules.size(); ++j) {
            ((BasicModule)this.modules.elementAt(j)).doStop();
        }
    }

    public void updateFormat() {
        StringControl sc;
        if (!this.track.isEnabled()) {
            return;
        }
        ProgressControl pc = this.progressControl();
        if (pc == null) {
            return;
        }
        if (this.track.getFormat() instanceof AudioFormat) {
            String channel = "";
            AudioFormat afmt = (AudioFormat)this.track.getFormat();
            sc = pc.getAudioCodec();
            sc.setValue(afmt.getEncoding());
            sc = pc.getAudioProperties();
            channel = afmt.getChannels() == 1 ? "mono" : "stereo";
            sc.setValue(afmt.getSampleRate() / 1000.0 + " KHz, " + afmt.getSampleSizeInBits() + "-bit, " + channel);
        }
        if (this.track.getFormat() instanceof VideoFormat) {
            VideoFormat vfmt = (VideoFormat)this.track.getFormat();
            sc = pc.getVideoCodec();
            sc.setValue(vfmt.getEncoding());
            sc = pc.getVideoProperties();
            if (vfmt.getSize() != null) {
                sc.setValue(vfmt.getSize().width + " X " + vfmt.getSize().height);
            }
        }
    }

    public void updateRates(long now) {
        float rate;
        FrameRateControl prc = this.frameRateControl();
        if (prc == null) {
            return;
        }
        if (!this.track.isEnabled() || !(this.track.getFormat() instanceof VideoFormat) || this.rendererModule == null && this.muxModule == null) {
            return;
        }
        if (now == this.lastStatsTime) {
            rate = this.lastFrameRate;
        } else {
            int framesPlayed = this.rendererModule != null ? this.rendererModule.getFramesPlayed() : this.muxModule.getFramesPlayed();
            rate = (float)framesPlayed / (float)(now - this.lastStatsTime) * 1000.0f;
        }
        float avg = (float)((int)((this.lastFrameRate + rate) / 2.0f * 10.0f)) / 10.0f;
        prc.setFrameRate(avg);
        this.lastFrameRate = rate;
        this.lastStatsTime = now;
        if (this.rendererModule != null) {
            this.rendererModule.resetFramesPlayed();
        } else {
            this.muxModule.resetFramesPlayed();
        }
    }
}

