/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DistributedCountDownLatch
implements DataSerializable {
    public static final Data newInstanceData = IOUtil.toData(new DistributedCountDownLatch());
    int count;
    Address memberAddress = new Address();
    Address ownerAddress = new Address();

    public void readData(DataInput in) throws IOException {
        this.count = in.readInt();
        if (this.count != 0) {
            this.memberAddress.readData(in);
            this.ownerAddress.readData(in);
        }
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.count);
        if (this.count != 0) {
            this.memberAddress.writeData(out);
            this.ownerAddress.writeData(out);
        }
    }

    public boolean countDown() {
        return this.count > 0 && this.count-- > 0;
    }

    public int getCount() {
        return this.count;
    }

    public Address getOwnerAddress() {
        return this.count > 0 ? this.ownerAddress : null;
    }

    public boolean isOwnerOrMemberAddress(Address deadAddress) {
        return deadAddress.equals(this.ownerAddress) || deadAddress.equals(this.memberAddress);
    }

    public boolean ownerLeft() {
        return this.count == -1;
    }

    public boolean setCount(int count, Address memberAddress, Address ownerAddress) {
        if (this.count > 0 || count <= 0) {
            return false;
        }
        this.count = count;
        this.memberAddress = memberAddress;
        this.ownerAddress = ownerAddress;
        return true;
    }

    public void setOwnerLeft() {
        this.count = -1;
    }

    public String toString() {
        return String.format("CountDownLatch{count=%d, memberAddress=%s, ownerAddress=%s}", this.count, this.memberAddress, this.ownerAddress);
    }
}

