/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.BufferedOutputStream;
import org.mortbay.http.ChunkingOutputStream;
import org.mortbay.http.HttpMessage;
import org.mortbay.util.ByteArrayPool;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;
import org.mortbay.util.OutputObserver;
import org.mortbay.util.StringUtil;

public class HttpOutputStream
extends OutputStream
implements OutputObserver,
HttpMessage.HeaderWriter {
    private static Log log = LogFactory.getLog(class$org$mortbay$http$HttpOutputStream == null ? (class$org$mortbay$http$HttpOutputStream = HttpOutputStream.class$("org.mortbay.http.HttpOutputStream")) : class$org$mortbay$http$HttpOutputStream);
    static final int __BUFFER_SIZE = 4096;
    static final int __FIRST_RESERVE = 512;
    public static final Class[] __filterArg = new Class[]{class$java$io$OutputStream == null ? (class$java$io$OutputStream = HttpOutputStream.class$("java.io.OutputStream")) : class$java$io$OutputStream};
    private OutputStream _out;
    private OutputStream _realOut;
    private BufferedOutputStream _bufferedOut;
    private boolean _written = false;
    private ArrayList _observers;
    private int _bufferSize;
    private int _headerReserve;
    private HttpWriter _iso8859writer;
    private HttpWriter _utf8writer;
    private HttpWriter _asciiwriter;
    private boolean _nulled;
    private boolean _closing = false;
    private int _contentLength = -1;
    private int _bytes;
    private boolean _disableFlush;
    static /* synthetic */ Class class$org$mortbay$http$HttpOutputStream;
    static /* synthetic */ Class class$java$io$OutputStream;

    public HttpOutputStream(OutputStream outputStream) {
        this(outputStream, 4096, 512);
    }

    public HttpOutputStream(OutputStream outputStream, int bufferSize) {
        this(outputStream, bufferSize, 512);
    }

    public HttpOutputStream(OutputStream outputStream, int bufferSize, int headerReserve) {
        this._bufferSize = bufferSize;
        this._headerReserve = headerReserve;
        this._out = this._realOut = outputStream;
    }

    public void setContentLength(int length) {
        if (length >= 0 && length < this._bytes) {
            throw new IllegalStateException();
        }
        this._contentLength = length;
    }

    public void setBufferedOutputStream(BufferedOutputStream bos) {
        this._bufferedOut = bos;
        this._bufferedOut.setCommitObserver(this);
        if (this._out != null && this._out != this._realOut) {
            this._out = this._bufferedOut;
        }
    }

    public OutputStream getOutputStream() {
        return this._realOut;
    }

    public OutputStream getBufferedOutputStream() {
        return this._out;
    }

    public boolean isWritten() {
        return this._written;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (size <= this._bufferSize) {
            return;
        }
        if (this._bufferedOut != null && this._bufferedOut.size() > 0) {
            throw new IllegalStateException("Not Reset");
        }
        try {
            this._bufferSize = size;
            if (this._bufferedOut != null) {
                boolean fixed = this._bufferedOut.isFixed();
                this._bufferedOut.setFixed(false);
                this._bufferedOut.ensureSize(size);
                this._bufferedOut.setFixed(fixed);
            }
        }
        catch (IOException e) {
            log.warn("EXCEPTION ", e);
        }
    }

    public int getBytesWritten() {
        return this._bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBuffer() throws IllegalStateException {
        if (this._out != null && this._out != this._realOut) {
            ArrayList save_observers = this._observers;
            this._observers = null;
            this._nulled = true;
            try {
                block7: {
                    try {
                        if (this._bufferedOut == null) break block7;
                        this._bufferedOut.resetStream();
                        if (!(this._bufferedOut instanceof ChunkingOutputStream)) break block7;
                        ((ChunkingOutputStream)this._bufferedOut).setChunking(false);
                    }
                    catch (Exception e) {
                        LogSupport.ignore(log, e);
                        Object var4_4 = null;
                        this._observers = save_observers;
                    }
                }
                Object var4_3 = null;
                this._observers = save_observers;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this._observers = save_observers;
                throw throwable;
            }
        }
        this._contentLength = -1;
        this._nulled = false;
        this._bytes = 0;
        this._written = false;
        this._out = this._realOut;
        try {
            this.notify(1);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
    }

    public void addObserver(OutputObserver observer) {
        if (this._observers == null) {
            this._observers = new ArrayList(4);
        }
        this._observers.add(observer);
        this._observers.add(null);
    }

    public void addObserver(OutputObserver observer, Object data) {
        if (this._observers == null) {
            this._observers = new ArrayList(4);
        }
        this._observers.add(observer);
        this._observers.add(data);
    }

    public void resetObservers() {
        this._observers = null;
    }

    public void nullOutput() throws IOException {
        this._nulled = true;
    }

    public boolean isNullOutput() throws IOException {
        return this._nulled;
    }

    public void setChunking() {
        this.checkOutput();
        if (!(this._bufferedOut instanceof ChunkingOutputStream)) {
            throw new IllegalStateException(this._bufferedOut.getClass().toString());
        }
        ((ChunkingOutputStream)this._bufferedOut).setChunking(true);
    }

    public boolean isChunking() {
        return this._bufferedOut instanceof ChunkingOutputStream && ((ChunkingOutputStream)this._bufferedOut).isChunking();
    }

    public void resetStream() throws IOException, IllegalStateException {
        if (this.isChunking()) {
            this.close();
        }
        this._out = null;
        this._nulled = true;
        if (this._bufferedOut != null) {
            this._bufferedOut.resetStream();
            if (this._bufferedOut instanceof ChunkingOutputStream) {
                ((ChunkingOutputStream)this._bufferedOut).setChunking(false);
            }
        }
        if (this._iso8859writer != null) {
            this._iso8859writer.flush();
        }
        if (this._utf8writer != null) {
            this._utf8writer.flush();
        }
        if (this._asciiwriter != null) {
            this._asciiwriter.flush();
        }
        this._bytes = 0;
        this._written = false;
        this._out = this._realOut;
        this._closing = false;
        this._contentLength = -1;
        this._nulled = false;
        if (this._observers != null) {
            this._observers.clear();
        }
    }

    public void destroy() {
        if (this._bufferedOut != null) {
            this._bufferedOut.destroy();
        }
        this._bufferedOut = null;
        if (this._iso8859writer != null) {
            this._iso8859writer.destroy();
        }
        this._iso8859writer = null;
        if (this._utf8writer != null) {
            this._utf8writer.destroy();
        }
        this._utf8writer = null;
        if (this._asciiwriter != null) {
            this._asciiwriter.destroy();
        }
        this._asciiwriter = null;
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        this.checkOutput();
        this._bufferedOut.writeHeader(httpMessage);
    }

    public void write(int b) throws IOException {
        this.prepareOutput(1);
        if (!this._nulled) {
            this._out.write(b);
        }
        if (this._bytes == this._contentLength) {
            this.flush();
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        len = this.prepareOutput(len);
        if (!this._nulled) {
            this._out.write(b, off, len);
        }
        if (this._bytes == this._contentLength) {
            this.flush();
        }
    }

    protected void checkOutput() {
        if (this._out == this._realOut) {
            if (this._bufferedOut == null) {
                this._bufferedOut = new ChunkingOutputStream(this._realOut, this._bufferSize, this._headerReserve, false);
                this._bufferedOut.setCommitObserver(this);
                this._bufferedOut.setBypassBuffer(true);
                this._bufferedOut.setFixed(true);
            }
            this._out = this._bufferedOut;
        }
    }

    protected int prepareOutput(int length) throws IOException {
        if (this._out == null) {
            throw new IOException("closed");
        }
        this.checkOutput();
        if (!this._written) {
            this._written = true;
            this.notify(0);
        }
        if (this._contentLength >= 0 && this._bytes + length >= this._contentLength && (length = this._contentLength - this._bytes) == 0) {
            this._nulled = true;
        }
        this._bytes += length;
        return length;
    }

    public void flush() throws IOException {
        if (!this._disableFlush && this._out != null && !this._closing) {
            this._out.flush();
        }
    }

    public boolean isClosed() throws IOException {
        return this._out == null;
    }

    public void close() throws IOException {
        if (this._out == null) {
            return;
        }
        this._closing = true;
        try {
            this.notify(4);
            OutputStream out = this._out;
            this._out = null;
            if (out != this._bufferedOut) {
                out.close();
            } else {
                this._bufferedOut.close();
            }
            this.notify(5);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
    }

    public void outputNotify(OutputStream out, int action, Object ignoredData) throws IOException {
        this.notify(action);
    }

    private void notify(int action) throws IOException {
        if (this._observers != null) {
            int i = this._observers.size();
            while (i-- > 0) {
                Object data = this._observers.get(i--);
                ((OutputObserver)this._observers.get(i)).outputNotify(this, action, data);
            }
        }
    }

    public void write(InputStream in, int len) throws IOException {
        IO.copy(in, this, (long)len);
    }

    private Writer getISO8859Writer() throws IOException {
        if (this._iso8859writer == null) {
            this._iso8859writer = new HttpWriter(StringUtil.__ISO_8859_1, this.getBufferSize());
        }
        return this._iso8859writer;
    }

    private Writer getUTF8Writer() throws IOException {
        if (this._utf8writer == null) {
            this._utf8writer = new HttpWriter("UTF-8", this.getBufferSize());
        }
        return this._utf8writer;
    }

    private Writer getASCIIWriter() throws IOException {
        if (this._asciiwriter == null) {
            this._asciiwriter = new HttpWriter("US-ASCII", this.getBufferSize());
        }
        return this._asciiwriter;
    }

    public Writer getWriter(String encoding) throws IOException {
        if (encoding == null || StringUtil.__ISO_8859_1.equalsIgnoreCase(encoding) || "ISO8859_1".equalsIgnoreCase(encoding)) {
            return this.getISO8859Writer();
        }
        if ("UTF-8".equalsIgnoreCase(encoding) || "UTF8".equalsIgnoreCase(encoding)) {
            return this.getUTF8Writer();
        }
        if ("US-ASCII".equalsIgnoreCase(encoding)) {
            return this.getASCIIWriter();
        }
        return new OutputStreamWriter((OutputStream)this, encoding);
    }

    public String toString() {
        return super.toString() + "\nout=" + this._out + "\nrealOut=" + this._realOut + "\nbufferedOut=" + this._bufferedOut;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HttpWriter
    extends Writer {
        private OutputStreamWriter _writer = null;
        private boolean _writting = false;
        private byte[] _buf;
        private String _encoding;

        HttpWriter(String encoding, int bufferSize) {
            this._buf = ByteArrayPool.getByteArray(bufferSize);
            this._encoding = encoding;
        }

        public Object getLock() {
            return this.lock;
        }

        public void write(char c) throws IOException {
            HttpOutputStream.this.prepareOutput(1);
            if (!HttpOutputStream.this._nulled) {
                if (this._writting) {
                    this._writer.write(c);
                } else if (c >= '\u0000' && c <= '\u007f') {
                    HttpOutputStream.this.write(c);
                } else {
                    char[] ca = new char[]{c};
                    this.writeEncoded(ca, 0, 1);
                }
                if (HttpOutputStream.this._bytes == HttpOutputStream.this._contentLength) {
                    this.flush();
                }
            }
        }

        public void write(char[] ca) throws IOException {
            this.write(ca, 0, ca.length);
        }

        public void write(char[] ca, int offset, int len) throws IOException {
            if (this._writting) {
                this._writer.write(ca, offset, len);
            } else {
                int s = 0;
                int i = 0;
                while (i < len) {
                    char c = ca[offset + i];
                    if (c >= '\u0000' && c <= '\u007f') {
                        this._buf[s++] = (byte)c;
                        if (s == this._buf.length) {
                            s = HttpOutputStream.this.prepareOutput(s);
                            if (!HttpOutputStream.this._nulled) {
                                HttpOutputStream.this._out.write(this._buf, 0, s);
                            }
                            s = 0;
                        }
                    } else {
                        if (s > 0) {
                            s = HttpOutputStream.this.prepareOutput(s);
                            if (!HttpOutputStream.this._nulled) {
                                HttpOutputStream.this._out.write(this._buf, 0, s);
                            }
                            s = 0;
                        }
                        this.writeEncoded(ca, offset + i, len - i);
                        break;
                    }
                    ++i;
                }
                if (s > 0) {
                    s = HttpOutputStream.this.prepareOutput(s);
                    if (!HttpOutputStream.this._nulled) {
                        HttpOutputStream.this._out.write(this._buf, 0, s);
                    }
                    s = 0;
                }
            }
            if (!HttpOutputStream.this._nulled && HttpOutputStream.this._bytes == HttpOutputStream.this._contentLength) {
                this.flush();
            }
        }

        public void write(String s) throws IOException {
            this.write(s, 0, s.length());
        }

        public void write(String str, int offset, int len) throws IOException {
            if (this._writting) {
                this._writer.write(str, offset, len);
            } else {
                int s = 0;
                int i = 0;
                while (i < len) {
                    char c = str.charAt(offset + i);
                    if (c >= '\u0000' && c <= '\u007f') {
                        this._buf[s++] = (byte)c;
                        if (s == this._buf.length) {
                            s = HttpOutputStream.this.prepareOutput(s);
                            if (!HttpOutputStream.this._nulled) {
                                HttpOutputStream.this._out.write(this._buf, 0, s);
                            }
                            s = 0;
                        }
                    } else {
                        if (s > 0) {
                            s = HttpOutputStream.this.prepareOutput(s);
                            if (!HttpOutputStream.this._nulled) {
                                HttpOutputStream.this._out.write(this._buf, 0, s);
                            }
                            s = 0;
                        }
                        char[] chars = str.toCharArray();
                        this.writeEncoded(chars, offset + i, chars.length - (offset + i));
                        break;
                    }
                    ++i;
                }
                if (s > 0) {
                    s = HttpOutputStream.this.prepareOutput(s);
                    if (!HttpOutputStream.this._nulled) {
                        HttpOutputStream.this._out.write(this._buf, 0, s);
                    }
                    s = 0;
                }
            }
            if (HttpOutputStream.this._bytes == HttpOutputStream.this._contentLength) {
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeEncoded(char[] ca, int offset, int length) throws IOException {
            this._writting = true;
            if (this._writer == null) {
                this._writer = new OutputStreamWriter((OutputStream)HttpOutputStream.this, this._encoding);
            }
            try {
                HttpOutputStream.this._disableFlush = true;
                this._writer.write(ca, offset, length);
                if (HttpOutputStream.this._contentLength >= 0) {
                    this._writer.flush();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                HttpOutputStream.this._disableFlush = false;
                throw throwable;
            }
            HttpOutputStream.this._disableFlush = false;
        }

        public void flush() throws IOException {
            if (this._writting) {
                this._writer.flush();
            } else {
                HttpOutputStream.this.flush();
            }
            this._writting = false;
        }

        public void close() throws IOException {
            HttpOutputStream.this._closing = true;
            if (this._writting) {
                this._writer.flush();
            }
            HttpOutputStream.this.close();
            this._writting = false;
        }

        public void destroy() {
            ByteArrayPool.returnByteArray(this._buf);
            this._buf = null;
            this._writer = null;
            this._encoding = null;
        }
    }
}

