/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class LicenseScreen
extends InstallerScreen {
    private JTextPane txaLicense;
    private JScrollPane scpLicense;
    private JRadioButton rdoLicenseAccept;
    private JRadioButton rdoLicenseRefuse;
    private ButtonGroup bgrLicense;
    private String licenseText;

    public LicenseScreen(InstallerWizard installerWizard, String string) {
        super(installerWizard);
        this.licenseText = string == null ? "" : LicenseScreen.sanitizeHTML(string);
        this.initScreen();
    }

    public void activate() {
        this.txaLicense.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        super.activate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.rdoLicenseAccept) {
            this.btnForward.setEnabled(true);
        } else if (object == this.rdoLicenseRefuse) {
            this.btnForward.setEnabled(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void setupControls() {
        boolean bl;
        super.setupControls();
        this.txaLicense = new JTextPane();
        boolean bl2 = bl = this.licenseText.toLowerCase().indexOf("<html>") > -1;
        if (bl) {
            this.txaLicense.setEditorKit(new HTMLEditorKit());
        }
        this.txaLicense.setText(this.licenseText);
        Font font = UIManager.getFont("TextField.font");
        if (bl) {
            StyleSheet styleSheet = ((HTMLEditorKit)this.txaLicense.getEditorKit()).getStyleSheet();
            styleSheet.addRule("body {font-size : " + font.getSize() + "pt; }");
            styleSheet.addRule("body {font-family :" + font.getFontName() + "; }");
        } else {
            this.txaLicense.setFont(font);
        }
        this.txaLicense.setEditable(false);
        this.scpLicense = new JScrollPane(this.txaLicense);
        this.rdoLicenseAccept = new JRadioButton(this.messages.getString("LicenseAccepted"));
        this.rdoLicenseRefuse = new JRadioButton(this.messages.getString("LicenseNotAccepted"), true);
        this.bgrLicense = new ButtonGroup();
        this.bgrLicense.add(this.rdoLicenseAccept);
        this.bgrLicense.add(this.rdoLicenseRefuse);
        this.btnForward.setEnabled(false);
    }

    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.rdoLicenseAccept.addActionListener(this);
        this.rdoLicenseRefuse.addActionListener(this);
        this.txaLicense.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    GUIHelper.showURL(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        });
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(this.messages.getString("LicenseLabel3"), jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.scpLicense, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 10;
        jPanel.add((Component)this.rdoLicenseAccept, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 10;
        jPanel.add((Component)this.rdoLicenseRefuse, gridBagConstraints);
        gridBagConstraints.insets.top = 3;
    }

    protected boolean needsSpacer() {
        return false;
    }

    protected String getTitle() {
        return this.messages.getString("WizardLicense");
    }

    protected String getSubTitle() {
        return this.messages.getString("LicenseLabel");
    }
}

