/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.configuration.XMLConfigurator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JAXPConfigurator {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$configuration$JAXPConfigurator == null ? (class$org$logicalcobwebs$proxool$configuration$JAXPConfigurator = JAXPConfigurator.class$("org.logicalcobwebs.proxool.configuration.JAXPConfigurator")) : class$org$logicalcobwebs$proxool$configuration$JAXPConfigurator));
    private static final boolean NAMESPACE_AWARE = true;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$configuration$JAXPConfigurator;

    public static void configure(String xmlFileName, boolean validate) throws ProxoolException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Configuring from xml file: " + xmlFileName));
            }
            JAXPConfigurator.configure(new InputSource(new FileReader(xmlFileName)), validate);
        }
        catch (FileNotFoundException e) {
            throw new ProxoolException(e);
        }
    }

    public static void configure(InputSource inputSource, boolean validate) throws ProxoolException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SAXParserFactory class: " + saxParserFactory.getClass().getName()));
            }
            saxParserFactory.setValidating(validate);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sax parser class" + saxParser.getClass().getName()));
            }
            XMLReader xmlReader = saxParser.getXMLReader();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XML reader class: " + xmlReader.getClass().getName()));
            }
            XMLConfigurator xmlConfigurator = new XMLConfigurator();
            xmlReader.setErrorHandler(xmlConfigurator);
            JAXPConfigurator.setSAXFeature(xmlReader, "http://xml.org/sax/features/namespaces", true);
            JAXPConfigurator.setSAXFeature(xmlReader, "http://xml.org/sax/features/namespace-prefixes", false);
            saxParser.parse(inputSource, (DefaultHandler)xmlConfigurator);
        }
        catch (ParserConfigurationException pce) {
            throw new ProxoolException("Parser configuration failed", pce);
        }
        catch (SAXException se) {
            throw new ProxoolException("Parsing failed.", se);
        }
        catch (IOException ioe) {
            throw new ProxoolException("Parsing failed.", ioe);
        }
    }

    public static void configure(Reader reader, boolean validate) throws ProxoolException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Configuring from reader: " + reader));
        }
        JAXPConfigurator.configure(new InputSource(reader), validate);
    }

    private static void setSAXFeature(XMLReader xmlReader, String feature, boolean state) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting sax feature: '" + feature + "'. State: " + state + "."));
        }
        try {
            xmlReader.setFeature(feature, state);
        }
        catch (SAXNotRecognizedException e) {
            LOG.warn((Object)("Feature: '" + feature + "' not recognised by xml reader " + xmlReader + "."), (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            LOG.warn((Object)("Feature: '" + feature + "' not supported by xml reader " + xmlReader + "."), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

