/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.XmlReplace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;

public class XmlReplacement {
    private final List replacements = new ArrayList();
    private final Task task;
    private final Document doc;
    private boolean report = false;
    private int failures = 0;

    public XmlReplacement(Document doc, Task task) {
        this.doc = doc;
        this.task = task;
    }

    public void add(XmlReplace x) {
        this.replacements.add(x);
    }

    public Document apply() {
        Iterator ireplacements = this.replacements.iterator();
        boolean success = true;
        while (ireplacements.hasNext() && success) {
            XmlReplace xr = (XmlReplace)ireplacements.next();
            try {
                int matches = xr.apply(this.doc);
                if (matches == 0) {
                    ++this.failures;
                    this.task.log(xr + " failed to match", 3);
                }
                this.doc.getDocumentElement().normalize();
                if (!this.report) continue;
                this.output();
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
                ++this.failures;
            }
        }
        return this.doc;
    }

    private void output() throws Exception {
        this.output("Document", this.doc);
    }

    private void output(String label, Document dc) throws Exception {
        this.task.log(label + " -->");
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        serializer.transform(new DOMSource(dc), new StreamResult(System.out));
        this.task.log("");
        this.task.log(label + " <--");
    }

    public void setReport(boolean val) {
        this.report = val;
    }

    public int getFailures() {
        return this.failures;
    }
}

