/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.RESTServicePlugin;
import org.jivesoftware.openfire.plugin.rest.entity.SystemProperties;
import org.jivesoftware.openfire.plugin.rest.entity.SystemProperty;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/system/properties")
public class RestAPIService {
    private RESTServicePlugin plugin;

    @PostConstruct
    public void init() {
        this.plugin = RESTServicePlugin.getInstance();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public SystemProperties getSystemProperties() {
        return this.plugin.getSystemProperties();
    }

    @GET
    @Path(value="/{propertyKey}")
    @Produces(value={"application/xml", "application/json"})
    public SystemProperty getSystemProperty(@PathParam(value="propertyKey") String propertyKey) throws ServiceException {
        return this.plugin.getSystemProperty(propertyKey);
    }

    @POST
    public Response createSystemProperty(SystemProperty systemProperty) throws ServiceException {
        this.plugin.createSystemProperty(systemProperty);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/{propertyKey}")
    public Response updateUser(@PathParam(value="propertyKey") String propertyKey, SystemProperty systemProperty) throws ServiceException {
        this.plugin.updateSystemProperty(propertyKey, systemProperty);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteUser(@PathParam(value="propertyKey") String propertyKey) throws ServiceException {
        this.plugin.deleteSystemProperty(propertyKey);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

