/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.xmpp.packet.JID;

public class UserServiceLegacyController {
    public static final UserServiceLegacyController INSTANCE = new UserServiceLegacyController();
    private UserManager userManager;
    private RosterManager rosterManager;
    private XMPPServer server = XMPPServer.getInstance();

    public static UserServiceLegacyController getInstance() {
        return INSTANCE;
    }

    private UserServiceLegacyController() {
        this.userManager = this.server.getUserManager();
        this.rosterManager = this.server.getRosterManager();
    }

    public void createUser(String username, String password, String name, String email, String groupNames) throws UserAlreadyExistsException, GroupAlreadyExistsException, UserNotFoundException, GroupNotFoundException {
        this.userManager.createUser(username, password, name, email);
        this.userManager.getUser(username);
        if (groupNames != null) {
            ArrayList<Group> groups = new ArrayList<Group>();
            StringTokenizer tkn = new StringTokenizer(groupNames, ",");
            while (tkn.hasMoreTokens()) {
                String groupName = tkn.nextToken();
                Group group = null;
                try {
                    group = GroupManager.getInstance().getGroup(groupName);
                }
                catch (GroupNotFoundException e) {
                    group = GroupManager.getInstance().createGroup(groupName);
                    group.getProperties().put((Object)"sharedRoster.showInRoster", (Object)"onlyGroup");
                    group.getProperties().put((Object)"sharedRoster.displayName", (Object)groupName);
                    group.getProperties().put((Object)"sharedRoster.groupList", (Object)"");
                }
                groups.add(group);
            }
            for (Group group : groups) {
                group.getMembers().add(this.server.createJID(username, null));
            }
        }
    }

    public void deleteUser(String username) throws UserNotFoundException, SharedGroupException {
        User user = this.getUser(username);
        this.userManager.deleteUser(user);
        this.rosterManager.deleteRoster(this.server.createJID(username, null));
    }

    public void disableUser(String username) throws UserNotFoundException {
        this.getUser(username);
        LockOutManager.getInstance().disableAccount(username, null, null);
    }

    public void enableUser(String username) throws UserNotFoundException {
        this.getUser(username);
        LockOutManager.getInstance().enableAccount(username);
    }

    public void updateUser(String username, String password, String name, String email, String groupNames) throws UserNotFoundException, GroupAlreadyExistsException {
        User user = this.getUser(username);
        if (password != null) {
            user.setPassword(password);
        }
        if (name != null) {
            user.setName(name);
        }
        if (email != null) {
            user.setEmail(email);
        }
        if (groupNames != null) {
            ArrayList<Group> newGroups = new ArrayList<Group>();
            StringTokenizer tkn = new StringTokenizer(groupNames, ",");
            while (tkn.hasMoreTokens()) {
                String groupName = tkn.nextToken();
                Group group = null;
                try {
                    group = GroupManager.getInstance().getGroup(groupName);
                }
                catch (GroupNotFoundException e) {
                    group = GroupManager.getInstance().createGroup(groupName);
                    group.getProperties().put((Object)"sharedRoster.showInRoster", (Object)"onlyGroup");
                    group.getProperties().put((Object)"sharedRoster.displayName", (Object)groupName);
                    group.getProperties().put((Object)"sharedRoster.groupList", (Object)"");
                }
                newGroups.add(group);
            }
            Collection existingGroups = GroupManager.getInstance().getGroups(user);
            ArrayList groupsToAdd = new ArrayList(newGroups);
            groupsToAdd.removeAll(existingGroups);
            ArrayList groupsToDelete = new ArrayList(existingGroups);
            groupsToDelete.removeAll(newGroups);
            for (Group group : groupsToAdd) {
                group.getMembers().add(this.server.createJID(username, null));
            }
            for (Group group : groupsToDelete) {
                group.getMembers().remove(this.server.createJID(username, null));
            }
        }
    }

    public void addRosterItem(String username, String itemJID, String itemName, String subscription, String groupNames) throws UserNotFoundException, UserAlreadyExistsException, SharedGroupException {
        this.getUser(username);
        Roster r = this.rosterManager.getRoster(username);
        JID j = new JID(itemJID);
        try {
            r.getRosterItem(j);
            throw new UserAlreadyExistsException(j.toBareJID());
        }
        catch (UserNotFoundException userNotFoundException) {
            if (r != null) {
                ArrayList<String> groups = new ArrayList<String>();
                if (groupNames != null) {
                    StringTokenizer tkn = new StringTokenizer(groupNames, ",");
                    while (tkn.hasMoreTokens()) {
                        groups.add(tkn.nextToken());
                    }
                }
                RosterItem ri = r.createRosterItem(j, itemName, groups, false, true);
                if (subscription == null) {
                    subscription = "0";
                }
                ri.setSubStatus(RosterItem.SubType.getTypeFromInt((int)Integer.parseInt(subscription)));
                r.updateRosterItem(ri);
            }
            return;
        }
    }

    public void updateRosterItem(String username, String itemJID, String itemName, String subscription, String groupNames) throws UserNotFoundException, SharedGroupException {
        this.getUser(username);
        Roster r = this.rosterManager.getRoster(username);
        JID j = new JID(itemJID);
        RosterItem ri = r.getRosterItem(j);
        ArrayList<String> groups = new ArrayList<String>();
        if (groupNames != null) {
            StringTokenizer tkn = new StringTokenizer(groupNames, ",");
            while (tkn.hasMoreTokens()) {
                groups.add(tkn.nextToken());
            }
        }
        ri.setGroups(groups);
        ri.setNickname(itemName);
        if (subscription == null) {
            subscription = "0";
        }
        ri.setSubStatus(RosterItem.SubType.getTypeFromInt((int)Integer.parseInt(subscription)));
        r.updateRosterItem(ri);
    }

    public void deleteRosterItem(String username, String itemJID) throws UserNotFoundException, SharedGroupException {
        this.getUser(username);
        Roster r = this.rosterManager.getRoster(username);
        JID j = new JID(itemJID);
        r.deleteRosterItem(j, true);
    }

    private User getUser(String username) throws UserNotFoundException {
        JID targetJID = this.server.createJID(username, null);
        if (targetJID.getNode() == null) {
            throw new UserNotFoundException("Username is null");
        }
        return this.userManager.getUser(targetJID.getNode());
    }

    public Collection<String> getAllGroups() {
        Collection groups = GroupManager.getInstance().getGroups();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    public Collection<String> getUserGroups(String username) throws UserNotFoundException {
        User user = this.getUser(username);
        Collection groups = GroupManager.getInstance().getGroups(user);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }
}

