/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;

public class InterestInfo
implements LiveWritable {
    public static final int TYPE_PARENT = 1;
    public static final int TYPE_CHILD = 2;
    private final int type;
    private final int parent;
    private final String name;
    private final int totalSize;

    protected static InterestInfo readInterestInfo(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 4) {
            return null;
        }
        short s = BinaryTools.getUByte(byteBlock, 0);
        short s2 = BinaryTools.getUByte(byteBlock, 1);
        int n = BinaryTools.getUShort(byteBlock, 2);
        if (byteBlock.getLength() < n + 4) {
            return null;
        }
        ByteBlock byteBlock2 = byteBlock.subBlock(4, n);
        String string = BinaryTools.getAsciiString(byteBlock2);
        int n2 = 4 + n;
        return new InterestInfo(s, s2, string, n2);
    }

    protected InterestInfo(int n, int n2, String string, int n3) {
        DefensiveTools.checkRange(n, "type", 0);
        DefensiveTools.checkRange(n2, "parent", 0);
        DefensiveTools.checkNull(string, "name");
        DefensiveTools.checkRange(n3, "totalSize", -1);
        this.type = n;
        this.parent = n2;
        this.name = string;
        this.totalSize = n3;
    }

    public InterestInfo(int n, int n2, String string) {
        this(n, n2, string, -1);
    }

    public final int getType() {
        return this.type;
    }

    public final int getParentId() {
        return this.parent;
    }

    public final String getName() {
        return this.name;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUByte(outputStream, this.type);
        BinaryTools.writeUByte(outputStream, this.parent);
        byte[] byArray = BinaryTools.getAsciiBytes(this.name);
        BinaryTools.writeUShort(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    public String toString() {
        return "InterestInfo: type=" + this.type + ", parent=" + this.parent + ": " + this.name;
    }
}

