/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.buddy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.buddy.BuddyCommand;

public class BuddyOfflineCmd
extends BuddyCommand {
    private final String sn;

    protected BuddyOfflineCmd(SnacPacket snacPacket) {
        super(12);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        this.sn = stringBlock == null ? null : stringBlock.getString();
    }

    public BuddyOfflineCmd(String string) {
        super(12);
        DefensiveTools.checkNull(string, "sn");
        this.sn = string;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
    }

    public String toString() {
        return "BuddyOfflineCmd for " + this.sn;
    }
}

