/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.SeqNum;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapCommandFactory;
import net.kano.joscar.flap.FlapExceptionEvent;
import net.kano.joscar.flap.FlapExceptionHandler;
import net.kano.joscar.flap.FlapHeader;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.flap.FlapPacketEvent;
import net.kano.joscar.flap.FlapPacketListener;
import net.kano.joscar.flap.VetoableFlapPacketListener;
import net.kano.joscar.net.ConnProcessor;

public class FlapProcessor
extends ConnProcessor {
    private static final Logger logger = Logger.getLogger("net.kano.joscar.flap");
    private static final int SEQNUM_MAX = 65535;
    private final CopyOnWriteArrayList errorHandlers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList packetListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList vetoablePacketListeners = new CopyOnWriteArrayList();
    private final Object writeLock = new Object();
    private final Object readLock = new Object();
    private SeqNum seqNum = new SeqNum(0L, 65535L);
    private FlapCommandFactory commandFactory = null;

    public FlapProcessor() {
    }

    public FlapProcessor(Socket socket) throws IOException {
        this.attachToSocket(socket);
    }

    public final void addVetoablePacketListener(VetoableFlapPacketListener vetoableFlapPacketListener) {
        DefensiveTools.checkNull(vetoableFlapPacketListener, "listener");
        this.vetoablePacketListeners.addIfAbsent(vetoableFlapPacketListener);
    }

    public final void removeVetoablePacketListener(VetoableFlapPacketListener vetoableFlapPacketListener) {
        DefensiveTools.checkNull(vetoableFlapPacketListener, "listener");
        this.vetoablePacketListeners.remove(vetoableFlapPacketListener);
    }

    public final void addPacketListener(FlapPacketListener flapPacketListener) {
        DefensiveTools.checkNull(flapPacketListener, "listener");
        this.packetListeners.addIfAbsent(flapPacketListener);
    }

    public final void removePacketListener(FlapPacketListener flapPacketListener) {
        DefensiveTools.checkNull(flapPacketListener, "listener");
        this.packetListeners.remove(flapPacketListener);
    }

    public final void addExceptionHandler(FlapExceptionHandler flapExceptionHandler) {
        DefensiveTools.checkNull(flapExceptionHandler, "handler");
        this.errorHandlers.addIfAbsent(flapExceptionHandler);
    }

    public final void removeExceptionHandler(FlapExceptionHandler flapExceptionHandler) {
        DefensiveTools.checkNull(flapExceptionHandler, "handler");
        this.errorHandlers.remove(flapExceptionHandler);
    }

    public final synchronized void setFlapCmdFactory(FlapCommandFactory flapCommandFactory) {
        this.commandFactory = flapCommandFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handlePacket(FlapPacket flapPacket) {
        Object object;
        FlapCommandFactory flapCommandFactory;
        DefensiveTools.checkNull(flapPacket, "packet");
        boolean bl = logger.isLoggable(Level.FINE);
        boolean bl2 = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.fine("FlapProcessor received packet: " + flapPacket);
        }
        Object object2 = this;
        synchronized (object2) {
            flapCommandFactory = this.commandFactory;
        }
        object2 = null;
        if (flapCommandFactory != null) {
            try {
                object2 = flapCommandFactory.genFlapCommand(flapPacket);
            }
            catch (Throwable throwable) {
                this.handleException(FlapExceptionEvent.ERRTYPE_CMD_GEN, throwable, flapPacket);
            }
        }
        if (bl) {
            logger.fine("Flap command for " + flapPacket + ": " + object2);
        }
        FlapPacketEvent flapPacketEvent = new FlapPacketEvent(this, flapPacket, (FlapCommand)object2);
        Iterator iterator = this.vetoablePacketListeners.iterator();
        while (iterator.hasNext()) {
            Object object3;
            object = (VetoableFlapPacketListener)iterator.next();
            if (bl2) {
                logger.finer("Running vetoable flap packet listener: " + object);
            }
            try {
                object3 = object.handlePacket(flapPacketEvent);
            }
            catch (Throwable throwable) {
                this.handleException(FlapExceptionEvent.ERRTYPE_PACKET_LISTENER, throwable, object);
                continue;
            }
            if (object3 == VetoableFlapPacketListener.CONTINUE_PROCESSING) continue;
            if (bl2) {
                logger.finer("Flap packet listener vetoed further processing: " + object);
            }
            return;
        }
        iterator = this.packetListeners.iterator();
        while (iterator.hasNext()) {
            object = (FlapPacketListener)iterator.next();
            if (bl2) {
                logger.finer("Running Flap packet listener " + object);
            }
            try {
                object.handleFlapPacket(flapPacketEvent);
            }
            catch (Throwable throwable) {
                this.handleException(FlapExceptionEvent.ERRTYPE_PACKET_LISTENER, throwable, object);
            }
        }
        if (bl2) {
            logger.finer("Finished handling Flap packet");
        }
    }

    public final void handleException(Object object, Throwable throwable) {
        this.handleException(object, throwable, null);
    }

    public final void handleException(Object object, Throwable throwable, Object object2) {
        DefensiveTools.checkNull(object, "type");
        DefensiveTools.checkNull(throwable, "t");
        boolean bl = logger.isLoggable(Level.FINE);
        boolean bl2 = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.fine("Processing flap error (" + object + "): " + throwable.getMessage() + ": " + object2);
        }
        if (object == FlapExceptionEvent.ERRTYPE_CONNECTION_ERROR && !this.isAttached()) {
            if (bl2) {
                logger.finer("Ignoring " + object + " flap error because " + "processor is not attached");
            }
            return;
        }
        if (this.errorHandlers.isEmpty()) {
            logger.warning("FLAP PROCESSOR HAS NO ERROR HANDLERS, DUMPING TO STDERR:");
            logger.warning("ERROR TYPE: " + object);
            logger.warning("ERROR INFO: " + object2);
            logger.warning("EXCEPTION: " + throwable.getMessage());
            logger.warning(Arrays.asList(throwable.getStackTrace()).toString());
            return;
        }
        FlapExceptionEvent flapExceptionEvent = new FlapExceptionEvent(object, this, throwable, object2);
        Iterator iterator = this.errorHandlers.iterator();
        while (iterator.hasNext()) {
            FlapExceptionHandler flapExceptionHandler = (FlapExceptionHandler)iterator.next();
            if (bl2) {
                logger.finer("Running flap error handler " + flapExceptionHandler);
            }
            try {
                flapExceptionHandler.handleException(flapExceptionEvent);
            }
            catch (Throwable throwable2) {
                logger.warning("exception handler threw exception: " + throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendFlap(FlapCommand flapCommand) {
        DefensiveTools.checkNull(flapCommand, "command");
        boolean bl = logger.isLoggable(Level.FINE);
        boolean bl2 = logger.isLoggable(Level.FINER);
        OutputStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            return;
        }
        if (bl2) {
            logger.finer("Sending Flap command " + flapCommand);
        }
        Object object = this.writeLock;
        synchronized (object) {
            ByteBlock byteBlock;
            int n = (int)this.seqNum.next();
            FlapPacket flapPacket = new FlapPacket(n, flapCommand);
            try {
                byteBlock = ByteBlock.createByteBlock(flapPacket);
            }
            catch (Throwable throwable) {
                this.handleException(FlapExceptionEvent.ERRTYPE_CMD_WRITE, throwable, flapCommand);
                return;
            }
            if (bl) {
                logger.fine("Sending Flap packet " + flapPacket + ": " + byteBlock.getLength() + " total bytes");
            }
            try {
                byteBlock.write(outputStream);
            }
            catch (IOException iOException) {
                this.handleException(FlapExceptionEvent.ERRTYPE_CONNECTION_ERROR, iOException);
                return;
            }
        }
        if (bl2) {
            logger.finer("Finished sending Flap command");
        }
    }

    public final void runFlapLoop() throws IOException {
        while (this.readNextFlap()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean readNextFlap() throws IOException {
        boolean bl = logger.isLoggable(Level.FINER);
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return false;
        }
        Object object = this.readLock;
        synchronized (object) {
            FlapHeader flapHeader = FlapHeader.readFLAPHeader(inputStream);
            if (bl) {
                logger.finer("Read flap header " + flapHeader);
            }
            if (flapHeader == null) {
                return false;
            }
            FlapPacket flapPacket = FlapPacket.readRestOfFlap(flapHeader, inputStream);
            if (bl) {
                logger.finer("Read flap packet " + flapPacket);
            }
            if (flapPacket == null) {
                return false;
            }
            this.handlePacket(flapPacket);
            return true;
        }
    }
}

