/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.util.List;
import javax.ws.rs.core.Response;
import org.dom4j.Element;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.vcard.VCardManager;
import org.xmpp.packet.StreamError;

public class JustMarriedController {
    public static boolean changeName(String currentUserName, String newUserName, boolean deleteOldUser, String newEmail, String newRealName) throws ServiceException {
        UserManager userManager = UserManager.getInstance();
        try {
            User currentUser = userManager.getUser(currentUserName);
            String password = AuthFactory.getPassword((String)currentUserName);
            String newName = newRealName == null || newRealName.length() == 0 ? currentUser.getName() : newRealName;
            String newMail = newEmail == null || newEmail.length() == 0 ? currentUser.getEmail() : newEmail;
            User newUser = userManager.createUser(newUserName, password, currentUser.getName(), newMail);
            newUser.setName(newName);
            newUser.setNameVisible(currentUser.isNameVisible());
            newUser.setEmailVisible(currentUser.isEmailVisible());
            newUser.setCreationDate(currentUser.getCreationDate());
            JustMarriedController.copyRoster(currentUser, newUser, currentUserName);
            JustMarriedController.copyProperties(currentUser, newUser);
            JustMarriedController.copyToGroups(currentUserName, newUserName);
            JustMarriedController.copyVCard(currentUserName, newUserName);
            if (deleteOldUser) {
                JustMarriedController.deleteUser(currentUser);
            }
        }
        catch (UserNotFoundException e) {
            throw new ServiceException("Could not find user", currentUserName, "UserNotFoundException", Response.Status.NOT_FOUND, e);
        }
        catch (UserAlreadyExistsException e) {
            throw new ServiceException("Could not create new user", newUserName, "UserAlreadyExistsException", Response.Status.CONFLICT, e);
        }
        return true;
    }

    private static void copyVCard(String currentUserName, String newUserName) throws ServiceException {
        VCardManager vcardManager = VCardManager.getInstance();
        Element vcard = vcardManager.getVCard(currentUserName);
        if (vcard != null) {
            try {
                vcardManager.setVCard(newUserName, vcard);
            }
            catch (Exception e) {
                throw new ServiceException("Could not copy vcard to new user", newUserName, "IllegalArgumentException", Response.Status.BAD_REQUEST, e);
            }
        }
    }

    private static void copyToGroups(String currentUser, String newUser) {
        GroupManager groupManager = GroupManager.getInstance();
        for (Group group : groupManager.getGroups()) {
            if (!group.isUser(currentUser)) continue;
            group.getMembers().add(XMPPServer.getInstance().createJID(newUser, null));
        }
    }

    private static void deleteUser(User oldUser) {
        UserManager.getInstance().deleteUser(oldUser);
        LockOutManager.getInstance().enableAccount(oldUser.getUsername());
        StreamError error = new StreamError(StreamError.Condition.not_authorized);
        for (ClientSession sess : SessionManager.getInstance().getSessions(oldUser.getUsername())) {
            sess.deliverRawText(error.toXML());
            sess.close();
        }
    }

    private static void copyProperties(User currentUser, User newUser) {
        newUser.getProperties().putAll(currentUser.getProperties());
    }

    private static void copyRoster(User currentUser, User newUser, String currentUserName) throws ServiceException {
        Roster newRoster = newUser.getRoster();
        Roster currentRoster = currentUser.getRoster();
        for (RosterItem item : currentRoster.getRosterItems()) {
            try {
                List groups = item.getGroups();
                RosterItem justCreated = newRoster.createRosterItem(item.getJid(), item.getNickname(), groups, true, true);
                justCreated.setAskStatus(item.getAskStatus());
                justCreated.setRecvStatus(item.getRecvStatus());
                justCreated.setSubStatus(item.getSubStatus());
                for (Group gr : item.getSharedGroups()) {
                    justCreated.addSharedGroup(gr);
                }
                for (Group gr : item.getInvisibleSharedGroups()) {
                    justCreated.addInvisibleSharedGroup(gr);
                }
                newRoster.updateRosterItem(justCreated);
                JustMarriedController.addNewUserToOthersRoster(newUser, item, currentUserName);
            }
            catch (UserAlreadyExistsException e) {
                throw new ServiceException("Could not create roster item for user ", newUser.getUsername(), "UserAlreadyExistsException", Response.Status.CONFLICT, e);
            }
            catch (SharedGroupException e) {
                throw new ServiceException("Could not create roster item, because it is a contact from a shared group", newUser.getUsername(), "UserAlreadyExistsException", Response.Status.BAD_REQUEST, e);
            }
            catch (UserNotFoundException e) {
                throw new ServiceException("Could not update roster item for user " + newUser.getUsername() + " because it was not properly created.", newUser.getUsername(), "UserNotFoundException", Response.Status.NOT_FOUND, e);
            }
        }
    }

    private static void addNewUserToOthersRoster(User newUser, RosterItem otherItem, String currentUser) throws ServiceException {
        otherItem.getJid();
        UserManager userManager = UserManager.getInstance();
        String username = otherItem.getJid().getNode();
        if (username != null && username.length() > 0 && userManager.isRegisteredUser(username) && XMPPServer.getInstance().isLocal(XMPPServer.getInstance().createJID(currentUser, null))) {
            try {
                User otherUser = userManager.getUser(username);
                Roster otherRoster = otherUser.getRoster();
                RosterItem oldUserOnOthersRoster = otherRoster.getRosterItem(XMPPServer.getInstance().createJID(currentUser, null));
                try {
                    if (!oldUserOnOthersRoster.isOnlyShared()) {
                        RosterItem justCreated = otherRoster.createRosterItem(XMPPServer.getInstance().createJID(newUser.getUsername(), null), oldUserOnOthersRoster.getNickname(), oldUserOnOthersRoster.getGroups(), true, true);
                        justCreated.setAskStatus(oldUserOnOthersRoster.getAskStatus());
                        justCreated.setRecvStatus(oldUserOnOthersRoster.getRecvStatus());
                        justCreated.setSubStatus(oldUserOnOthersRoster.getSubStatus());
                        otherRoster.updateRosterItem(justCreated);
                    }
                }
                catch (UserAlreadyExistsException e) {
                    throw new ServiceException("Could not create roster item for user ", newUser.getUsername(), "UserAlreadyExistsException", Response.Status.CONFLICT, e);
                }
                catch (SharedGroupException e) {
                    throw new ServiceException("Could not create roster item, because it is a contact from a shared group", newUser.getUsername(), "UserAlreadyExistsException", Response.Status.BAD_REQUEST, e);
                }
            }
            catch (UserNotFoundException e) {
                throw new ServiceException("Could not create roster item for user " + newUser.getUsername() + "  because it is a contact from a shared group.", newUser.getUsername(), "UserNotFoundException", Response.Status.NOT_FOUND, e);
            }
        }
    }
}

