/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpMessage;
import org.mortbay.util.ByteArrayISO8859Writer;

public class NullableOutputStream
extends FilterOutputStream
implements HttpMessage.HeaderWriter {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$NullableOutputStream == null ? (class$org$mortbay$http$NullableOutputStream = NullableOutputStream.class$("org.mortbay.http.NullableOutputStream")) : class$org$mortbay$http$NullableOutputStream));
    private ByteArrayISO8859Writer _httpMessageWriter;
    private boolean _nulled = false;
    private boolean _closed = false;
    private int _headerReserve;
    static /* synthetic */ Class class$org$mortbay$http$NullableOutputStream;

    public NullableOutputStream(OutputStream outputStream, int headerReserve) {
        super(outputStream);
        this._headerReserve = headerReserve;
    }

    public void nullOutput() throws IOException {
        this._nulled = true;
    }

    public boolean isNullOutput() throws IOException {
        return this._nulled;
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        if (this._httpMessageWriter == null) {
            this._httpMessageWriter = new ByteArrayISO8859Writer(this._headerReserve);
        }
        httpMessage.writeHeader(this._httpMessageWriter);
        this._httpMessageWriter.writeTo(this.out);
        this._httpMessageWriter.resetWriter();
    }

    public void resetStream() {
        this._closed = false;
        this._nulled = false;
        if (this._httpMessageWriter != null) {
            this._httpMessageWriter.resetWriter();
        }
    }

    public void destroy() {
        if (this._httpMessageWriter != null) {
            this._httpMessageWriter.destroy();
        }
        this._httpMessageWriter = null;
        try {
            this.out.close();
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    public void write(int b) throws IOException {
        if (!this._nulled) {
            if (this._closed) {
                throw new IOException("closed");
            }
            this.out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        if (!this._nulled) {
            if (this._closed) {
                throw new IOException("closed");
            }
            this.out.write(b, 0, b.length);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this._nulled) {
            if (this._closed) {
                throw new IOException("closed");
            }
            this.out.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        if (!this._nulled && !this._closed) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        this._closed = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

