/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar;

import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flap.ClientFlapConn;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapCommandFactory;
import net.kano.joscar.flap.FlapPacketEvent;
import net.kano.joscar.flap.FlapPacketListener;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flapcmd.CloseFlapCmd;
import net.kano.joscar.flapcmd.DefaultFlapCmdFactory;
import net.kano.joscar.flapcmd.FlapErrorCmd;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.net.ClientConn;
import net.kano.joscar.net.ClientConnEvent;
import net.kano.joscar.net.ClientConnListener;
import net.kano.joscar.net.ConnDescriptor;
import net.kano.joscar.ratelim.RateLimitingQueueMgr;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.FamilyVersionPreprocessor;
import net.kano.joscar.snac.SnacCmdFactoryList;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacPacketListener;
import net.kano.joscar.snac.SnacPreprocessor;
import net.kano.joscar.snac.SnacQueueManager;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import net.kano.joscar.snaccmd.DefaultClientFactoryList;
import net.kano.joscar.snaccmd.error.SnacError;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.oscar.oscar.KeepaliveSender;
import net.kano.joustsim.oscar.oscar.OscarConnDisconnectEvent;
import net.kano.joustsim.oscar.oscar.OscarConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.service.MutableService;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.ServiceEvent;
import net.kano.joustsim.oscar.oscar.service.ServiceFactory;
import net.kano.joustsim.oscar.oscar.service.ServiceListener;
import net.kano.joustsim.oscar.oscar.service.ServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OscarConnection {
    private static final Logger LOGGER = Logger.getLogger(OscarConnection.class.getName());
    private final ClientFlapConn conn;
    private final String host;
    private final int port;
    private boolean triedConnect = false;
    private boolean disconnected = false;
    private final FlapProcessor flapProcessor;
    private final ClientSnacProcessor snacProcessor;
    private int[] snacFamilies = null;
    private final ServiceManager serviceManager = new ServiceManager();
    private ServiceFactory serviceFactory = null;
    private CopyOnWriteArrayList<OscarConnListener> listeners = new CopyOnWriteArrayList();
    private int lastCloseCode = -1;
    private List<ServiceEvent> eventLog = new ArrayList<ServiceEvent>();
    private CopyOnWriteArrayList<ServiceListener> globalServiceListeners = new CopyOnWriteArrayList();
    private Set<Service> unready = new HashSet<Service>();
    private Set<Service> unfinished = new HashSet<Service>();
    private final RateLimitingQueueMgr rateManager = new RateLimitingQueueMgr();

    public OscarConnection(String host, int port) {
        DefensiveTools.checkNull((Object)host, (String)"host");
        DefensiveTools.checkRange((int)port, (String)"port", (int)0);
        this.host = host;
        this.port = port;
        this.conn = new ClientFlapConn(new ConnDescriptor(host, port));
        this.flapProcessor = this.conn.getFlapProcessor();
        this.flapProcessor.setFlapCmdFactory((FlapCommandFactory)new DefaultFlapCmdFactory());
        this.snacProcessor = new ClientSnacProcessor(this.flapProcessor);
        this.snacProcessor.getCmdFactoryMgr().setDefaultFactoryList((SnacCmdFactoryList)new DefaultClientFactoryList());
        this.snacProcessor.addPreprocessor((SnacPreprocessor)new FamilyVersionPreprocessor());
        this.flapProcessor.addPacketListener(new FlapPacketListener(){

            public void handleFlapPacket(FlapPacketEvent flapPacketEvent) {
                FlapCommand flapCommand = flapPacketEvent.getFlapCommand();
                if (flapCommand instanceof FlapErrorCmd) {
                    FlapErrorCmd flapErrorCmd = (FlapErrorCmd)flapCommand;
                    LOGGER.warning("Received FLAP error packet: " + flapErrorCmd);
                }
                OscarConnection.this.handleFlapPacket(flapPacketEvent);
            }
        });
        this.snacProcessor.addPacketListener(new SnacPacketListener(){

            public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
                SnacCommand snacCommand = snacPacketEvent.getSnacCommand();
                if (snacCommand instanceof SnacError) {
                    SnacError snacError = (SnacError)snacCommand;
                    LOGGER.warning("Received SNAC error packet: " + snacError);
                }
                OscarConnection.this.handleSnacPacket(snacPacketEvent);
            }
        });
        this.snacProcessor.addGlobalResponseListener(new SnacResponseListener(){

            public void handleResponse(SnacResponseEvent snacResponseEvent) {
                OscarConnection.this.handleSnacResponse(snacResponseEvent);
            }
        });
        this.snacProcessor.setSnacQueueManager((SnacQueueManager)this.rateManager);
        this.conn.addConnListener(new ClientConnListener(){

            public void stateChanged(ClientConnEvent clientConnEvent) {
                ClientConn.State state = clientConnEvent.getNewState();
                if (state == ClientConn.STATE_CONNECTED) {
                    OscarConnection.this.beforeServicesConnected();
                    OscarConnection.this.internalConnected();
                    OscarConnection.this.connected();
                } else if (state == ClientConn.STATE_FAILED) {
                    OscarConnection.this.connFailed();
                } else if (state == ClientConn.STATE_NOT_CONNECTED) {
                    OscarConnection.this.internalDisconnected();
                    OscarConnection.this.disconnected();
                }
                OscarConnection.this.stateChanged(clientConnEvent);
            }
        });
        KeepaliveSender.start(this);
    }

    public RateLimitingQueueMgr getRateManager() {
        return this.rateManager;
    }

    public void addOscarListener(OscarConnListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeOscarListener(OscarConnListener l) {
        this.listeners.remove((Object)l);
    }

    private void internalConnected() {
        LOGGER.fine("Connected to " + this.host);
        for (MutableService service : this.getMutableServices()) {
            service.connected();
        }
    }

    private void internalDisconnected() {
        LOGGER.fine("Disconnected from " + this.host);
        for (MutableService service : this.getMutableServices()) {
            service.disconnected();
        }
    }

    private void stateChanged(ClientConnEvent clientConnEvent) {
        OscarConnStateEvent evt = clientConnEvent.getNewState() == ClientConn.STATE_NOT_CONNECTED ? new OscarConnDisconnectEvent(clientConnEvent, this.getLastCloseCode()) : new OscarConnStateEvent(clientConnEvent);
        for (OscarConnListener l : this.listeners) {
            l.connStateChanged(this, evt);
        }
    }

    private void registeredSnacFamilies() {
        for (OscarConnListener l : this.listeners) {
            l.registeredSnacFamilies(this);
        }
    }

    public synchronized ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public synchronized void setServiceFactory(ServiceFactory serviceFactory) {
        this.checkFieldModify();
        DefensiveTools.checkNull((Object)serviceFactory, (String)"serviceFactory");
        this.serviceFactory = serviceFactory;
    }

    protected synchronized void checkFieldModify() {
        if (this.triedConnect) {
            throw new IllegalStateException("Property cannot be modified after connect() has been called");
        }
    }

    public final ClientFlapConn getClientFlapConn() {
        return this.conn;
    }

    public synchronized void connect() throws IllegalStateException {
        if (this.triedConnect) {
            throw new IllegalStateException("cannot connect more than once");
        }
        if (this.serviceFactory == null) {
            throw new IllegalStateException("cannot connect without first setting a ServiceFactory");
        }
        this.beforeConnect();
        this.triedConnect = true;
        LOGGER.fine("OscarConnection to " + this.host + " trying to connect...");
        this.conn.connect();
    }

    public synchronized boolean isDisconnected() {
        return this.disconnected;
    }

    public synchronized boolean disconnect() {
        if (!this.triedConnect) {
            throw new IllegalStateException("was never connected");
        }
        if (this.disconnected) {
            return false;
        }
        this.disconnected = true;
        this.conn.disconnect();
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected FlapProcessor getFlapProcessor() {
        return this.flapProcessor;
    }

    public ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    public ClientConn.State getConnectionState() {
        return this.conn.getState();
    }

    public void sendFlap(FlapCommand flap) {
        this.flapProcessor.sendFlap(flap);
    }

    public void sendSnac(SnacCommand snac) {
        DefensiveTools.checkNull((Object)snac, (String)"snac");
        this.snacProcessor.sendSnac(new SnacRequest(snac, null));
    }

    public void sendSnacRequest(SnacCommand snac, SnacRequestListener listener) {
        DefensiveTools.checkNull((Object)snac, (String)"snac");
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        this.snacProcessor.sendSnac(new SnacRequest(snac, listener));
    }

    public void sendSnacRequest(SnacRequest snac) {
        DefensiveTools.checkNull((Object)snac, (String)"snac");
        this.snacProcessor.sendSnac(snac);
    }

    protected void beforeConnect() {
    }

    protected void connFailed() {
    }

    protected void beforeServicesConnected() {
    }

    protected void connected() {
        Socket socket = this.conn.getSocket();
        if (socket != null) {
            try {
                socket.setKeepAlive(true);
            }
            catch (SocketException e) {
                LOGGER.log(Level.WARNING, "Couldn't set SO_KEEPALIVE for connection " + this, e);
            }
        } else {
            LOGGER.warning("Couldn't set SO_KEEPALIVE for connection " + this + " because the ClientConn has no socket set");
        }
    }

    protected void disconnected() {
    }

    protected void handleFlapPacket(FlapPacketEvent flapPacketEvent) {
        FlapCommand flap = flapPacketEvent.getFlapCommand();
        if (flap instanceof CloseFlapCmd) {
            CloseFlapCmd cfc = (CloseFlapCmd)flap;
            this.setLastCloseCode(cfc.getCode());
        }
    }

    protected void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
        MutableService service = this.getService(snacPacketEvent);
        if (service != null) {
            service.handleSnacPacket(snacPacketEvent);
        }
    }

    private MutableService getService(SnacPacketEvent snacPacketEvent) {
        int family = snacPacketEvent.getSnacPacket().getFamily();
        return this.getMutableService(family);
    }

    protected void handleSnacResponse(SnacResponseEvent snacResponseEvent) {
        MutableService service = this.getService((SnacPacketEvent)snacResponseEvent);
        if (service != null) {
            service.handleSnacPacket((SnacPacketEvent)snacResponseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSnacFamilies(int ... snacFamilies) throws IllegalStateException {
        ArrayList<MutableService> services;
        OscarConnection oscarConnection = this;
        synchronized (oscarConnection) {
            if (this.snacFamilies != null) {
                LOGGER.fine("this connection " + MiscTools.getClassName((Object)this) + " already has SNAC " + "families set");
                return;
            }
            DefensiveTools.checkNull((Object)snacFamilies, (String)"snacFamilies");
            int[] families = (int[])snacFamilies.clone();
            Arrays.sort(families);
            this.snacFamilies = families;
            services = new ArrayList<MutableService>(snacFamilies.length);
            for (int family : families) {
                MutableService service = this.serviceFactory.getService(this, family);
                if (service == null) {
                    LOGGER.finer("No service for family 0x" + Integer.toHexString(family));
                    continue;
                }
                int family2 = service.getFamily();
                if (family2 != family) {
                    LOGGER.warning("Service returned by ServiceFactory for family 0x" + family + " is of wrong family (0x" + Integer.toHexString(family2) + ")");
                    continue;
                }
                this.serviceManager.setService(family, service);
                services.add(service);
            }
            this.unready.addAll(services);
            this.unfinished.addAll(services);
        }
        ClientConn.State state = this.conn.getState();
        boolean connected = state == ClientConn.STATE_CONNECTED;
        boolean disconnected = this.isDisconnected();
        for (MutableService service : services) {
            service.addServiceListener(new ServiceListener(){

                public void handleServiceReady(Service service) {
                    OscarConnection.this.serviceReady(service);
                }

                public void handleServiceFinished(Service service) {
                    OscarConnection.this.serviceFinished(service);
                }
            });
            if (connected) {
                service.connected();
                continue;
            }
            if (!disconnected) continue;
            service.disconnected();
        }
        this.registeredSnacFamilies();
    }

    public void addGlobalServiceListener(ServiceListener l) {
        this.globalServiceListeners.addIfAbsent((Object)l);
    }

    public void removeGlobalServiceListener(ServiceListener l) {
        this.globalServiceListeners.remove((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceReady(Service service) {
        boolean allReady;
        OscarConnection oscarConnection = this;
        synchronized (oscarConnection) {
            this.unready.remove(service);
            LOGGER.finer(service.getClass().getName() + " is ready, waiting for " + this.unready.size() + ": " + this.unready);
            allReady = this.unready.isEmpty();
        }
        for (ServiceListener sl : this.globalServiceListeners) {
            sl.handleServiceReady(service);
        }
        if (allReady) {
            LOGGER.finer("All services are ready");
            for (OscarConnListener l : this.listeners) {
                LOGGER.finer("Telling " + l.getClass().getName() + " that all services are ready");
                l.allFamiliesReady(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceFinished(Service service) {
        boolean allFinished;
        OscarConnection oscarConnection = this;
        synchronized (oscarConnection) {
            this.unfinished.remove(service);
            allFinished = this.unfinished.isEmpty();
        }
        for (ServiceListener sl : this.globalServiceListeners) {
            sl.handleServiceFinished(service);
        }
        if (allFinished) {
            this.disconnect();
        }
    }

    public final synchronized int[] getSnacFamilies() {
        return this.snacFamilies;
    }

    public Service getService(int family) {
        return this.serviceManager.getService(family);
    }

    private MutableService getMutableService(int family) {
        return this.serviceManager.getService(family);
    }

    public List<Service> getServices() {
        return new ArrayList<Service>(this.serviceManager.getServices());
    }

    private List<MutableService> getMutableServices() {
        return this.serviceManager.getServices();
    }

    public synchronized void setLastCloseCode(int lastCloseCode) {
        this.lastCloseCode = lastCloseCode;
    }

    public synchronized int getLastCloseCode() {
        return this.lastCloseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postServiceEvent(ServiceEvent event) {
        OscarConnection oscarConnection = this;
        synchronized (oscarConnection) {
            this.eventLog.add(event);
        }
        for (MutableService service : this.getMutableServices()) {
            service.handleEvent(event);
        }
    }

    public synchronized <E extends ServiceEvent> List<E> getServiceEvents(Class<E> cls) {
        ArrayList<Object> matches = new ArrayList<Object>();
        for (ServiceEvent event : this.eventLog) {
            if (!cls.isInstance(event)) continue;
            matches.add(JavaTools.cast(cls, (Object)event));
        }
        return matches;
    }

    public boolean hasServiceEvents(Class<? extends ServiceEvent> cls) {
        return !this.getServiceEvents(cls).isEmpty();
    }

    public synchronized List<ServiceEvent> getEventLog() {
        return DefensiveTools.getUnmodifiableCopy(this.eventLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            LOGGER.fine("OscarConnection ** finalize() **");
        }
        finally {
            super.finalize();
        }
    }
}

