/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import ymsg.network.AccountLockedException;
import ymsg.network.ChallengeResponseV10;
import ymsg.network.ChallengeResponseV9;
import ymsg.network.ConnectionHandler;
import ymsg.network.DirectConnectionHandler;
import ymsg.network.FileTransferFailedException;
import ymsg.network.HTTPConnection;
import ymsg.network.HTTPConnectionHandler;
import ymsg.network.IllegalIdentityException;
import ymsg.network.LoginRefusedException;
import ymsg.network.NetworkConstants;
import ymsg.network.NoSuchChatroomException;
import ymsg.network.NoSuchConferenceException;
import ymsg.network.PacketBodyBuffer;
import ymsg.network.SOCKSConnectionHandler;
import ymsg.network.ServiceConstants;
import ymsg.network.StatusConstants;
import ymsg.network.UserStore;
import ymsg.network.Util;
import ymsg.network.YMSG9BadFormatException;
import ymsg.network.YMSG9Packet;
import ymsg.network.YahooChatCategory;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatUser;
import ymsg.network.YahooConference;
import ymsg.network.YahooException;
import ymsg.network.YahooGroup;
import ymsg.network.YahooIdentity;
import ymsg.network.YahooUser;
import ymsg.network.event.SessionChatEvent;
import ymsg.network.event.SessionConferenceEvent;
import ymsg.network.event.SessionErrorEvent;
import ymsg.network.event.SessionEvent;
import ymsg.network.event.SessionExceptionEvent;
import ymsg.network.event.SessionFileTransferEvent;
import ymsg.network.event.SessionFriendEvent;
import ymsg.network.event.SessionListener;
import ymsg.network.event.SessionNewMailEvent;
import ymsg.network.event.SessionNotifyEvent;

public class Session
implements StatusConstants,
ServiceConstants,
NetworkConstants {
    private String primaryID;
    private String loginID;
    private String password;
    private String cookieY;
    private String cookieT;
    private String cookieC;
    private String imvironment;
    private long status;
    private String customStatusMessage;
    private boolean customStatusBusy;
    private YahooGroup[] groups;
    private YahooIdentity[] identities;
    private int conferenceCount;
    private UserStore userStore;
    private int sessionStatus;
    private long sessionId = 0L;
    private Vector listeners;
    private ConnectionHandler network;
    private ThreadGroup ymsgThreads;
    private InputThread ipThread;
    private PingThread pingThread;
    private Hashtable typingNotifiers;
    private boolean loginOver = false;
    private YahooException loginException = null;
    private YMSG9Packet cachePacket;
    private Hashtable conferences;
    private boolean chatConnectOver = false;
    private boolean chatLoginOver = false;
    private int chatSessionStatus;
    private YahooChatLobby currentLobby = null;
    private String chatID;

    public Session(ConnectionHandler ch) {
        this.network = ch;
        this._init();
    }

    public Session() {
        Properties p = System.getProperties();
        this.network = p.containsKey("socksProxyHost") ? new SOCKSConnectionHandler() : (p.containsKey("http.proxyHost") || p.containsKey("proxyHost") ? new HTTPConnectionHandler() : new DirectConnectionHandler());
        this._init();
    }

    private void _init() {
        this.status = 0L;
        this.sessionId = 0L;
        this.sessionStatus = 0;
        this.ymsgThreads = new ThreadGroup("YMSG Threads");
        this.groups = null;
        this.identities = null;
        this.listeners = new Vector();
        this.conferences = new Hashtable();
        this.typingNotifiers = new Hashtable();
        this.userStore = new UserStore();
        this.network.install(this, this.ymsgThreads);
    }

    public void addSessionListener(SessionListener ss) {
        if (this.listeners.indexOf(ss) < 0) {
            this.listeners.addElement(ss);
        }
    }

    public void removeSessionListener(SessionListener ss) {
        this.listeners.removeElement(ss);
    }

    public ConnectionHandler getConnectionHandler() {
        return this.network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void login(String u, String p) throws IllegalStateException, IOException, AccountLockedException, LoginRefusedException {
        if (this.sessionStatus != 0) {
            throw new IllegalStateException("Session should be unstarted");
        }
        u = u.toLowerCase();
        this.resetData();
        this.loginID = u;
        this.primaryID = null;
        this.password = p;
        this.sessionId = 0L;
        this.imvironment = "0";
        this.network.open();
        this.loginOver = false;
        this.startThreads();
        this.transmitAuth();
        long timeout = System.currentTimeMillis() + (long)Util.loginTimeout(60);
        while (!this.loginOver && !this.past(timeout)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        if (this.past(timeout)) {
            this.sessionStatus = 3;
            this.closeNetwork();
            throw new InterruptedIOException("Login timed out");
        }
        if (this.sessionStatus == 3 && this.loginException != null) {
            throw (LoginRefusedException)this.loginException;
        }
    }

    public synchronized void logout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.sessionStatus = 0;
        this.transmitLogoff();
    }

    public synchronized void reset() throws IllegalStateException {
        if (this.sessionStatus != 3 && this.sessionStatus != 0) {
            throw new IllegalStateException("Session currently active");
        }
        this.sessionStatus = 0;
        this.chatSessionStatus = 0;
        this.resetData();
    }

    public void sendMessage(String to, String msg) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitMessage(to, this.loginID, msg);
    }

    public void sendMessage(String to, String msg, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yid);
        this.transmitMessage(to, yid.getId(), msg);
    }

    public void sendBuzz(String to) throws IllegalStateException, IOException {
        this.sendMessage(to, "<ding>");
    }

    public void sendBuzz(String to, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.sendMessage(to, "<ding>", yid);
    }

    public int getSessionStatus() {
        return this.sessionStatus;
    }

    public long getStatus() {
        return this.status;
    }

    public synchronized void setStatus(long s) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == 0 && s != 0L && s != 12L) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (s == 99L) {
            throw new IllegalArgumentException("Cannot set custom state without message");
        }
        this.status = s;
        this.customStatusMessage = null;
        if (this.sessionStatus == 2) {
            this._doStatus();
        }
    }

    public synchronized void setStatus(String m, boolean b) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == 0) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (m == null) {
            throw new IllegalArgumentException("Cannot set custom state with null message");
        }
        this.status = 99L;
        this.customStatusMessage = m;
        this.customStatusBusy = b;
        this._doStatus();
    }

    private void _doStatus() throws IllegalStateException, IOException {
        if (this.status == 0L) {
            this.transmitIsBack();
        } else if (this.status == 99L) {
            this.transmitIsAway(this.customStatusMessage, this.customStatusBusy);
        } else {
            this.transmitIsAway();
        }
    }

    public String getCustomStatusMessage() {
        return this.customStatusMessage;
    }

    public boolean isCustomBusy() {
        return this.customStatusBusy;
    }

    public void refreshStats() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitUserStat();
    }

    public YahooIdentity[] getIdentities() {
        if (this.identities == null) {
            return null;
        }
        return (YahooIdentity[])this.identities.clone();
    }

    public YahooIdentity getPrimaryIdentity() {
        return this.identityIdToObject(this.primaryID);
    }

    public YahooIdentity getLoginIdentity() {
        return this.identityIdToObject(this.loginID);
    }

    public void activateIdentity(YahooIdentity yid, boolean activate) throws IllegalStateException, IllegalIdentityException, IOException {
        this.checkStatus();
        this.checkIdentity(yid);
        if (yid.getId().equals(this.primaryID)) {
            throw new IllegalIdentityException("Primary identity cannot be de/activated");
        }
        if (activate) {
            this.transmitIdActivate(yid.getId());
        } else {
            this.transmitIdDeactivate(yid.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypingNotification(String user, Component com) {
        String syid = this.primaryID;
        String key = "user\n" + syid;
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            if (this.typingNotifiers.containsKey(key)) {
                return;
            }
            this.typingNotifiers.put(key, new TypingNotifier(com, user, syid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypingNotification(String user) {
        String syid = this.primaryID;
        String key = "user\n" + syid;
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            TypingNotifier tn = (TypingNotifier)this.typingNotifiers.get(key);
            if (tn == null) {
                return;
            }
            tn.quit = true;
            tn.interrupt();
            this.typingNotifiers.remove(key);
        }
    }

    public void keyTyped(String user) {
        String syid = this.primaryID;
        String key = "user\n" + syid;
        TypingNotifier tn = (TypingNotifier)this.typingNotifiers.get(key);
        if (tn != null) {
            tn.keyTyped();
        }
    }

    public YahooGroup[] getGroups() {
        return (YahooGroup[])this.groups.clone();
    }

    public Hashtable getUsers() {
        return (Hashtable)this.userStore.getUsers().clone();
    }

    public YahooUser getUser(String id) {
        return this.userStore.get(id);
    }

    public String getImvironment() {
        return this.imvironment;
    }

    public String[] getCookies() {
        String[] arr = new String[]{this.cookieY, this.cookieT, this.cookieC};
        return arr;
    }

    public YahooConference createConference(String[] users, String msg) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkIdentityNotOnList(users);
        return this.createConference(users, msg, this.identityIdToObject(this.loginID));
    }

    public YahooConference createConference(String[] users, String msg, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yid);
        this.checkIdentityNotOnList(users);
        String r = this.getConferenceName(yid.getId());
        this.transmitConfInvite(users, yid.getId(), r, msg);
        try {
            return this.getConference(r);
        }
        catch (NoSuchConferenceException e) {
            return null;
        }
    }

    public void acceptConferenceInvite(YahooConference room) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogon(room.getName(), room.getIdentity().getId());
    }

    public void declineConferenceInvite(YahooConference room, String msg) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfDecline(room.getName(), room.getIdentity().getId(), msg);
    }

    public void extendConference(YahooConference room, String user, String msg) throws IllegalStateException, IOException, NoSuchConferenceException, IllegalIdentityException {
        this.checkStatus();
        String[] arr = new String[]{user};
        this.checkIdentityNotOnList(arr);
        this.transmitConfAddInvite(user, room.getName(), room.getIdentity().getId(), msg);
    }

    public void sendConferenceMessage(YahooConference room, String msg) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfMsg(room.getName(), room.getIdentity().getId(), msg);
    }

    public void leaveConference(YahooConference room) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogoff(room.getName(), room.getIdentity().getId());
    }

    public void addFriend(String friend, String group) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitFriendAdd(friend, group);
    }

    public void removeFriend(String friend, String group) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitFriendRemove(friend, group);
    }

    public void rejectContact(SessionEvent se, String msg) throws IllegalArgumentException, IllegalStateException, IOException {
        if (se.getFrom() == null || se.getTo() == null) {
            throw new IllegalArgumentException("Missing to or from field in event object.");
        }
        this.checkStatus();
        this.transmitContactReject(se.getFrom(), se.getTo(), msg);
    }

    public void ignoreContact(String friend, boolean ignore) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitContactIgnore(friend, ignore);
    }

    public void refreshFriends() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitList();
    }

    public void sendFileTransfer(String user, String filename, String msg) throws IllegalStateException, FileTransferFailedException, IOException {
        this.checkStatus();
        this.transmitFileTransfer(user, msg, filename);
    }

    public void saveFileTransferAs(SessionFileTransferEvent ev, String filename) throws FileTransferFailedException, IOException {
        this.saveFT(ev, null, filename);
    }

    public void saveFileTransferTo(SessionFileTransferEvent ev, String dir) throws FileTransferFailedException, IOException {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        this.saveFT(ev, dir, ev.getFilename());
    }

    private void saveFT(SessionFileTransferEvent ev, String path, String filename) throws FileTransferFailedException, IOException {
        int len;
        byte[] buff = new byte[4096];
        String contDisp = "Content-Disposition: filename=";
        HTTPConnection conn = new HTTPConnection("GET", ev.getLocation());
        conn.println("Host: " + ev.getLocation().getHost());
        conn.println("User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        conn.println("Cookie: " + this.cookieY + "; " + this.cookieT);
        conn.println("");
        conn.flush();
        String in = conn.readLine();
        if (in.indexOf(" 200 ") < 0) {
            throw new FileTransferFailedException("Server HTTP error code: " + in);
        }
        do {
            in = conn.readLine();
            if (path == null || in == null || !in.startsWith(contDisp) || (filename = in.substring(contDisp.length())).charAt(0) != '\"') continue;
            filename = filename.substring(1, filename.length() - 1);
        } while (in != null && in.trim().length() > 0);
        if (in == null) {
            throw new FileTransferFailedException("Server premature end of reply");
        }
        if (path != null) {
            filename = path + filename;
        }
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(filename));
        do {
            if ((len = conn.read(buff)) <= 0) continue;
            dos.write(buff, 0, len);
        } while (len >= 0);
        dos.flush();
        dos.close();
        conn.close();
    }

    public synchronized void chatLogin(YahooChatLobby ycl) throws IllegalStateException, IOException, LoginRefusedException {
        this.chatLogin(ycl, this.identityIdToObject(this.loginID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void chatLogin(YahooChatLobby ycl, YahooIdentity yid) throws IllegalStateException, IOException, LoginRefusedException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yid);
        if (this.chatSessionStatus != 0 && this.chatSessionStatus != 2) {
            throw new IllegalStateException("Chat session should be unstarted or messaging");
        }
        this.chatConnectOver = false;
        this.chatLoginOver = false;
        this.chatID = yid.getId();
        try {
            long timeout = System.currentTimeMillis() + (long)Util.loginTimeout(60);
            if (this.currentLobby == null) {
                this.transmitChatConnect(yid.getId());
                while (!this.chatConnectOver && !this.past(timeout)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.past(timeout)) {
                    throw new InterruptedIOException("Chat connect timed out");
                }
            }
            this.transmitChatLogon(ycl.getNetworkName(), ycl.getParent().getId());
            while (!this.chatLoginOver && !this.past(timeout)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            if (this.past(timeout)) {
                throw new InterruptedIOException("Chat login timed out");
            }
            if (this.chatSessionStatus == 3 && this.loginException != null) {
                throw (LoginRefusedException)this.loginException;
            }
            this.currentLobby = this.chatSessionStatus == 2 ? ycl : null;
        }
        finally {
            if (this.chatSessionStatus != 2) {
                this.chatSessionStatus = 3;
                this.chatID = null;
            }
        }
    }

    public synchronized void chatLogout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatDisconnect(this.currentLobby.getNetworkName());
        this.currentLobby = null;
    }

    public void sendChatMessage(String msg) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), msg, false);
    }

    public void sendChatEmote(String emote) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), emote, true);
    }

    public YahooChatLobby getCurrentChatLobby() {
        return this.currentLobby;
    }

    public int getChatSessionStatus() {
        return this.chatSessionStatus;
    }

    public void resetChat() throws IllegalStateException {
        if (this.chatSessionStatus != 3 && this.chatSessionStatus != 0) {
            throw new IllegalStateException("Chat session currently active");
        }
        this.chatSessionStatus = 0;
    }

    public void __test1(String a1, String a2) {
        try {
            this.network.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void __test2() {
    }

    protected void transmitAuth() throws IOException {
        this.sessionStatus = 1;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.loginID);
        body.addElement("1", this.loginID);
        this.sendPacket(body, 87);
    }

    protected void transmitAuthResp(String plp, String crp) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.loginID);
        body.addElement("6", plp);
        body.addElement("96", crp);
        body.addElement("2", "1");
        body.addElement("1", this.loginID);
        this.sendPacket(body, 84, this.status);
    }

    protected void transmitChatConnect(String yid) throws IOException {
        this.chatSessionStatus = 100;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("109", this.primaryID);
        body.addElement("1", yid);
        body.addElement("6", "abcde");
        this.sendPacket(body, 150);
    }

    protected void transmitChatDisconnect(String room) throws IOException {
        this.chatSessionStatus = 0;
        this.currentLobby = null;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("104", room);
        body.addElement("109", this.chatID);
        this.sendPacket(body, 160);
    }

    protected void transmitChatLogon(String netname, long id) throws IOException {
        this.chatSessionStatus = 1;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.chatID);
        body.addElement("104", netname);
        body.addElement("129", "" + id);
        body.addElement("62", "2");
        this.sendPacket(body, 152);
    }

    protected void transmitChatMsg(String netname, String msg, boolean emote) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.chatID);
        body.addElement("104", netname);
        body.addElement("117", msg);
        if (emote) {
            body.addElement("124", "2");
        } else {
            body.addElement("124", "1");
        }
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        this.sendPacket(body, 168);
    }

    protected void transmitChatPM(String to, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("5", to);
        body.addElement("14", msg);
        this.sendPacket(body, 32);
    }

    protected void transmitChatPing() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, 161);
    }

    protected void transmitConfAddInvite(String user, String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        int i;
        this.getConference(room);
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("51", user);
        body.addElement("57", room);
        Vector users = this.getConference(room).getUsers();
        for (i = 0; i < users.size(); ++i) {
            body.addElement("52", ((YahooUser)users.elementAt(i)).getId());
        }
        for (i = 0; i < users.size(); ++i) {
            body.addElement("53", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("58", msg);
        body.addElement("13", "0");
        this.sendPacket(body, 28);
    }

    protected void transmitConfDecline(String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        YahooConference yc = this.getConference(room);
        yc.closeConference();
        Vector users = yc.getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (int i = 0; i < users.size(); ++i) {
            body.addElement("3", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("57", room);
        body.addElement("14", msg);
        this.sendPacket(body, 26);
    }

    protected void transmitConfInvite(String[] users, String yid, String room, String msg) throws IOException {
        this.conferences.put(room, new YahooConference(this.userStore, this.identityIdToObject(yid), room, this, false));
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("50", this.primaryID);
        for (int i = 0; i < users.length; ++i) {
            body.addElement("52", users[i]);
        }
        body.addElement("57", room);
        body.addElement("58", msg);
        body.addElement("13", "0");
        this.sendPacket(body, 24);
    }

    protected void transmitConfLogoff(String room, String yid) throws IOException, NoSuchConferenceException {
        YahooConference yc = this.getConference(room);
        yc.closeConference();
        Vector users = yc.getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (int i = 0; i < users.size(); ++i) {
            body.addElement("3", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("57", room);
        this.sendPacket(body, 27);
    }

    protected void transmitConfLogon(String room, String yid) throws IOException, NoSuchConferenceException {
        Vector users = this.getConference(room).getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (int i = 0; i < users.size(); ++i) {
            body.addElement("3", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("57", room);
        this.sendPacket(body, 25);
    }

    protected void transmitConfMsg(String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        Vector users = this.getConference(room).getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (int i = 0; i < users.size(); ++i) {
            body.addElement("53", ((YahooUser)users.elementAt(i)).getId());
        }
        body.addElement("57", room);
        body.addElement("14", msg);
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        this.sendPacket(body, 29);
    }

    protected void transmitContactIgnore(String friend, boolean ignore) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        body.addElement("7", friend);
        if (ignore) {
            body.addElement("13", "1");
        } else {
            body.addElement("13", "2");
        }
        this.sendPacket(body, 133);
    }

    protected void transmitContactReject(String friend, String yid, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("7", friend);
        body.addElement("14", msg);
        this.sendPacket(body, 134);
    }

    protected void transmitFileTransfer(String to, String message, String filename) throws FileTransferFailedException, IOException {
        String in;
        String cookie = this.cookieY + "; " + this.cookieT;
        int fileSize = -1;
        byte[] marker = new byte[]{50, 57, -64, -128};
        DataInputStream dis = new DataInputStream(new FileInputStream(filename));
        fileSize = dis.available();
        if (fileSize <= 0) {
            throw new FileTransferFailedException("File transfer: missing or empty file");
        }
        byte[] fileData = new byte[fileSize];
        dis.readFully(fileData);
        dis.close();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.primaryID);
        body.addElement("5", to);
        body.addElement("28", fileSize + "");
        body.addElement("27", new File(filename).getName());
        body.addElement("14", message);
        byte[] packet = body.getBuffer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(NetworkConstants.MAGIC, 0, 4);
        dos.write(NetworkConstants.VERSION, 0, 4);
        dos.writeShort(packet.length + 4 & 0xFFFF);
        dos.writeShort(70);
        dos.writeInt((int)(this.status & 0xFFFFFFFFFFFFFFFFL));
        dos.writeInt((int)(this.sessionId & 0xFFFFFFFFFFFFFFFFL));
        dos.write(packet, 0, packet.length);
        dos.write(marker, 0, 4);
        packet = baos.toByteArray();
        String ftHost = Util.fileTransferHost();
        String ftURL = "http://" + ftHost + ":80/notifyft";
        HTTPConnection conn = new HTTPConnection("POST", new URL(ftURL));
        conn.println("Content-Length: " + (fileSize + packet.length));
        conn.println("User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        conn.println("Host: " + ftHost);
        conn.println("Cookie: " + cookie);
        conn.println("");
        conn.write(packet);
        conn.write(fileData);
        conn.flush();
        String head = in = conn.readLine();
        if (in != null) {
            byte[] buffer = new byte[4096];
            while (conn.read(buffer) > 0) {
            }
        }
        conn.close();
        if (head.indexOf(" 200 ") < 0) {
            throw new FileTransferFailedException("Server rejected upload");
        }
    }

    protected void transmitFriendAdd(String friend, String group) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        body.addElement("7", friend);
        body.addElement("65", group);
        this.sendPacket(body, 131);
    }

    protected void transmitFriendRemove(String friend, String group) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        body.addElement("7", friend);
        body.addElement("65", group);
        this.sendPacket(body, 132);
    }

    protected void transmitGroupRename(String oldName, String newName) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        body.addElement("65", oldName);
        body.addElement("67", newName);
        this.sendPacket(body, 19);
    }

    protected void transmitIdActivate(String id) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("3", id);
        this.sendPacket(body, 7);
    }

    protected void transmitIdDeactivate(String id) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("3", id);
        this.sendPacket(body, 8);
    }

    protected void transmitIdle() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID);
        body.addElement("0", this.primaryID);
        this.sendPacket(body, 5);
    }

    protected void transmitIsAway() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("10", this.status + "");
        this.sendPacket(body, 3, this.status);
    }

    protected void transmitIsAway(String msg, boolean a) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.status = 99L;
        body.addElement("10", this.status + "");
        body.addElement("19", msg);
        if (a) {
            body.addElement("47", "1");
        } else {
            body.addElement("47", "0");
        }
        this.sendPacket(body, 3, this.status);
    }

    protected void transmitIsBack() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("10", this.status + "");
        this.sendPacket(body, 4, this.status);
    }

    protected void transmitList() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID);
        this.sendPacket(body, 85);
    }

    protected void transmitLogoff() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.loginID);
        this.sendPacket(body, 2);
    }

    protected void transmitMessage(String to, String yid, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.primaryID);
        body.addElement("1", yid);
        body.addElement("5", to);
        body.addElement("14", msg);
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        body.addElement("63", ";" + this.imvironment);
        body.addElement("64", "0");
        this.sendPacket(body, 6, 0x5A55AA56L);
        TypingNotifier tn = (TypingNotifier)this.typingNotifiers.get(to);
        if (tn != null) {
            tn.stopTyping();
        }
    }

    protected void transmitNotify(String friend, String yid, boolean on, String msg, String mode) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("4", yid);
        body.addElement("5", friend);
        body.addElement("14", msg);
        if (on) {
            body.addElement("13", "1");
        } else {
            body.addElement("13", "0");
        }
        body.addElement("49", mode);
        this.sendPacket(body, 75, 22L);
    }

    protected void transmitPing() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, 18);
    }

    protected void transmitUserStat() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, 10);
    }

    protected void receiveAddIgnore(YMSG9Packet pkt) {
    }

    protected void receiveAuth(YMSG9Packet pkt) throws IOException, NoSuchAlgorithmException {
        String[] s;
        String v10 = pkt.getValue("13");
        try {
            s = v10 != null && v10.equals("1") ? ChallengeResponseV10.getStrings(this.loginID, this.password, pkt.getValue("94")) : ChallengeResponseV9.getStrings(this.loginID, this.password, pkt.getValue("94"));
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("auth", false, e);
        }
        this.transmitAuthResp(s[0], s[1]);
    }

    protected void receiveAuthResp(YMSG9Packet pkt) {
        block8: {
            try {
                if (!pkt.exists("66")) break block8;
                long l = Long.parseLong(pkt.getValue("66"));
                if (l == 14L) {
                    URL u;
                    try {
                        u = new URL(pkt.getValue("20"));
                    }
                    catch (Exception e) {
                        u = null;
                    }
                    this.loginException = new AccountLockedException("User " + this.loginID + " has been locked out", u);
                    break block8;
                }
                if (l == 13L) {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " refused login", l);
                } else if (l == 3L) {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " unknown", l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ipThread.quit = true;
        this.sessionStatus = 3;
        this.loginOver = true;
    }

    protected void receiveChatConnect(YMSG9Packet pkt) {
        this.chatConnectOver = true;
    }

    protected void receiveChatDisconnect(YMSG9Packet pkt) {
        if (this.chatSessionStatus != 0) {
            new FireEvent().fire(new SessionEvent(this), 160);
        }
        this.chatSessionStatus = 0;
    }

    protected void receiveChatLogoff(YMSG9Packet pkt) {
        try {
            String netname = pkt.getValue("104");
            String id = pkt.getValue("109");
            YahooChatLobby ycl = YahooChatCategory.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            YahooChatUser ycu = ycl.getUser(id);
            if (ycu != null) {
                ycl.removeUser(ycu);
            } else {
                ycu = this.createChatUser(pkt, 0);
            }
            SessionChatEvent se = new SessionChatEvent((Object)this, 1, ycl);
            se.setChatUser(0, ycu);
            new FireEvent().fire(se, 155);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat logoff", false, e);
        }
    }

    protected void receiveChatLogon(YMSG9Packet pkt) {
        boolean joining = false;
        try {
            int cnt;
            if (pkt.exists("114")) {
                this.loginException = new LoginRefusedException("User " + this.chatID + " refused chat login");
                joining = true;
                this.chatSessionStatus = 3;
                return;
            }
            if ((pkt = this.compoundChatLoginPacket(pkt)) == null) {
                return;
            }
            String netname = pkt.getValue("104");
            YahooChatLobby ycl = YahooChatCategory.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            for (cnt = Integer.parseInt(pkt.getValue("108")); cnt > 0 && pkt.getNthValue("109", cnt - 1) == null; --cnt) {
            }
            YahooChatUser ycu = ycl.getUser(pkt.getValue("109"));
            if (cnt == 1 && ycu != null) {
                ycu.update(pkt.getValue("113"), pkt.getValue("141"), pkt.getValue("110"), pkt.getValue("142"));
                SessionChatEvent se = new SessionChatEvent((Object)this, 1, ycl);
                se.setChatUser(0, ycu);
                new FireEvent().fire(se, 3844);
                return;
            }
            joining = pkt.exists("61");
            if (joining) {
                ycl.clearUsers();
            }
            Hashtable<String, YahooChatUser> ht = new Hashtable<String, YahooChatUser>();
            for (int i = 0; i < cnt; ++i) {
                ycu = this.createChatUser(pkt, i);
                ht.put(ycu.getId(), ycu);
            }
            SessionChatEvent se = new SessionChatEvent((Object)this, cnt, ycl);
            int i = 0;
            Enumeration en = ht.elements();
            while (en.hasMoreElements()) {
                ycu = (YahooChatUser)en.nextElement();
                if (!ycl.exists(ycu)) {
                    ycl.addUser(ycu);
                }
                se.setChatUser(i++, ycu);
            }
            if (!joining) {
                if (se.getChatUsers().length > 0) {
                    new FireEvent().fire(se, 152);
                }
            } else {
                this.chatSessionStatus = 2;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new YMSG9BadFormatException("chat login", false, e);
        }
        finally {
            if (joining) {
                this.chatLoginOver = true;
            }
        }
    }

    protected void receiveChatMsg(YMSG9Packet pkt) {
        if (this.chatSessionStatus != 2) {
            return;
        }
        try {
            String netname = pkt.getValue("104");
            YahooChatLobby ycl = YahooChatCategory.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            YahooChatUser ycu = ycl.getUser(pkt.getValue("109"));
            if (ycu == null) {
                ycu = this.createChatUser(pkt, 0);
            }
            SessionChatEvent se = new SessionChatEvent((Object)this, ycu, pkt.getValue("117"), pkt.getValue("124"), ycl);
            new FireEvent().fire(se, 168);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat message", false, e);
        }
    }

    protected void receiveChatPM(YMSG9Packet pkt) {
        if (this.chatSessionStatus != 2) {
            return;
        }
        try {
            SessionEvent se = new SessionEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"));
            new FireEvent().fire(se, 6);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat PM", false, e);
        }
    }

    protected void receiveConfAddInvite(YMSG9Packet pkt) {
        this.receiveConfInvite(pkt);
    }

    protected void receiveConfDecline(YMSG9Packet pkt) {
        try {
            YahooConference yc = this.getOrCreateConference(pkt);
            SessionConferenceEvent se = new SessionConferenceEvent(this, pkt.getValue("1"), pkt.getValue("54"), pkt.getValue("14"), yc, null);
            yc.removeUser(se.getFrom());
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 26);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference decline", false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfInvite(YMSG9Packet pkt) {
        try {
            YahooConference yc = this.getOrCreateConference(pkt);
            String[] users = pkt.getValues("52");
            SessionConferenceEvent se = new SessionConferenceEvent(this, pkt.getValue("1"), pkt.getValue("50"), pkt.getValue("58"), yc, this.userStore.toUserArray(users));
            yc.addUsers(users);
            yc.addUser(se.getFrom());
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 24);
            }
            YahooConference yahooConference = yc;
            synchronized (yahooConference) {
                Vector v = yc.inviteReceived();
                for (int i = 0; i < v.size(); ++i) {
                    this.ipThread.process((YMSG9Packet)v.elementAt(i));
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference invite", false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogoff(YMSG9Packet pkt) {
        YahooConference yc;
        YahooConference yahooConference = yc = this.getOrCreateConference(pkt);
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceEvent se = new SessionConferenceEvent((Object)this, pkt.getValue("1"), pkt.getValue("56"), null, yc);
            yc.removeUser(se.getFrom());
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 27);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference logoff", false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogon(YMSG9Packet pkt) {
        YahooConference yc;
        YahooConference yahooConference = yc = this.getOrCreateConference(pkt);
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceEvent se = new SessionConferenceEvent((Object)this, pkt.getValue("1"), pkt.getValue("53"), null, yc);
            yc.addUser(se.getFrom());
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 25);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference logon", false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfMsg(YMSG9Packet pkt) {
        YahooConference yc;
        YahooConference yahooConference = yc = this.getOrCreateConference(pkt);
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceEvent se = new SessionConferenceEvent((Object)this, pkt.getValue("1"), pkt.getValue("3"), pkt.getValue("14"), yc);
            if (!yc.isClosed()) {
                new FireEvent().fire(se, 29);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference mesg", false, e);
        }
    }

    protected void receiveContactIgnore(YMSG9Packet pkt) {
        try {
            String n = pkt.getValue("0");
            boolean ig = pkt.getValue("13").charAt(0) == '1';
            int st = Integer.parseInt(pkt.getValue("66"));
            if (st == 0) {
                YahooUser yu = this.userStore.getOrCreate(n);
                yu.setIgnored(ig);
                SessionFriendEvent se = new SessionFriendEvent(this, 1);
                se.setUser(0, yu);
                new FireEvent().fire(se, 3);
            } else {
                String m = "Contact ignore error: ";
                switch (st) {
                    case 2: {
                        m = m + "Already on ignore list";
                        break;
                    }
                    case 3: {
                        m = m + "Not currently ignored";
                        break;
                    }
                    case 12: {
                        m = m + "Cannot ignore friend";
                        break;
                    }
                    default: {
                        m = m + "Unknown error";
                    }
                }
                this.errorMessage(pkt, m);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("contact ignore", false, e);
        }
    }

    protected void receiveContactNew(YMSG9Packet pkt) {
        try {
            if (pkt.length <= 0) {
                return;
            }
            if (pkt.exists("7")) {
                this.updateFriendsStatus(pkt);
                return;
            }
            if (pkt.status == 7L) {
                SessionEvent se = new SessionEvent(this, null, pkt.getValue("3"), pkt.getValue("14"));
                new FireEvent().fire(se, 134);
            } else {
                SessionEvent se = new SessionEvent(this, pkt.getValue("1"), pkt.getValue("3"), pkt.getValue("14"), pkt.getValue("15"));
                se.setStatus(pkt.status);
                new FireEvent().fire(se, 15);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("contact request", false, e);
        }
    }

    protected void receiveFileTransfer(YMSG9Packet pkt) {
        try {
            if (!pkt.exists("38")) {
                SessionEvent se = new SessionEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"));
                new FireEvent().fire(se, 6);
            } else {
                SessionFileTransferEvent se = new SessionFileTransferEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"), pkt.getValue("38"), pkt.getValue("20"));
                new FireEvent().fire(se, 70);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("file transfer", false, e);
        }
    }

    protected void receiveFriendAdd(YMSG9Packet pkt) {
        try {
            String n = pkt.getValue("7");
            String s = pkt.getValue("66");
            String g = pkt.getValue("65");
            YahooUser yu = this.userStore.getOrCreate(n);
            this.insertFriend(yu, g);
            SessionFriendEvent se = new SessionFriendEvent((Object)this, yu, g);
            new FireEvent().fire(se, 131);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("friend added", false, e);
        }
    }

    protected void receiveFriendRemove(YMSG9Packet pkt) {
        try {
            String n = pkt.getValue("7");
            String g = pkt.getValue("65");
            YahooUser yu = this.userStore.get(n);
            if (yu == null) {
                this.report("Unknown friend", pkt);
                return;
            }
            this.deleteFriend(yu, g);
            SessionFriendEvent se = new SessionFriendEvent((Object)this, yu, g);
            new FireEvent().fire(se, 132);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("friend removed", false, e);
        }
    }

    protected void receiveIdAct(YMSG9Packet pkt) {
    }

    protected void receiveIdDeact(YMSG9Packet pkt) {
    }

    protected void receiveIsAway(YMSG9Packet pkt) {
        if (pkt.exists("7")) {
            this.updateFriendsStatus(pkt);
        }
    }

    protected void receiveIsBack(YMSG9Packet pkt) {
        if (pkt.exists("7")) {
            this.updateFriendsStatus(pkt);
        }
    }

    protected void receiveList(YMSG9Packet pkt) {
        String[] concatFields = new String[]{"87", "88", "89"};
        if (this.cachePacket == null) {
            this.cachePacket = pkt;
        } else {
            this.cachePacket.merge(pkt, concatFields);
        }
        if (pkt.exists("59")) {
            this._receiveList(this.cachePacket);
        }
    }

    private void _receiveList(YMSG9Packet pkt) {
        StringTokenizer st;
        String s;
        try {
            s = pkt.getValue("87");
            if (s != null) {
                StringTokenizer st1 = new StringTokenizer(s, "\n");
                this.groups = new YahooGroup[st1.countTokens()];
                int i = 0;
                while (st1.hasMoreTokens()) {
                    String s1 = st1.nextToken();
                    this.groups[i] = new YahooGroup(s1.substring(0, s1.indexOf(":")));
                    StringTokenizer st2 = new StringTokenizer(s1.substring(s1.indexOf(":") + 1), ",");
                    while (st2.hasMoreTokens()) {
                        String k = st2.nextToken();
                        YahooUser yu = this.userStore.getOrCreate(k);
                        this.groups[i].addUser(yu);
                        yu.adjustGroupCount(1);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("friends list in list", false, e);
        }
        try {
            s = pkt.getValue("88");
            if (s != null) {
                st = new StringTokenizer(s, ",");
                while (st.hasMoreTokens()) {
                    s = st.nextToken();
                    YahooUser yu = this.userStore.getOrCreate(s);
                    yu.setIgnored(true);
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("ignored list in list", false, e);
        }
        try {
            s = pkt.getValue("89");
            if (s != null) {
                st = new StringTokenizer(s, ",");
                int i = 0;
                this.identities = new YahooIdentity[st.countTokens()];
                while (st.hasMoreTokens()) {
                    this.identities[i++] = new YahooIdentity(st.nextToken());
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("identities list in list", false, e);
        }
        try {
            String[] ck = ConnectionHandler.extractCookies(pkt);
            this.cookieY = ck[0];
            this.cookieT = ck[1];
            this.cookieC = ck[2];
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("cookies in list", false, e);
        }
        try {
            this.primaryID = pkt.exists("3") ? pkt.getValue("3").trim() : this.loginID;
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("primary identity in list", false, e);
        }
        this.identityIdToObject(this.primaryID).setPrimaryIdentity(true);
        this.identityIdToObject(this.loginID).setLoginIdentity(true);
        if (this.loginOver) {
            new FireEvent().fire(new SessionEvent(this), 85);
        }
    }

    protected void receiveLogoff(YMSG9Packet pkt) {
        if (!pkt.exists("7")) {
            this.sessionStatus = 0;
            this.ipThread.quit = true;
        } else {
            try {
                this.updateFriendsStatus(pkt);
            }
            catch (Exception e) {
                throw new YMSG9BadFormatException("online friends in logoff", false, e);
            }
        }
    }

    protected void receiveLogon(YMSG9Packet pkt) {
        if (pkt.exists("7")) {
            try {
                this.updateFriendsStatus(pkt);
            }
            catch (Exception e) {
                throw new YMSG9BadFormatException("online friends in logon", false, e);
            }
        }
        if (!this.loginOver) {
            try {
                if (this.status == 0L) {
                    this.transmitIsBack();
                } else {
                    this.transmitIsAway();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sessionStatus = 2;
            this.loginOver = true;
        }
    }

    protected void receiveMessage(YMSG9Packet pkt) {
        try {
            if (!pkt.exists("14")) {
                return;
            }
            if (pkt.status == 5L) {
                int i = 0;
                String s = pkt.getNthValue("31", i);
                while (s != null) {
                    SessionEvent se = new SessionEvent(this, pkt.getNthValue("5", i), pkt.getNthValue("4", i), pkt.getNthValue("14", i), pkt.getNthValue("15", i));
                    new FireEvent().fire(se, 3841);
                    s = pkt.getNthValue("31", ++i);
                }
            } else {
                SessionEvent se = new SessionEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"));
                if (se.getMessage().equalsIgnoreCase("<ding>")) {
                    new FireEvent().fire(se, 3843);
                } else {
                    new FireEvent().fire(se, 6);
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("message", false, e);
        }
    }

    protected void receiveNewMail(YMSG9Packet pkt) {
        try {
            SessionNewMailEvent se = !pkt.exists("43") ? new SessionNewMailEvent(this, pkt.getValue("9")) : new SessionNewMailEvent(this, pkt.getValue("43"), pkt.getValue("42"), pkt.getValue("18"));
            new FireEvent().fire(se, 11);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("new mail", false, e);
        }
    }

    protected void receiveNotify(YMSG9Packet pkt) {
        try {
            if (pkt.status == 1L) {
                SessionNotifyEvent se = new SessionNotifyEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"), pkt.getValue("49"), pkt.getValue("13"));
                se.setStatus(pkt.status);
                new FireEvent().fire(se, 75);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("notify", false, e);
        }
    }

    protected void receivePing(YMSG9Packet pkt) {
    }

    protected void receiveUserStat(YMSG9Packet pkt) {
        this.status = pkt.status;
    }

    protected void erroneousChatLogin(YMSG9Packet pkt) {
        this.chatSessionStatus = 3;
        this.chatLoginOver = true;
    }

    protected void sendPacket(PacketBodyBuffer body, int service, long status) throws IOException {
        this.network.sendPacket(body, service, status, this.sessionId);
    }

    protected void sendPacket(PacketBodyBuffer body, int service) throws IOException {
        this.sendPacket(body, service, 0L);
    }

    private void report(String s, YMSG9Packet p) {
        System.err.println(s + "\n" + p.toString() + "\n");
    }

    private boolean past(long time) {
        return System.currentTimeMillis() > time;
    }

    private void startThreads() {
        this.ipThread = new InputThread();
        this.pingThread = new PingThread();
    }

    private void closeNetwork() {
        if (this.pingThread != null) {
            this.pingThread.quit = true;
            this.pingThread.interrupt();
        }
        if (this.network != null) {
            try {
                this.network.close();
                this.network = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkStatus() throws IllegalStateException {
        if (this.sessionStatus != 2) {
            throw new IllegalStateException("Not logged in");
        }
    }

    private void checkChatStatus() throws IllegalStateException {
        if (this.chatSessionStatus != 2) {
            throw new IllegalStateException("Not logged in to a chatroom");
        }
    }

    private YahooIdentity identityIdToObject(String yid) {
        for (int i = 0; i < this.identities.length; ++i) {
            if (!yid.equals(this.identities[i].getId())) continue;
            return this.identities[i];
        }
        return null;
    }

    private void checkIdentity(YahooIdentity yid) throws IllegalIdentityException {
        for (int i = 0; i < this.identities.length; ++i) {
            if (yid != this.identities[i]) continue;
            return;
        }
        throw new IllegalIdentityException(yid + " not a valid identity for this session");
    }

    private void checkIdentityNotOnList(String[] yids) {
        for (int i = 0; i < yids.length; ++i) {
            if (this.identityIdToObject(yids[i]) == null) continue;
            throw new IllegalIdentityException(yids[i] + " is an identity of this session and cannot be used here");
        }
    }

    private void resetData() {
        this.primaryID = null;
        this.loginID = null;
        this.password = null;
        this.cookieY = null;
        this.cookieT = null;
        this.cookieC = null;
        this.imvironment = null;
        this.customStatusMessage = null;
        this.customStatusBusy = false;
        this.groups = null;
        this.identities = null;
        this.clearTypingNotifiers();
        this.loginOver = false;
        this.loginException = null;
        this.chatConnectOver = false;
        this.chatLoginOver = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTypingNotifiers() {
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            Enumeration e = this.typingNotifiers.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                TypingNotifier tn = (TypingNotifier)this.typingNotifiers.get(key);
                tn.quit = true;
                tn.interrupt();
                this.typingNotifiers.remove(key);
            }
        }
    }

    private void errorMessage(YMSG9Packet pkt, String m) {
        if (m == null) {
            m = pkt.getValue("16");
        }
        SessionErrorEvent se = new SessionErrorEvent((Object)this, m, pkt.service);
        if (pkt.exists("114")) {
            se.setCode(Integer.parseInt(pkt.getValue("114").trim()));
        }
        new FireEvent().fire(se, 3840);
    }

    private YMSG9Packet compoundChatLoginPacket(YMSG9Packet pkt) {
        if (pkt.status == 5L) {
            if (this.cachePacket == null) {
                this.cachePacket = pkt;
            } else {
                this.cachePacket.append(pkt);
            }
            return null;
        }
        if (pkt.status == 1L) {
            if (this.cachePacket != null) {
                this.cachePacket.append(pkt);
                pkt = this.cachePacket;
                this.cachePacket = null;
            }
            return pkt;
        }
        return pkt;
    }

    private void updateFriendsStatus(YMSG9Packet pkt) {
        boolean logoff;
        String s = pkt.getValue("8");
        if (s == null && pkt.getValue("7") != null) {
            s = "1";
        }
        boolean bl = logoff = pkt.service == 2;
        if (s != null) {
            int cnt = Integer.parseInt(s);
            SessionFriendEvent se = new SessionFriendEvent(this, cnt);
            for (int i = 0; i < cnt; ++i) {
                YahooUser yu = this.userStore.get(pkt.getNthValue("7", i));
                if (yu == null) {
                    String n = pkt.getNthValue("7", i);
                    yu = this.userStore.getOrCreate(n);
                }
                if (pkt.exists("17")) {
                    yu.update(pkt.getNthValue("7", i), logoff ? "1515563606" : pkt.getNthValue("10", i), pkt.getNthValue("17", i), pkt.getNthValue("13", i));
                } else {
                    yu.update(pkt.getNthValue("7", i), logoff ? "1515563606" : pkt.getNthValue("10", i), pkt.getNthValue("13", i));
                }
                if (pkt.getNthValue("19", i) != null && pkt.getNthValue("47", i) != null) {
                    yu.setCustom(pkt.getNthValue("19", i), pkt.getNthValue("47", i));
                }
                se.setUser(i, yu);
            }
            new FireEvent().fire(se, 3);
        }
    }

    private void insertFriend(YahooUser yu, String gr) {
        int idx;
        for (idx = 0; idx < this.groups.length && !this.groups[idx].getName().equalsIgnoreCase(gr); ++idx) {
        }
        if (idx >= this.groups.length) {
            int j;
            YahooGroup[] arr = new YahooGroup[this.groups.length + 1];
            boolean k = false;
            for (j = 0; j < this.groups.length && this.groups[j].getName().compareTo(gr) < 0; ++j) {
                arr[j] = this.groups[j];
            }
            idx = j;
            arr[idx] = new YahooGroup(gr);
            while (j < this.groups.length) {
                arr[j + 1] = this.groups[j];
                ++j;
            }
            this.groups = arr;
        }
        if (this.groups[idx].getIndexOfFriend(yu.getId()) < 0) {
            this.groups[idx].addUser(yu);
            yu.adjustGroupCount(1);
        }
    }

    private void deleteFriend(YahooUser yu, String gr) {
        int idx;
        for (idx = 0; idx < this.groups.length && !this.groups[idx].getName().equalsIgnoreCase(gr); ++idx) {
        }
        if (idx >= this.groups.length) {
            return;
        }
        int j = this.groups[idx].getIndexOfFriend(yu.getId());
        if (j < 0) {
            return;
        }
        this.groups[idx].removeUserAt(j);
        yu.adjustGroupCount(-1);
        if (this.groups[idx].isEmpty()) {
            YahooGroup[] arr = new YahooGroup[this.groups.length - 1];
            for (j = 0; j < idx; ++j) {
                arr[j] = this.groups[j];
            }
            for (j = idx; j < arr.length; ++j) {
                arr[j] = this.groups[j + 1];
            }
            this.groups = arr;
        }
    }

    private YahooChatUser createChatUser(YMSG9Packet pkt, int i) {
        YahooUser yu = this.userStore.getOrCreate(pkt.getNthValue("109", i));
        return new YahooChatUser(yu, pkt.getValueFromNthSet("109", "113", i), pkt.getValueFromNthSet("109", "141", i), pkt.getValueFromNthSet("109", "110", i), pkt.getValueFromNthSet("109", "142", i));
    }

    private String getConferenceName(String yid) {
        return yid + "-" + this.conferenceCount++;
    }

    private YahooConference getConference(String room) throws NoSuchConferenceException {
        YahooConference yc = (YahooConference)this.conferences.get(room);
        if (yc == null) {
            throw new NoSuchConferenceException("Conference " + room + " not found.");
        }
        return yc;
    }

    private YahooConference getOrCreateConference(YMSG9Packet pkt) {
        String room = pkt.getValue("57");
        YahooIdentity yid = this.identityIdToObject(pkt.getValue("1"));
        YahooConference yc = (YahooConference)this.conferences.get(room);
        if (yc == null) {
            yc = new YahooConference(this.userStore, yid, room, this);
            this.conferences.put(room, yc);
        }
        return yc;
    }

    public static void dump(Session s) {
        YahooUser yu;
        YahooGroup[] yg = s.getGroups();
        for (int i = 0; i < yg.length; ++i) {
            System.out.print(yg[i].getName() + ": ");
            Vector v = yg[i].getMembers();
            for (int j = 0; j < v.size(); ++j) {
                yu = (YahooUser)v.elementAt(j);
                System.out.print(yu.getId() + " ");
            }
            System.out.print("\n");
        }
        Hashtable h = s.userStore.getUsers();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            yu = (YahooUser)h.get(k);
            System.out.println(k + " = " + yu.getId());
        }
        YahooIdentity[] ya = s.getIdentities();
        for (int i = 0; i < ya.length; ++i) {
            System.out.print(ya[i].getId() + " ");
        }
        System.out.print("\n");
    }

    private class FireEvent
    extends Thread {
        int type;
        SessionEvent ev;

        FireEvent() {
            super(Session.this.ymsgThreads, "Event Fired");
        }

        void fire(SessionEvent ev, int t) {
            this.ev = ev;
            this.type = t;
            this.start();
        }

        public void start() {
            if (Session.this.listeners.size() > 0) {
                super.start();
            }
        }

        public void run() {
            block27: for (int i = 0; i < Session.this.listeners.size(); ++i) {
                SessionListener l = (SessionListener)Session.this.listeners.elementAt(i);
                switch (this.type) {
                    case 2: {
                        l.connectionClosed(this.ev);
                        continue block27;
                    }
                    case 3: {
                        l.friendsUpdateReceived((SessionFriendEvent)this.ev);
                        continue block27;
                    }
                    case 6: {
                        l.messageReceived(this.ev);
                        continue block27;
                    }
                    case 3841: {
                        l.offlineMessageReceived(this.ev);
                        continue block27;
                    }
                    case 11: {
                        l.newMailReceived((SessionNewMailEvent)this.ev);
                        continue block27;
                    }
                    case 15: {
                        l.contactRequestReceived(this.ev);
                        continue block27;
                    }
                    case 26: {
                        l.conferenceInviteDeclinedReceived((SessionConferenceEvent)this.ev);
                        continue block27;
                    }
                    case 24: {
                        l.conferenceInviteReceived((SessionConferenceEvent)this.ev);
                        continue block27;
                    }
                    case 25: {
                        l.conferenceLogonReceived((SessionConferenceEvent)this.ev);
                        continue block27;
                    }
                    case 27: {
                        l.conferenceLogoffReceived((SessionConferenceEvent)this.ev);
                        continue block27;
                    }
                    case 29: {
                        l.conferenceMessageReceived((SessionConferenceEvent)this.ev);
                        continue block27;
                    }
                    case 70: {
                        l.fileTransferReceived((SessionFileTransferEvent)this.ev);
                        continue block27;
                    }
                    case 75: {
                        l.notifyReceived((SessionNotifyEvent)this.ev);
                        continue block27;
                    }
                    case 85: {
                        l.listReceived(this.ev);
                        continue block27;
                    }
                    case 131: {
                        l.friendAddedReceived((SessionFriendEvent)this.ev);
                        continue block27;
                    }
                    case 132: {
                        l.friendRemovedReceived((SessionFriendEvent)this.ev);
                        continue block27;
                    }
                    case 134: {
                        l.contactRejectionReceived(this.ev);
                        continue block27;
                    }
                    case 152: {
                        l.chatLogonReceived((SessionChatEvent)this.ev);
                        continue block27;
                    }
                    case 155: {
                        l.chatLogoffReceived((SessionChatEvent)this.ev);
                        continue block27;
                    }
                    case 160: {
                        l.chatConnectionClosed(this.ev);
                        continue block27;
                    }
                    case 168: {
                        l.chatMessageReceived((SessionChatEvent)this.ev);
                        continue block27;
                    }
                    case 3844: {
                        l.chatUserUpdateReceived((SessionChatEvent)this.ev);
                        continue block27;
                    }
                    case 3840: {
                        l.errorPacketReceived((SessionErrorEvent)this.ev);
                        continue block27;
                    }
                    case 3842: {
                        l.inputExceptionThrown((SessionExceptionEvent)this.ev);
                        continue block27;
                    }
                    case 3843: {
                        l.buzzReceived(this.ev);
                        continue block27;
                    }
                    default: {
                        System.out.println("UNKNOWN event: " + this.type);
                    }
                }
            }
        }
    }

    private class TypingNotifier
    extends KeyAdapter
    implements Runnable {
        public boolean quit = false;
        private long lastKey;
        private int timeout = 30000;
        private boolean typing = false;
        private Thread thread;
        private Component typeSource;
        private int listenerCnt = 0;
        private String target;
        private String identity;

        public TypingNotifier(Component com, String to, String from) {
            this.typeSource = com;
            this.target = to;
            this.identity = from;
            if (this.typeSource != null) {
                this.typeSource.addKeyListener(this);
            }
            this.thread = new Thread(Session.this.ymsgThreads, this, "Typing Notification: " + from + "->" + to);
            this.thread.setPriority(1);
            this.thread.start();
        }

        public void keyTyped(KeyEvent ev) {
            this.keyTyped();
        }

        void keyTyped() {
            if (!this.thread.isAlive() || Session.this.sessionStatus != 2) {
                return;
            }
            this.lastKey = System.currentTimeMillis();
            if (!this.typing) {
                try {
                    Session.this.transmitNotify(this.target, this.identity, true, " ", "TYPING");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.typing = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.quit) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (Session.this.sessionStatus != 2 || !this.typing || System.currentTimeMillis() - this.lastKey <= (long)this.timeout) continue;
                    try {
                        Session.this.transmitNotify(this.target, this.identity, false, " ", "TYPING");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.typing = false;
                }
            }
            finally {
                if (this.typeSource != null) {
                    this.typeSource.removeKeyListener(this);
                }
            }
        }

        public void interrupt() {
            this.thread.interrupt();
        }

        public void stopTyping() {
            if (this.typing) {
                try {
                    Session.this.transmitNotify(this.target, this.identity, false, " ", "TYPING");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.typing = false;
            }
        }
    }

    private class PingThread
    extends Thread {
        public boolean quit = false;
        public int time = 1200000;

        public PingThread() {
            super(Session.this.ymsgThreads, "Ping");
            this.setPriority(1);
            this.start();
        }

        public void run() {
            try {
                Thread.sleep(this.time);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (!this.quit) {
                try {
                    Session.this.transmitPing();
                    if (Session.this.currentLobby != null) {
                        Session.this.transmitChatPing();
                    }
                    try {
                        Thread.sleep(this.time);
                    }
                    catch (InterruptedException e) {
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private class InputThread
    extends Thread {
        public boolean quit = false;

        public InputThread() {
            super(Session.this.ymsgThreads, "Network Input");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!this.quit) {
                    try {
                        this.process(Session.this.network.receivePacket());
                    }
                    catch (Exception e) {
                        try {
                            SessionExceptionEvent se = new SessionExceptionEvent((Object)Session.this, "Source: InputThread", e);
                            new FireEvent().fire(se, 3842);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                return;
            }
            finally {
                Session.this.closeNetwork();
                new FireEvent().fire(new SessionEvent(this), 2);
            }
        }

        void process(YMSG9Packet pkt) throws Exception {
            if (pkt == null) {
                this.quit = true;
                return;
            }
            if (pkt.sessionId != 0L) {
                Session.this.sessionId = pkt.sessionId;
            }
            if (pkt.status == -1L && this.processError(pkt)) {
                return;
            }
            switch (pkt.service) {
                case 17: {
                    Session.this.receiveAddIgnore(pkt);
                    break;
                }
                case 87: {
                    Session.this.receiveAuth(pkt);
                    break;
                }
                case 84: {
                    Session.this.receiveAuthResp(pkt);
                    break;
                }
                case 150: {
                    Session.this.receiveChatConnect(pkt);
                    break;
                }
                case 160: {
                    Session.this.receiveChatDisconnect(pkt);
                    break;
                }
                case 155: {
                    Session.this.receiveChatLogoff(pkt);
                    break;
                }
                case 152: {
                    Session.this.receiveChatLogon(pkt);
                    break;
                }
                case 168: {
                    Session.this.receiveChatMsg(pkt);
                    break;
                }
                case 32: {
                    Session.this.receiveChatPM(pkt);
                    break;
                }
                case 28: {
                    Session.this.receiveConfAddInvite(pkt);
                    break;
                }
                case 26: {
                    Session.this.receiveConfDecline(pkt);
                    break;
                }
                case 24: {
                    Session.this.receiveConfInvite(pkt);
                    break;
                }
                case 27: {
                    Session.this.receiveConfLogoff(pkt);
                    break;
                }
                case 25: {
                    Session.this.receiveConfLogon(pkt);
                    break;
                }
                case 29: {
                    Session.this.receiveConfMsg(pkt);
                    break;
                }
                case 133: {
                    Session.this.receiveContactIgnore(pkt);
                    break;
                }
                case 15: {
                    Session.this.receiveContactNew(pkt);
                    break;
                }
                case 70: {
                    Session.this.receiveFileTransfer(pkt);
                    break;
                }
                case 131: {
                    Session.this.receiveFriendAdd(pkt);
                    break;
                }
                case 132: {
                    Session.this.receiveFriendRemove(pkt);
                    break;
                }
                case 7: {
                    Session.this.receiveIdAct(pkt);
                    break;
                }
                case 8: {
                    Session.this.receiveIdDeact(pkt);
                    break;
                }
                case 3: {
                    Session.this.receiveIsAway(pkt);
                    break;
                }
                case 4: {
                    Session.this.receiveIsBack(pkt);
                    break;
                }
                case 85: {
                    Session.this.receiveList(pkt);
                    break;
                }
                case 2: {
                    Session.this.receiveLogoff(pkt);
                    break;
                }
                case 1: {
                    Session.this.receiveLogon(pkt);
                    break;
                }
                case 6: {
                    Session.this.receiveMessage(pkt);
                    break;
                }
                case 11: {
                    Session.this.receiveNewMail(pkt);
                    break;
                }
                case 75: {
                    Session.this.receiveNotify(pkt);
                    break;
                }
                case 18: {
                    Session.this.receivePing(pkt);
                    break;
                }
                case 10: {
                    Session.this.receiveUserStat(pkt);
                    break;
                }
                default: {
                    System.out.println("UNKNOWN: " + pkt.toString());
                }
            }
        }

        boolean processError(YMSG9Packet pkt) throws Exception {
            switch (pkt.service) {
                case 84: {
                    Session.this.receiveAuthResp(pkt);
                    return true;
                }
                case 152: {
                    Session.this.receiveChatLogon(pkt);
                    return true;
                }
                case 2: {
                    Session.this.receiveLogoff(pkt);
                    return true;
                }
            }
            Session.this.errorMessage(pkt, null);
            return pkt.body.length <= 2;
        }
    }
}

