/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;

public class IOState {
    private static final Logger LOG = Log.getLogger(IOState.class);
    private ConnectionState state;
    private final List<ConnectionStateListener> listeners = new CopyOnWriteArrayList<ConnectionStateListener>();
    private boolean inputAvailable = false;
    private boolean outputAvailable = false;
    private CloseHandshakeSource closeHandshakeSource;
    private CloseInfo closeInfo = null;
    private boolean cleanClose = false;

    public IOState() {
        this.state = ConnectionState.CONNECTING;
        this.closeHandshakeSource = CloseHandshakeSource.NONE;
    }

    public void addListener(ConnectionStateListener listener) {
        this.listeners.add(listener);
    }

    public void assertInputOpen() throws IOException {
        if (!this.isInputAvailable()) {
            throw new IOException("Connection input is closed");
        }
    }

    public void assertOutputOpen() throws IOException {
        if (!this.isOutputAvailable()) {
            throw new IOException("Connection output is closed");
        }
    }

    public CloseInfo getCloseInfo() {
        return this.closeInfo;
    }

    public ConnectionState getConnectionState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            return this.state == ConnectionState.CLOSED;
        }
    }

    public boolean isInputAvailable() {
        return this.inputAvailable;
    }

    public boolean isOpen() {
        return this.getConnectionState() != ConnectionState.CLOSED;
    }

    public boolean isOutputAvailable() {
        return this.outputAvailable;
    }

    private void notifyStateListeners(ConnectionState state) {
        for (ConnectionStateListener listener : this.listeners) {
            listener.onConnectionStateChange(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAbnormalClose(CloseInfo close) {
        LOG.debug("onAbnormalClose({})", new Object[]{close});
        ConnectionState event = null;
        IOState iOState = this;
        synchronized (iOState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            if (this.state == ConnectionState.OPEN) {
                this.cleanClose = false;
            }
            this.state = ConnectionState.CLOSED;
            if (this.closeInfo == null) {
                this.closeInfo = close;
            }
            this.inputAvailable = false;
            this.outputAvailable = false;
            this.closeHandshakeSource = CloseHandshakeSource.ABNORMAL;
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCloseLocal(CloseInfo close) {
        ConnectionState event = null;
        ConnectionState initialState = this.state;
        LOG.debug("onCloseLocal({}) : {}", new Object[]{close, initialState});
        if (initialState == ConnectionState.CLOSED) {
            LOG.debug("already closed", new Object[0]);
            return;
        }
        if (initialState == ConnectionState.CONNECTED) {
            LOG.debug("FastClose in CONNECTED detected", new Object[0]);
            this.onOpened();
        }
        IOState iOState = this;
        synchronized (iOState) {
            if (this.closeInfo == null) {
                this.closeInfo = close;
            }
            boolean in = this.inputAvailable;
            boolean out = this.outputAvailable;
            if (this.closeHandshakeSource == CloseHandshakeSource.NONE) {
                this.closeHandshakeSource = CloseHandshakeSource.LOCAL;
            }
            out = false;
            this.outputAvailable = false;
            LOG.debug("onCloseLocal(), input={}, output={}", new Object[]{in, out});
            if (!in && !out) {
                LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
                this.cleanClose = true;
                event = this.state = ConnectionState.CLOSED;
            } else if (this.state == ConnectionState.OPEN) {
                event = this.state = ConnectionState.CLOSING;
            }
        }
        if (event != null) {
            LOG.debug("notifying state listeners: {}", new Object[]{event});
            this.notifyStateListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCloseRemote(CloseInfo close) {
        LOG.debug("onCloseRemote({})", new Object[]{close});
        ConnectionState event = null;
        IOState iOState = this;
        synchronized (iOState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            if (this.closeInfo == null) {
                this.closeInfo = close;
            }
            boolean in = this.inputAvailable;
            boolean out = this.outputAvailable;
            if (this.closeHandshakeSource == CloseHandshakeSource.NONE) {
                this.closeHandshakeSource = CloseHandshakeSource.REMOTE;
            }
            in = false;
            this.inputAvailable = false;
            LOG.debug("onCloseRemote(), input={}, output={}", new Object[]{in, out});
            if (!in && !out) {
                LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
                this.cleanClose = true;
                event = this.state = ConnectionState.CLOSED;
            } else if (this.state == ConnectionState.OPEN) {
                event = this.state = ConnectionState.CLOSING;
            }
        }
        if (event != null) {
            this.notifyStateListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        if (this.state != ConnectionState.CONNECTING) {
            LOG.debug("Unable to set to connected, not in CONNECTING state: {}", new Object[]{this.state});
            return;
        }
        ConnectionState event = null;
        IOState iOState = this;
        synchronized (iOState) {
            this.state = ConnectionState.CONNECTED;
            this.inputAvailable = false;
            this.outputAvailable = true;
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailedUpgrade() {
        assert (this.state == ConnectionState.CONNECTING);
        ConnectionState event = null;
        IOState iOState = this;
        synchronized (iOState) {
            this.state = ConnectionState.CLOSED;
            this.cleanClose = false;
            this.inputAvailable = false;
            this.outputAvailable = false;
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpened() {
        if (this.state == ConnectionState.OPEN) {
            return;
        }
        if (this.state != ConnectionState.CONNECTED) {
            LOG.debug("Unable to open, not in CONNECTED state: {}", new Object[]{this.state});
            return;
        }
        ConnectionState event = null;
        IOState iOState = this;
        synchronized (iOState) {
            this.state = ConnectionState.OPEN;
            this.inputAvailable = true;
            this.outputAvailable = true;
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadEOF() {
        ConnectionState event = null;
        IOState iOState = this;
        synchronized (iOState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            CloseInfo close = new CloseInfo(1006, "Read EOF");
            this.cleanClose = false;
            this.state = ConnectionState.CLOSED;
            if (this.closeInfo == null) {
                this.closeInfo = close;
            }
            this.inputAvailable = false;
            this.outputAvailable = false;
            this.closeHandshakeSource = CloseHandshakeSource.ABNORMAL;
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    public boolean wasAbnormalClose() {
        return this.closeHandshakeSource == CloseHandshakeSource.ABNORMAL;
    }

    public boolean wasCleanClose() {
        return this.cleanClose;
    }

    public boolean wasLocalCloseInitiated() {
        return this.closeHandshakeSource == CloseHandshakeSource.LOCAL;
    }

    public boolean wasRemoteCloseInitiated() {
        return this.closeHandshakeSource == CloseHandshakeSource.REMOTE;
    }

    public static interface ConnectionStateListener {
        public void onConnectionStateChange(ConnectionState var1);
    }

    private static enum CloseHandshakeSource {
        NONE,
        LOCAL,
        REMOTE,
        ABNORMAL;

    }
}

