/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.PrototyperThread;
import org.logicalcobwebs.proxool.ProxoolException;

public class PrototyperController {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$PrototyperController == null ? (class$org$logicalcobwebs$proxool$PrototyperController = PrototyperController.class$("org.logicalcobwebs.proxool.PrototyperController")) : class$org$logicalcobwebs$proxool$PrototyperController));
    private static PrototyperThread prototyperThread;
    private static boolean keepSweeping;
    private static final String LOCK = "LOCK";
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$PrototyperController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void startPrototyper() {
        if (prototyperThread != null) return;
        String string = LOCK;
        synchronized (LOCK) {
            if (prototyperThread != null) return;
            prototyperThread = new PrototyperThread("Prototyper");
            prototyperThread.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void triggerSweep(String alias) {
        block13: {
            block12: {
                try {
                    ConnectionPool cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
                    try {
                        cp.acquirePrimaryReadLock();
                        cp.getPrototyper().triggerSweep();
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)"Couldn't acquire primary read lock", (Throwable)e);
                    }
                    finally {
                        cp.releasePrimaryReadLock();
                    }
                }
                catch (ProxoolException e) {
                    if (!LOG.isDebugEnabled()) break block12;
                    LOG.debug((Object)("Couldn't trigger prototyper triggerSweep for '" + alias + "'  - maybe it's just been shutdown"));
                }
            }
            PrototyperController.startPrototyper();
            try {
                keepSweeping = true;
                if (prototyperThread != null) {
                    prototyperThread.doNotify();
                }
            }
            catch (IllegalMonitorStateException e) {
                LOG.debug((Object)"Hmm", (Throwable)e);
                if (Thread.activeCount() > 10 && LOG.isInfoEnabled()) {
                    LOG.info((Object)("Suspicious thread count of " + Thread.activeCount()));
                }
            }
            catch (IllegalThreadStateException e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug((Object)"Ignoring attempt to prototype whilst already prototyping");
            }
        }
    }

    public static boolean isKeepSweeping() {
        return keepSweeping;
    }

    public static void sweepStarted() {
        keepSweeping = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() {
        String string = LOCK;
        synchronized (LOCK) {
            if (prototyperThread != null) {
                LOG.info((Object)("Stopping " + prototyperThread.getName() + " thread"));
                prototyperThread.cancel();
                prototyperThread = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

