/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTCPCryptoContext;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;

public class SRTCPTransformer
implements PacketTransformer {
    private final SRTPContextFactory forwardFactory;
    private final SRTPContextFactory reverseFactory;
    private final Map<Integer, SRTCPCryptoContext> contexts;

    public SRTCPTransformer(SRTPContextFactory factory) {
        this(factory, factory);
    }

    public SRTCPTransformer(SRTPContextFactory forwardFactory, SRTPContextFactory reverseFactory) {
        this.forwardFactory = forwardFactory;
        this.reverseFactory = reverseFactory;
        this.contexts = new HashMap<Integer, SRTCPCryptoContext>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Integer, SRTCPCryptoContext> map = this.contexts;
        synchronized (map) {
            this.forwardFactory.close();
            if (this.reverseFactory != this.forwardFactory) {
                this.reverseFactory.close();
            }
            Iterator<SRTCPCryptoContext> i = this.contexts.values().iterator();
            while (i.hasNext()) {
                SRTCPCryptoContext context = i.next();
                i.remove();
                if (context == null) continue;
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRTCPCryptoContext getContext(RawPacket pkt, SRTPContextFactory engine) {
        int ssrc = pkt.getRTCPSSRC();
        SRTCPCryptoContext context = null;
        Map<Integer, SRTCPCryptoContext> map = this.contexts;
        synchronized (map) {
            context = this.contexts.get(ssrc);
            if (context == null && engine != null && (context = engine.getDefaultContextControl()) != null) {
                context = context.deriveContext(ssrc);
                context.deriveSrtcpKeys();
                this.contexts.put(ssrc, context);
            }
        }
        return context;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        SRTCPCryptoContext context = this.getContext(pkt, this.reverseFactory);
        return context != null && context.reverseTransformPacket(pkt) ? pkt : null;
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        SRTCPCryptoContext context = this.getContext(pkt, this.forwardFactory);
        if (context != null) {
            context.transformPacket(pkt);
            return pkt;
        }
        return null;
    }
}

