/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.util.Logger;

public class DatagramTransportImpl
implements DatagramTransport {
    private static final Logger logger = Logger.getLogger(DatagramTransportImpl.class);
    private final int componentID;
    private AbstractRTPConnector connector;
    private final Queue<RawPacket> rawPacketPool = new LinkedBlockingQueue<RawPacket>();
    private final ArrayBlockingQueue<RawPacket> receiveQ;
    private final int receiveQCapacity;

    public DatagramTransportImpl(int componentID) {
        switch (componentID) {
            case 1: 
            case 2: {
                this.componentID = componentID;
                break;
            }
            default: {
                throw new IllegalArgumentException("componentID");
            }
        }
        this.receiveQCapacity = 256;
        this.receiveQ = new ArrayBlockingQueue(this.receiveQCapacity);
    }

    private void breakOutOfDTLSReliableHandshakeReceiveMessage(Throwable cause) {
        for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
            if (!"org.bouncycastle.crypto.tls.DTLSReliableHandshake".equals(stackTraceElement.getClassName()) || !"receiveMessage".equals(stackTraceElement.getMethodName())) continue;
            throw new IllegalStateException(cause);
        }
    }

    public void close() throws IOException {
        this.setConnector(null);
    }

    public int getReceiveLimit() throws IOException {
        int receiveLimit;
        AbstractRTPConnector connector = this.connector;
        int n = receiveLimit = connector == null ? -1 : connector.getReceiveBufferSize();
        if (receiveLimit <= 0) {
            receiveLimit = 4096;
        }
        return receiveLimit;
    }

    public int getSendLimit() throws IOException {
        int sendLimit;
        AbstractRTPConnector connector = this.connector;
        int n = sendLimit = connector == null ? -1 : connector.getSendBufferSize();
        if (sendLimit <= 0) {
            sendLimit = 1037;
        }
        return sendLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queue(byte[] buf, int off, int len) {
        if (len > 0) {
            ArrayBlockingQueue<RawPacket> arrayBlockingQueue = this.receiveQ;
            synchronized (arrayBlockingQueue) {
                byte[] pktBuf;
                if (this.connector == null) {
                    String msg = this.getClass().getName() + " is closed!";
                    IllegalStateException ise = new IllegalStateException(msg);
                    logger.error(msg, ise);
                    throw ise;
                }
                RawPacket pkt = this.rawPacketPool.poll();
                if (pkt == null || (pktBuf = pkt.getBuffer()).length < len) {
                    pktBuf = new byte[len];
                    pkt = new RawPacket(pktBuf, 0, len);
                } else {
                    pktBuf = pkt.getBuffer();
                    pkt.setLength(len);
                    pkt.setOffset(0);
                }
                System.arraycopy(buf, off, pktBuf, 0, len);
                if (this.receiveQ.size() == this.receiveQCapacity) {
                    RawPacket oldPkt = (RawPacket)this.receiveQ.remove();
                    this.rawPacketPool.offer(oldPkt);
                }
                this.receiveQ.add(pkt);
                this.receiveQ.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        long enterTime = System.currentTimeMillis();
        int received = 0;
        boolean interrupted = false;
        while (received < len) {
            long timeout;
            if (waitMillis > 0) {
                timeout = (long)waitMillis - System.currentTimeMillis() + enterTime;
                if (timeout == 0L) {
                    timeout = -1L;
                }
            } else {
                timeout = waitMillis;
            }
            ArrayBlockingQueue<RawPacket> arrayBlockingQueue = this.receiveQ;
            synchronized (arrayBlockingQueue) {
                if (this.connector == null) {
                    String msg = this.getClass().getName() + " is closed!";
                    IOException ioe = new IOException(msg);
                    logger.error(msg, ioe);
                    this.breakOutOfDTLSReliableHandshakeReceiveMessage(ioe);
                    throw ioe;
                }
                RawPacket pkt = this.receiveQ.peek();
                if (pkt != null) {
                    boolean toReceiveIsPositive;
                    int toReceive = len - received;
                    boolean bl = toReceiveIsPositive = toReceive > 0;
                    if (toReceiveIsPositive) {
                        int pktLength = pkt.getLength();
                        int pktOffset = pkt.getOffset();
                        if (toReceive > pktLength) {
                            toReceive = pktLength;
                            boolean bl2 = toReceiveIsPositive = toReceive > 0;
                        }
                        if (toReceiveIsPositive) {
                            System.arraycopy(pkt.getBuffer(), pktOffset, buf, off + received, toReceive);
                            received += toReceive;
                        }
                        if (toReceive == pktLength) {
                            this.receiveQ.remove();
                            this.rawPacketPool.offer(pkt);
                        } else {
                            pkt.setLength(pktLength - toReceive);
                            pkt.setOffset(pktOffset + toReceive);
                        }
                        if (toReceiveIsPositive) {
                            break;
                        }
                    } else {
                        break;
                    }
                }
                if (this.receiveQ.isEmpty()) {
                    if (timeout >= 0L) {
                        try {
                            this.receiveQ.wait(timeout);
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    } else {
                        break;
                    }
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return received;
    }

    public void send(byte[] buf, int off, int len) throws IOException {
        RTPConnectorOutputStream outputStream;
        AbstractRTPConnector connector = this.connector;
        if (connector == null) {
            String msg = this.getClass().getName() + " is closed!";
            IOException ioe = new IOException(msg);
            logger.error(msg, ioe);
            throw ioe;
        }
        switch (this.componentID) {
            case 2: {
                outputStream = connector.getControlOutputStream();
                break;
            }
            case 1: {
                outputStream = connector.getDataOutputStream();
                break;
            }
            default: {
                String msg = "componentID";
                IllegalStateException ise = new IllegalStateException(msg);
                logger.error(msg, ise);
                throw ise;
            }
        }
        outputStream.write(buf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnector(AbstractRTPConnector connector) {
        ArrayBlockingQueue<RawPacket> arrayBlockingQueue = this.receiveQ;
        synchronized (arrayBlockingQueue) {
            this.connector = connector;
            this.receiveQ.notifyAll();
        }
    }
}

