/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.lang.ref.SoftReference;
import javax.media.Buffer;

class IntArrayCache {
    private SoftReference<int[][]> elements;
    private int length;

    IntArrayCache() {
    }

    public synchronized int[] allocateIntArray(int minSize) {
        int[][] elements;
        int[][] nArray = elements = this.elements == null ? (int[][])null : this.elements.get();
        if (elements != null) {
            for (int i = 0; i < this.length; ++i) {
                int[] element = elements[i];
                if (element == null || element.length < minSize) continue;
                elements[i] = null;
                return element;
            }
        }
        return new int[minSize];
    }

    public synchronized void deallocateIntArray(int[] intArray) {
        Object elements;
        block12: {
            block11: {
                if (intArray == null) {
                    return;
                }
                if (this.elements == null) break block11;
                int[][] nArray = this.elements.get();
                elements = nArray;
                if (nArray != null) break block12;
            }
            elements = new int[8][];
            this.elements = new SoftReference<int[][]>((int[][])elements);
            this.length = 0;
        }
        if (this.length != 0) {
            for (int i = 0; i < this.length; ++i) {
                if (elements[i] != intArray) continue;
                return;
            }
        }
        if (this.length == ((int[][])elements).length) {
            int newLength = 0;
            for (int i = 0; i < this.length; ++i) {
                int[] element = elements[i];
                if (element == null) continue;
                if (i != newLength) {
                    elements[newLength] = element;
                    elements[i] = null;
                }
                ++newLength;
            }
            if (newLength == this.length) {
                int[][] newElements = new int[((int[][])elements).length + 4][];
                System.arraycopy(elements, 0, newElements, 0, ((int[][])elements).length);
                elements = newElements;
                this.elements = new SoftReference<int[][]>((int[][])elements);
            } else {
                this.length = newLength;
            }
        }
        elements[this.length++] = intArray;
    }

    public int[] validateIntArraySize(Buffer buffer, int newSize) {
        int[] intArray;
        Object data = buffer.getData();
        if (data instanceof int[]) {
            intArray = (int[])data;
            if (intArray.length < newSize) {
                this.deallocateIntArray(intArray);
                intArray = null;
            }
        } else {
            intArray = null;
        }
        if (intArray == null) {
            intArray = this.allocateIntArray(newSize);
            buffer.setData(intArray);
        }
        return intArray;
    }
}

