/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.audiolevel;

import org.jitsi.impl.neomedia.ArrayIOUtils;

public class AudioLevelCalculator {
    private static final double DEC_LEVEL = 0.2;
    private static final double INC_LEVEL = 0.4;
    private static final int MAX_AUDIO_LEVEL = Short.MAX_VALUE;
    private static final double MAX_SOUND_PRESSURE_LEVEL = 127.0;
    private static final int MIN_AUDIO_LEVEL = Short.MIN_VALUE;

    private static int animateLevel(int level, int minLevel, int maxLevel, int lastLevel) {
        int diff = lastLevel - level;
        if (diff >= 0) {
            int maxDiff = (int)((double)maxLevel * 0.2);
            if (diff > maxDiff) {
                level = lastLevel - maxDiff;
            }
        } else {
            int maxDiff = (int)((double)maxLevel * 0.4);
            if (diff > maxDiff) {
                level = lastLevel + maxDiff;
            }
        }
        return level;
    }

    public static int calculateSignalPowerLevel(byte[] samples, int offset, int length, int minLevel, int maxLevel, int lastLevel) {
        if (length == 0) {
            return 0;
        }
        int samplesNumber = length / 2;
        int absoluteMeanSoundLevel = 0;
        double levelRatio = Short.MAX_VALUE / (maxLevel - minLevel) / 16;
        for (int i = 0; i < samplesNumber; ++i) {
            byte tempL;
            byte tempH;
            int soundLevel;
            if ((soundLevel = (tempH = samples[offset++]) << 8 | (tempL = samples[offset++]) & 0xFF) > Short.MAX_VALUE) {
                soundLevel = Short.MAX_VALUE;
            } else if (soundLevel < Short.MIN_VALUE) {
                soundLevel = Short.MIN_VALUE;
            }
            absoluteMeanSoundLevel += Math.abs(soundLevel);
        }
        int result = (int)((double)(absoluteMeanSoundLevel / samplesNumber) / levelRatio);
        result = AudioLevelCalculator.ensureLevelRange(result, minLevel, maxLevel);
        result = AudioLevelCalculator.animateLevel(result, minLevel, maxLevel, lastLevel);
        return result;
    }

    public static int calculateSoundPressureLevel(byte[] samples, int offset, int length, int minLevel, int maxLevel, int lastLevel) {
        double rms = 0.0;
        int sampleCount = 0;
        while (offset < length) {
            double sample = ArrayIOUtils.readShort(samples, offset);
            rms += (sample /= 32767.0) * sample;
            ++sampleCount;
            offset += 2;
        }
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? 20.0 * Math.log10(rms / 2.0E-5) : -127.0;
        return AudioLevelCalculator.ensureLevelRange((int)db, minLevel, maxLevel);
    }

    private static int ensureLevelRange(int level, int minLevel, int maxLevel) {
        if (level < minLevel) {
            return minLevel;
        }
        if (level > maxLevel) {
            return maxLevel;
        }
        return level;
    }
}

