/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.fileaccess;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;
import org.jitsi.impl.fileaccess.FailSafeTransactionImpl;
import org.jitsi.impl.fileaccess.TempFileManager;
import org.jitsi.service.fileaccess.FailSafeTransaction;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;

public class FileAccessServiceImpl
implements FileAccessService {
    private static final Logger logger = Logger.getLogger(FileAccessServiceImpl.class);
    public static final String TEMP_FILE_PREFIX = "SIPCOMM";
    public static final String TEMP_FILE_SUFFIX = "TEMP";
    private final String profileDirLocation = FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
    private final String cacheDirLocation;
    private final String logDirLocation;
    private final String scHomeDirName;

    public FileAccessServiceImpl() {
        if (this.profileDirLocation == null) {
            throw new IllegalStateException("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
        }
        String cacheDir = FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_CACHE_DIR_LOCATION");
        this.cacheDirLocation = cacheDir == null ? this.profileDirLocation : cacheDir;
        String logDir = FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_LOG_DIR_LOCATION");
        this.logDirLocation = logDir == null ? this.profileDirLocation : logDir;
        this.scHomeDirName = FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
        if (this.scHomeDirName == null) {
            throw new IllegalStateException("net.java.sip.communicator.SC_HOME_DIR_NAME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getTemporaryFile() throws IOException {
        File retVal = null;
        try {
            logger.logEntry();
            retVal = TempFileManager.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        }
        finally {
            logger.logExit();
        }
        return retVal;
    }

    @Override
    public File getTemporaryDirectory() throws IOException {
        File file = this.getTemporaryFile();
        if (!file.delete()) {
            throw new IOException("Could not create temporary directory, because: could not delete temporary file.");
        }
        if (!file.mkdirs()) {
            throw new IOException("Could not create temporary directory");
        }
        return file;
    }

    @Override
    @Deprecated
    public File getPrivatePersistentFile(String fileName) throws Exception {
        return this.getPrivatePersistentFile(fileName, FileCategory.PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getPrivatePersistentFile(String fileName, FileCategory category) throws Exception {
        logger.logEntry();
        File file = null;
        try {
            file = FileAccessServiceImpl.accessibleFile(this.getFullPath(category), fileName);
            if (file == null) {
                throw new SecurityException("Insufficient rights to access this file in current user's home directory: " + new File(this.getFullPath(category), fileName).getPath());
            }
        }
        finally {
            logger.logExit();
        }
        return file;
    }

    @Override
    @Deprecated
    public File getPrivatePersistentDirectory(String dirName) throws Exception {
        return this.getPrivatePersistentDirectory(dirName, FileCategory.PROFILE);
    }

    @Override
    public File getPrivatePersistentDirectory(String dirName, FileCategory category) throws Exception {
        File dir = new File(this.getFullPath(category), dirName);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new RuntimeException("Could not create directory because: A file exists with this name:" + dir.getAbsolutePath());
            }
        } else if (!dir.mkdirs()) {
            throw new IOException("Could not create directory");
        }
        return dir;
    }

    private File getFullPath(FileCategory category) {
        String directory;
        switch (category) {
            case CACHE: {
                directory = this.cacheDirLocation;
                break;
            }
            case LOG: {
                directory = this.logDirLocation;
                break;
            }
            default: {
                directory = this.profileDirLocation;
            }
        }
        return new File(directory, this.scHomeDirName);
    }

    private static String getSystemProperty(String propertyName) {
        String retval = System.getProperty(propertyName);
        if (retval == null) {
            return retval;
        }
        if (retval.trim().length() == 0) {
            return null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File accessibleFile(File homedir, String fileName) throws IOException {
        File file = null;
        try {
            logger.logEntry();
            file = new File(homedir, fileName);
            if (file.canRead() || file.canWrite()) {
                File file2 = file;
                return file2;
            }
            if (!homedir.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating home directory : " + homedir.getAbsolutePath());
                }
                if (!homedir.mkdirs()) {
                    String message = "Could not create the home directory : " + homedir.getAbsolutePath();
                    if (logger.isDebugEnabled()) {
                        logger.debug(message);
                    }
                    throw new IOException(message);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Home directory created : " + homedir.getAbsolutePath());
                }
            } else if (!homedir.canWrite()) {
                file = null;
            }
            if (file != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                String message = "Could not create the parent directory : " + homedir.getAbsolutePath();
                logger.debug(message);
                throw new IOException(message);
            }
        }
        finally {
            logger.logExit();
        }
        return file;
    }

    @Override
    public File getDefaultDownloadDirectory() throws IOException {
        File downloadDir;
        if (OSUtils.IS_WINDOWS && FileAccessServiceImpl.getMajorOSVersion() <= 5) {
            downloadDir = FileSystemView.getFileSystemView().getHomeDirectory();
        } else {
            String defaultLocation = FileAccessServiceImpl.getSystemProperty("user.home") + File.separatorChar + "Downloads";
            downloadDir = new File(defaultLocation);
        }
        return downloadDir;
    }

    private static int getMajorOSVersion() {
        int majorOSVersion;
        String osVersion = System.getProperty("os.version");
        if (osVersion != null && osVersion.length() > 0) {
            int majorOSVersionEnd = osVersion.indexOf(46);
            String majorOSVersionString = majorOSVersionEnd > -1 ? osVersion.substring(0, majorOSVersionEnd) : osVersion;
            majorOSVersion = Integer.parseInt(majorOSVersionString);
        } else {
            majorOSVersion = 0;
        }
        return majorOSVersion;
    }

    @Override
    public FailSafeTransaction createFailSafeTransaction(File file) {
        return file == null ? null : new FailSafeTransactionImpl(file);
    }
}

