/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.rtp.SSRCCache;

public class FormatInfo {
    private SSRCCache cache = null;
    public static final int PAYLOAD_NOTFOUND = -1;
    Format[] formatList = new Format[111];
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");

    public static boolean isSupported(int i) {
        switch (i) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 31: 
            case 32: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public FormatInfo() {
        this.initFormats();
    }

    public void add(int i, Format format) {
        Format format1;
        if (i >= this.formatList.length) {
            this.expandTable(i);
        }
        if ((format1 = this.formatList[i]) != null) {
            return;
        }
        this.formatList[i] = format;
        if (this.cache != null && format instanceof VideoFormat) {
            this.cache.clockrate[i] = 90000;
        }
        if (this.cache != null && format instanceof AudioFormat) {
            this.cache.clockrate[i] = mpegAudio.matches(format) ? 90000 : (int)((AudioFormat)format).getSampleRate();
        }
    }

    private void expandTable(int i) {
        Format[] aformat = new Format[i + 1];
        for (int j = 0; j < this.formatList.length; ++j) {
            aformat[j] = this.formatList[j];
        }
        this.formatList = aformat;
    }

    public Format get(int i) {
        return i >= this.formatList.length ? null : this.formatList[i];
    }

    public int getPayload(Format format) {
        if (format.getEncoding() != null && format.getEncoding().equals("g729a/rtp")) {
            format = new AudioFormat("g729/rtp");
        }
        for (int i = 0; i < this.formatList.length; ++i) {
            if (!format.matches(this.formatList[i])) continue;
            return i;
        }
        return -1;
    }

    public void initFormats() {
        this.formatList[0] = new AudioFormat("ULAW/rtp", 8000.0, 8, 1);
        this.formatList[3] = new AudioFormat("gsm/rtp", 8000.0, -1, 1);
        this.formatList[4] = new AudioFormat("g723/rtp", 8000.0, -1, 1);
        this.formatList[5] = new AudioFormat("dvi/rtp", 8000.0, 4, 1);
        this.formatList[8] = new AudioFormat("ALAW/rtp", 8000.0, 8, 1);
        this.formatList[14] = new AudioFormat("mpegaudio/rtp", -1.0, -1, -1);
        this.formatList[15] = new AudioFormat("g728/rtp", 8000.0, -1, 1);
        this.formatList[16] = new AudioFormat("dvi/rtp", 11025.0, 4, 1);
        this.formatList[17] = new AudioFormat("dvi/rtp", 22050.0, 4, 1);
        this.formatList[18] = new AudioFormat("g729/rtp", 8000.0, -1, 1);
        this.formatList[26] = new VideoFormat("jpeg/rtp");
        this.formatList[31] = new VideoFormat("h261/rtp");
        this.formatList[32] = new VideoFormat("mpeg/rtp");
        this.formatList[34] = new VideoFormat("h263/rtp");
    }

    public void setCache(SSRCCache ssrccache) {
        this.cache = ssrccache;
    }
}

