/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.pseudotcp.Option;
import org.ice4j.pseudotcp.PseudoTCPBase;
import org.ice4j.pseudotcp.PseudoTcpTestBase;
import org.ice4j.pseudotcp.util.ByteFifoBuffer;

public class PseudoTcpTestRecvWindow
extends PseudoTcpTestBase {
    private static final Logger logger = Logger.getLogger(PseudoTCPBase.class.getName());
    private ByteFifoBuffer send_stream;
    private List<Integer> send_position;
    private ByteFifoBuffer recv_stream;
    private List<Integer> recv_position;
    private Timer writeTimer = new Timer("WriteTimer");
    private int testDataSize;

    public void doTestTransfer(int size) {
        int send_position_diff;
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.testDataSize = size;
        this.send_position = new ArrayList<Integer>();
        this.recv_position = new ArrayList<Integer>();
        byte[] dummy = PseudoTcpTestRecvWindow.createDummyData(size);
        this.send_stream = new ByteFifoBuffer(size);
        this.send_stream.write(dummy, size);
        this.recv_stream = new ByteFifoBuffer(size);
        long start = PseudoTCPBase.now();
        this.startClocks();
        try {
            this.connect();
        }
        catch (IOException ex) {
            PseudoTcpTestRecvWindow.fail((String)ex.getMessage());
        }
        this.assert_Connected_wait(5000);
        this.scheduleWriteAction(0L);
        long transferTout = this.maxTransferTime(dummy.length, 1000L);
        boolean transfferInTime = this.assert_Disconnected_wait(transferTout);
        long elapsed = PseudoTCPBase.now() - start;
        this.stopClocks();
        int received = this.recv_stream.getBuffered();
        PseudoTcpTestRecvWindow.assertEquals((String)("Transfer timeout, transferred: " + received + " required: " + dummy.length + " elapsed: " + elapsed + " limit: " + transferTout), (boolean)true, (boolean)transfferInTime);
        assert (2 == this.send_position.size());
        assert (2 == this.recv_position.size());
        int estimated_recv_window = this.estimateReceiveWindowSize();
        PseudoTcpTestRecvWindow.assertTrue((estimated_recv_window - (send_position_diff = this.send_position.get(1) - this.send_position.get(0)) <= 1024 ? 1 : 0) != 0);
        assert (this.recv_position.get(1) - 2 * estimated_recv_window <= PseudoTcpTestRecvWindow.getShadowedBytes(this.getRemoteScaleFactor()));
    }

    static int getShadowedBytes(int scaleFactor) {
        return (int)(Math.pow(2.0, scaleFactor) - 1.0);
    }

    void readUntilIOPending() throws IOException {
        int rcvd;
        byte[] block = new byte[this.getRemoteTcp().getRecvBufferSize() * 2];
        int position = this.recv_stream.getBuffered();
        int total = 0;
        do {
            if ((rcvd = this.remoteRecv(block, block.length)) <= 0) continue;
            this.recv_stream.write(block, rcvd);
            total += rcvd;
            position += rcvd;
        } while (rcvd > 0 && total != 0);
        this.recv_position.add(position);
        if (this.recv_position.size() == 2) {
            this.close();
            this.onTcpClosed(this.getRemoteTcp(), null);
        } else {
            this.writeData();
        }
    }

    void scheduleWriteAction(long delay) {
        this.writeTimer.schedule(new TimerTask(){

            public void run() {
                try {
                    PseudoTcpTestRecvWindow.this.writeData();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeData() throws IOException {
        int totalSent = 0;
        byte[] block = new byte[this.getRemoteTcp().getRecvBufferSize() * 2];
        int position = this.testDataSize - this.send_stream.getBuffered();
        PseudoTCPBase pseudoTCPBase = this.getLocalTcp();
        synchronized (pseudoTCPBase) {
            int sent;
            do {
                int tosend;
                if ((tosend = this.send_stream.readOffset(block, 0, block.length, 0)) > 0) {
                    sent = this.localSend(block, tosend);
                    this.updateLocalClock();
                    if (sent > 0) {
                        totalSent += sent;
                        this.send_stream.consumeReadData(sent);
                        position += sent;
                        continue;
                    }
                    logger.log(Level.FINE, "Flow Controlled");
                    continue;
                }
                tosend = 0;
                sent = 0;
            } while (sent > 0);
        }
        if (totalSent - this.getRemoteTcp().getAvailable() > PseudoTcpTestRecvWindow.getShadowedBytes(this.getRemoteScaleFactor())) {
            while (totalSent - this.getRemoteTcp().getAvailable() > PseudoTcpTestRecvWindow.getShadowedBytes(this.getRemoteScaleFactor()) && !this.getRemoteTcp().isReceiveBufferFull()) {
                try {
                    Thread.sleep(50L);
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.log(Level.FINER, "Waiting... sent: " + totalSent + " avail: " + this.getRemoteTcp().getAvailable() + " buffered not sent: " + this.getLocalTcp().getBytesBufferedNotSent() + " isFull? " + this.getRemoteTcp().isReceiveBufferFull());
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        this.send_position.add(position);
        this.writeTimer.schedule(new TimerTask(){

            public void run() {
                try {
                    PseudoTcpTestRecvWindow.this.readUntilIOPending();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, 10L);
    }

    int estimateReceiveWindowSize() {
        return this.recv_position.get(0);
    }

    int estimateSendWindowSize() {
        return this.send_position.get(0);
    }

    public void onTcpReadable(PseudoTCPBase tcp) {
    }

    public void onTcpWriteable(PseudoTCPBase tcp) {
    }

    void setLocalOptSndBuf(int len) {
        this.getLocalTcp().setOption(Option.OPT_SNDBUF, len);
    }

    int getRemoteScaleFactor() {
        return this.getRemoteTcp().getM_rwnd_scale();
    }

    public void testGetShadowedBytes() {
        assert (PseudoTcpTestRecvWindow.getShadowedBytes(0) == 0);
        assert (PseudoTcpTestRecvWindow.getShadowedBytes(1) == 1);
        assert (PseudoTcpTestRecvWindow.getShadowedBytes(2) == 3);
        assert (PseudoTcpTestRecvWindow.getShadowedBytes(3) == 7);
        assert (PseudoTcpTestRecvWindow.getShadowedBytes(4) == 15);
        assert (PseudoTcpTestRecvWindow.getShadowedBytes(11) == 2047);
        assert (PseudoTcpTestRecvWindow.getShadowedBytes(14) == 16383);
    }

    public void testReceiveWindow() {
        PseudoTcpTestRecvWindow test = new PseudoTcpTestRecvWindow();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setOptNagling(false);
        test.setOptAckDelay(0);
        test.doTestTransfer(1024000);
    }

    public void testSetVerySmallSendWindowSize() {
        logger.log(Level.INFO, "Test very small receive window");
        PseudoTcpTestRecvWindow test = new PseudoTcpTestRecvWindow();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setOptNagling(false);
        test.setOptAckDelay(0);
        test.setOptSndBuf(900);
        test.doTestTransfer(1024000);
        PseudoTcpTestRecvWindow.assertEquals((int)900, (int)test.estimateSendWindowSize());
    }

    public void testSetReceiveWindowSize() {
        PseudoTcpTestRecvWindow test = new PseudoTcpTestRecvWindow();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setOptNagling(false);
        test.setOptAckDelay(0);
        int wndSize = 300000;
        test.setRemoteOptRcvBuf(wndSize);
        test.setLocalOptSndBuf(wndSize);
        int wndScale = test.getRemoteScaleFactor();
        test.doTestTransfer(0x2EE000);
        assert (wndSize - test.estimateReceiveWindowSize() <= PseudoTcpTestRecvWindow.getShadowedBytes(wndScale));
    }
}

