/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.AbstractContactGroupJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ServerStoredContactListJabberImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;

public class ContactGroupJabberImpl
extends AbstractContactGroupJabberImpl {
    private Map<String, Contact> buddies = new Hashtable<String, Contact>();
    private boolean isResolved = false;
    private String id = null;
    private List<ContactGroup> dummyGroupsList = new LinkedList<ContactGroup>();
    private String nameCopy = null;
    private String tempId = null;
    private final ServerStoredContactListJabberImpl ssclCallback;

    ContactGroupJabberImpl(RosterGroup rosterGroup, Iterator<RosterEntry> groupMembers, ServerStoredContactListJabberImpl ssclCallback, boolean isResolved) {
        if (rosterGroup != null) {
            this.id = rosterGroup.getName();
        }
        this.isResolved = isResolved;
        this.ssclCallback = ssclCallback;
        if (rosterGroup != null) {
            this.nameCopy = rosterGroup.getName();
        }
        while (groupMembers.hasNext()) {
            RosterEntry rEntry = groupMembers.next();
            if (!ServerStoredContactListJabberImpl.isEntryDisplayable(rEntry) || ssclCallback.findContactById(rEntry.getUser()) != null) continue;
            this.addContact(new ContactJabberImpl(rEntry, ssclCallback, true, true));
        }
    }

    ContactGroupJabberImpl(String id, ServerStoredContactListJabberImpl ssclCallback) {
        this.tempId = id;
        this.isResolved = false;
        this.ssclCallback = ssclCallback;
    }

    public int countContacts() {
        return this.buddies.size();
    }

    public ContactGroup getParentContactGroup() {
        return this.ssclCallback.getRootGroup();
    }

    void addContact(ContactJabberImpl contact) {
        this.buddies.put(contact.getAddress().toLowerCase(), (Contact)contact);
    }

    void removeContact(ContactJabberImpl contact) {
        this.buddies.remove(contact.getAddress().toLowerCase());
    }

    public Iterator<Contact> contacts() {
        return this.buddies.values().iterator();
    }

    public Contact getContact(String id) {
        return this.findContact(id);
    }

    public String getGroupName() {
        if (this.isResolved) {
            return this.id;
        }
        return this.tempId;
    }

    public boolean canContainSubgroups() {
        return false;
    }

    public ContactGroup getGroup(int index) {
        return null;
    }

    public ContactGroup getGroup(String groupName) {
        return null;
    }

    public Iterator<ContactGroup> subgroups() {
        return this.dummyGroupsList.iterator();
    }

    public int countSubgroups() {
        return 0;
    }

    public int hashCode() {
        return this.getGroupName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ContactGroupJabberImpl)) {
            return false;
        }
        return ((ContactGroup)obj).getGroupName().equals(this.getGroupName());
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.ssclCallback.getParentProvider();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("JabberGroup.");
        buff.append(this.getGroupName()).append(", childContacts=").append(this.countContacts()).append(":[");
        Iterator<Contact> contacts = this.contacts();
        while (contacts.hasNext()) {
            Contact contact = contacts.next();
            buff.append(contact.toString());
            if (!contacts.hasNext()) continue;
            buff.append(", ");
        }
        return buff.append("]").toString();
    }

    ContactJabberImpl findContact(String id) {
        if (id == null) {
            return null;
        }
        return (ContactJabberImpl)this.buddies.get(id.toLowerCase());
    }

    void setNameCopy(String newName) {
        this.nameCopy = newName;
    }

    String getNameCopy() {
        return this.nameCopy;
    }

    public boolean isPersistent() {
        return true;
    }

    public String getPersistentData() {
        return null;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    void setResolved(RosterGroup source) {
        if (this.isResolved) {
            return;
        }
        this.isResolved = true;
        this.id = source.getName();
        for (RosterEntry item : source.getEntries()) {
            ContactJabberImpl contact = this.ssclCallback.findContactById(item.getUser());
            if (!ServerStoredContactListJabberImpl.isEntryDisplayable(item)) {
                if (contact == null) continue;
                this.removeContact(contact);
                this.ssclCallback.fireContactRemoved(this, contact);
                continue;
            }
            if (contact != null) {
                contact.setResolved(item);
                this.ssclCallback.fireContactResolved(this, contact);
                continue;
            }
            ContactJabberImpl newContact = new ContactJabberImpl(item, this.ssclCallback, true, true);
            this.addContact(newContact);
            this.ssclCallback.fireContactAdded(this, newContact);
        }
    }

    public String getUID() {
        return this.getGroupName();
    }

    RosterGroup getSourceGroup() {
        return this.ssclCallback.getRosterGroup(this.id);
    }

    void setSourceGroup(RosterGroup newGroup) {
        this.id = newGroup.getName();
    }
}

