/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.OSUtils;
import com.sun.media.format.WavAudioFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.media.Format;
import javax.media.PackageManager;
import javax.media.format.AudioFormat;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.pim.PlugInManager;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;
import net.sf.fmj.registry.Registry;
import net.sf.fmj.utility.PlugInInfo;
import net.sf.fmj.utility.PlugInUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryDefaults {
    public static final int JMF = 1;
    public static final int FMJ = 2;
    public static final int FMJ_NATIVE = 8;
    public static final int THIRD_PARTY = 4;
    public static final int NONE = 0;
    public static final int ALL = 15;
    private static final boolean ENABLE_GSTREAMER = false;
    public static boolean DISABLE_OGG = false;
    private static int defaultFlags = -1;

    public static List<String> contentPrefixList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) != 0) {
            arrayList.add("javax");
            arrayList.add("com.sun");
            arrayList.add("com.ibm");
        }
        if ((n & 8) != 0) {
            if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
                arrayList.add("net.sf.fmj.qt");
            }
            if (OSUtils.isWindows()) {
                arrayList.add("net.sf.fmj.ds");
            }
        }
        if ((n & 2) != 0) {
            arrayList.add("net.sf.fmj");
        }
        if ((n & 4) != 0) {
            // empty if block
        }
        return arrayList;
    }

    public static final int getDefaultFlags() {
        if (defaultFlags == -1) {
            boolean bl = false;
            try {
                bl = System.getProperty("net.sf.fmj.utility.JmfRegistry.JMFDefaults", "false").equals("true");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            defaultFlags = bl ? 1 : 15;
        }
        return defaultFlags;
    }

    public static List<Object> plugInList(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n == 0) {
            return arrayList;
        }
        if ((n & 1) != 0) {
            arrayList.add(new PlugInInfo("com.ibm.media.parser.video.MpegParser", new Format[]{new ContentDescriptor("audio.mpeg"), new ContentDescriptor("video.mpeg"), new ContentDescriptor("audio.mpeg")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.audio.WavParser", new Format[]{new ContentDescriptor("audio.x_wav")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.audio.AuParser", new Format[]{new ContentDescriptor("audio.basic")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.audio.AiffParser", new Format[]{new ContentDescriptor("audio.x_aiff")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.audio.GsmParser", new Format[]{new ContentDescriptor("audio.x_gsm")}, new Format[0], 1));
        }
        if ((n & 2) != 0) {
            arrayList.add(new PlugInInfo("net.sf.fmj.media.parser.RawPushBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
        }
        if ((n & 1) != 0) {
            arrayList.add(new PlugInInfo("com.sun.media.parser.RawStreamParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.RawBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.RawPullStreamParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.RawPullBufferParser", new Format[]{new ContentDescriptor("raw")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.video.QuicktimeParser", new Format[]{new ContentDescriptor("video.quicktime")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.parser.video.AviParser", new Format[]{new ContentDescriptor("video.x_msvideo")}, new Format[0], 1));
            arrayList.add(new PlugInInfo("com.sun.media.codec.audio.mpa.JavaDecoder", new Format[]{new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.video.cinepak.JavaDecoder", new Format[]{new VideoFormat("cvid", null, -1, Format.byteArray, -1.0f)}, new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.video.h263.JavaDecoder", new Format[]{new VideoFormat("h263", null, -1, Format.byteArray, -1.0f), new VideoFormat("h263/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.video.colorspace.JavaRGBConverter", new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, new Format[]{new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, -1)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.video.colorspace.JavaRGBToYUV", new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, -1, -1, -1, -1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, -1, -1)}, new Format[]{new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, -1, -1, -1)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.PCMToPCM", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.rc.RCModule", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 2, 0, 1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.audio.rc.RateCvrt", new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.audio.msadpcm.JavaDecoder", new Format[]{new AudioFormat("msadpcm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.ulaw.JavaDecoder", new Format[]{new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.alaw.JavaDecoder", new Format[]{new AudioFormat("alaw", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.dvi.JavaDecoder", new Format[]{new AudioFormat("dvi/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.g723.JavaDecoder", new Format[]{new AudioFormat("g723", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("g723/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.JavaDecoder", new Format[]{new AudioFormat("gsm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("gsm/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.JavaDecoder_ms", new Format[]{new AudioFormat("gsm/ms", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.ima4.JavaDecoder", new Format[]{new AudioFormat("ima4", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.ima4.JavaDecoder_ms", new Format[]{new AudioFormat("ima4/ms", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.ulaw.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.dvi.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("dvi/rtp", -1.0, 4, 1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("gsm", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.JavaEncoder_ms", new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new WavAudioFormat("gsm/ms", -1.0, -1, -1, -1, -1, -1, -1, -1.0f, Format.byteArray, null)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.ima4.JavaEncoder", new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ima4", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.ima4.JavaEncoder_ms", new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)}, new Format[]{new WavAudioFormat("ima4/ms", -1.0, -1, -1, -1, -1, -1, -1, -1.0f, Format.byteArray, null)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.audio.ulaw.Packetizer", new Format[]{new AudioFormat("ULAW", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW/rtp", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.audio.ulaw.DePacketizer", new Format[]{new AudioFormat("ULAW/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.audio.mpa.Packetizer", new Format[]{new AudioFormat("mpeglayer3", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("mpegaudio/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.audio.mpa.DePacketizer", new Format[]{new AudioFormat("mpegaudio/rtp", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("mpegaudio", 44100.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 48000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 32000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 22050.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 24000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 16000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 11025.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 12000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpegaudio", 8000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 44100.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 48000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 32000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 22050.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 24000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 16000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 11025.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 12000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray), new AudioFormat("mpeglayer3", 8000.0, 16, -1, 1, 1, -1, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.gsm.Packetizer", new Format[]{new AudioFormat("gsm", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("gsm/rtp", 8000.0, -1, 1, -1, -1, 264, -1.0, Format.byteArray)}, 2));
            arrayList.add(new PlugInInfo("com.ibm.media.codec.audio.g723.Packetizer", new Format[]{new AudioFormat("g723", 8000.0, -1, 1, -1, -1, 192, -1.0, Format.byteArray)}, new Format[]{new AudioFormat("g723/rtp", 8000.0, -1, 1, -1, -1, 192, -1.0, Format.byteArray)}, 2));
        }
        if ((n & 1) != 0) {
            arrayList.add(new PlugInInfo("com.sun.media.codec.video.jpeg.Packetizer", new Format[]{new JPEGFormat()}, new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, 2));
        }
        if ((n & 2) != 0) {
            arrayList.add(new PlugInInfo("net.sf.fmj.media.codec.video.jpeg.DePacketizer", new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new JPEGFormat()}, 2));
        }
        if ((n & 1) != 0) {
            arrayList.add(new PlugInInfo("com.sun.media.codec.video.jpeg.DePacketizer", new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new JPEGFormat()}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.video.mpeg.Packetizer", new Format[]{new VideoFormat("mpeg", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("mpeg/rtp", null, -1, Format.byteArray, -1.0f)}, 2));
            arrayList.add(new PlugInInfo("com.sun.media.codec.video.mpeg.DePacketizer", new Format[]{new VideoFormat("mpeg/rtp", null, -1, Format.byteArray, -1.0f)}, new Format[]{new VideoFormat("mpeg", null, -1, Format.byteArray, -1.0f)}, 2));
        }
        if ((n & 1) != 0) {
            arrayList.add(new PlugInInfo("com.sun.media.renderer.audio.JavaSoundRenderer", new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[0], 4));
            arrayList.add(new PlugInInfo("com.sun.media.renderer.audio.SunAudioRenderer", new Format[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1, -1, -1.0, Format.byteArray)}, new Format[0], 4));
            arrayList.add(new PlugInInfo("com.sun.media.renderer.video.AWTRenderer", new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, new Format[0], 4));
            arrayList.add(new PlugInInfo("com.sun.media.renderer.video.LightWeightRenderer", new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)}, new Format[0], 4));
            arrayList.add(new PlugInInfo("com.sun.media.renderer.video.JPEGRenderer", new Format[]{new JPEGFormat()}, new Format[0], 4));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.RawBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.RawSyncBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.RTPSyncBufferMux", new Format[0], new Format[]{new ContentDescriptor("raw.rtp")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.audio.GSMMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_gsm")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.audio.MPEGMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.mpeg")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.audio.WAVMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_wav")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.audio.AIFFMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.x_aiff")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.audio.AUMux", new Format[0], new Format[]{new FileTypeDescriptor("audio.basic")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.video.AVIMux", new Format[0], new Format[]{new FileTypeDescriptor("video.x_msvideo")}, 5));
            arrayList.add(new PlugInInfo("com.sun.media.multiplexer.video.QuicktimeMux", new Format[0], new Format[]{new FileTypeDescriptor("video.quicktime")}, 5));
        }
        if ((n & 2) != 0) {
            arrayList.add("net.sf.fmj.media.codec.video.jpeg.Packetizer");
            arrayList.add("net.sf.fmj.media.renderer.video.SimpleSwingRenderer");
            arrayList.add("net.sf.fmj.media.renderer.video.SimpleAWTRenderer");
            arrayList.add("net.sf.fmj.media.renderer.video.Java2dRenderer");
            arrayList.add("net.sf.fmj.media.renderer.video.JPEGRTPRenderer");
            arrayList.add("net.sf.fmj.media.renderer.video.JPEGRenderer");
            arrayList.add("net.sf.fmj.media.parser.JavaSoundParser");
            arrayList.add("net.sf.fmj.media.codec.JavaSoundCodec");
            arrayList.add("net.sf.fmj.media.renderer.audio.JavaSoundRenderer");
            arrayList.add("net.sf.fmj.media.codec.audio.gsm.Decoder");
            arrayList.add("net.sf.fmj.media.codec.audio.gsm.Encoder");
            arrayList.add("net.sf.fmj.media.codec.audio.gsm.DePacketizer");
            arrayList.add("net.sf.fmj.media.codec.audio.gsm.Packetizer");
            arrayList.add("net.sf.fmj.media.multiplexer.audio.GsmMux");
            arrayList.add("net.sf.fmj.media.parser.GsmParser");
            arrayList.add("net.sf.fmj.media.codec.audio.ulaw.Decoder");
            arrayList.add("net.sf.fmj.media.codec.audio.ulaw.Encoder");
            arrayList.add("net.sf.fmj.media.codec.audio.ulaw.DePacketizer");
            arrayList.add("net.sf.fmj.media.codec.audio.ulaw.Packetizer");
            arrayList.add("net.sf.fmj.media.codec.audio.RateConverter");
            arrayList.add("net.sf.fmj.media.codec.audio.alaw.Decoder");
            arrayList.add("net.sf.fmj.media.codec.audio.alaw.Encoder");
            arrayList.add("net.sf.fmj.media.codec.audio.alaw.DePacketizer");
            arrayList.add("net.sf.fmj.media.codec.audio.alaw.Packetizer");
            arrayList.add("net.sf.fmj.media.codec.video.jpeg.JpegEncoder");
            arrayList.add("net.sf.fmj.media.codec.video.lossless.GIFEncoder");
            arrayList.add("net.sf.fmj.media.codec.video.lossless.GIFDecoder");
            arrayList.add("net.sf.fmj.media.codec.video.lossless.PNGEncoder");
            arrayList.add("net.sf.fmj.media.codec.video.lossless.PNGDecoder");
            arrayList.add("net.sf.fmj.media.parser.RawStreamParser");
            arrayList.add("net.sf.fmj.media.parser.RawPullStreamParser");
            arrayList.add("net.sf.fmj.media.parser.RawPullBufferParser");
            arrayList.add("net.sf.fmj.media.multiplexer.RTPSyncBufferMux");
            arrayList.add("net.sf.fmj.media.multiplexer.RawBufferMux");
            arrayList.add("net.sf.fmj.media.multiplexer.audio.AIFFMux");
            arrayList.add("net.sf.fmj.media.multiplexer.audio.AUMux");
            arrayList.add("net.sf.fmj.media.multiplexer.audio.WAVMux");
            if (!DISABLE_OGG) {
                arrayList.add("net.sf.fmj.theora_java.JavaOggParser");
            }
            arrayList.add("net.sf.fmj.media.parser.MultipartMixedReplaceParser");
            arrayList.add("net.sf.fmj.media.multiplexer.MultipartMixedReplaceMux");
            arrayList.add("net.sf.fmj.media.parser.XmlMovieParser");
            arrayList.add("net.sf.fmj.media.multiplexer.XmlMovieMux");
            arrayList.add("net.sf.fmj.media.multiplexer.audio.CsvAudioMux");
            arrayList.add("net.java.sip.communicator.impl.media.codec.audio.speex.JavaEncoder");
            arrayList.add("net.java.sip.communicator.impl.media.codec.audio.speex.JavaDecoder");
            arrayList.add("net.java.sip.communicator.impl.media.codec.audio.ilbc.JavaEncoder");
            arrayList.add("net.java.sip.communicator.impl.media.codec.audio.ilbc.JavaDecoder");
            arrayList.add("com.t4l.jmf.JPEGDecoder");
        }
        if ((n & 8) != 0) {
            arrayList.add("net.sf.fmj.ffmpeg_java.FFMPEGParser");
            arrayList.add("net.sf.fmj.theora_java.NativeOggParser");
        }
        if ((n & 4) != 0) {
            arrayList.add("com.omnividea.media.parser.video.Parser");
            arrayList.add("com.omnividea.media.codec.video.NativeDecoder");
            arrayList.add("com.omnividea.media.codec.audio.NativeDecoder");
            arrayList.add("com.omnividea.media.codec.video.JavaDecoder");
        }
        if ((n & 2) != 0 && (n & 1) != 0) {
            arrayList.add(new PlugInInfo("com.ibm.media.parser.video.MpegParser", new Format[]{new ContentDescriptor("video.mpeg")}, new Format[0], 1));
        }
        return arrayList;
    }

    public static List<String> protocolPrefixList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) != 0) {
            arrayList.add("javax");
            arrayList.add("com.sun");
            arrayList.add("com.ibm");
        }
        if ((n & 8) != 0) {
            if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
                arrayList.add("net.sf.fmj.qt");
            }
            if (OSUtils.isWindows()) {
                arrayList.add("net.sf.fmj.ds");
            }
        }
        if ((n & 2) != 0) {
            arrayList.add("net.sf.fmj");
        }
        if ((n & 4) != 0) {
            arrayList.add("com.omnividea");
        }
        return arrayList;
    }

    public static void registerAll(int n) {
        RegistryDefaults.registerProtocolPrefixList(n);
        RegistryDefaults.registerContentPrefixList(n);
        RegistryDefaults.registerPlugins(n);
    }

    public static void registerContentPrefixList(int n) {
        if (n == 0) {
            return;
        }
        Vector vector = PackageManager.getContentPrefixList();
        List<String> list = RegistryDefaults.contentPrefixList(n);
        for (String string : list) {
            if (vector.contains(string)) continue;
            vector.add(string);
        }
        PackageManager.setContentPrefixList(vector);
    }

    public static void registerPlugins(int n) {
        if (n == 0) {
            return;
        }
        List<Object> list = RegistryDefaults.plugInList(n);
        for (Object object : list) {
            if (object instanceof PlugInInfo) {
                PlugInInfo plugInInfo = (PlugInInfo)object;
                PlugInManager.addPlugIn(plugInInfo.className, plugInInfo.in, plugInInfo.out, plugInInfo.type);
                continue;
            }
            PlugInUtility.registerPlugIn((String)object);
        }
    }

    public static void registerProtocolPrefixList(int n) {
        if (n == 0) {
            return;
        }
        Vector vector = PackageManager.getProtocolPrefixList();
        List<String> list = RegistryDefaults.protocolPrefixList(n);
        for (String string : list) {
            if (vector.contains(string)) continue;
            vector.add(string);
        }
        PackageManager.setProtocolPrefixList(vector);
    }

    private static List<String> removePluginsFromList(int n, List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : list) {
            String string = (String)e;
            boolean bl = false;
            if ((n & 1) != 0 && (string.startsWith("com.ibm.") || string.startsWith("com.sun.") || string.startsWith("javax.media."))) {
                bl = true;
            }
            if ((n & 2) != 0 && (string.startsWith("net.sf.fmj") || string.startsWith("net.java.sip.communicator.impl.media.") || string.startsWith("com.t4l.jmf")) && !string.equals("net.sf.fmj.ffmpeg_java.FFMPEGParser") && !string.equals("net.sf.fmj.theora_java.NativeOggParser")) {
                bl = true;
            }
            if ((n & 8) != 0 && (string.equals("net.sf.fmj.ffmpeg_java.FFMPEGParser") || string.equals("net.sf.fmj.theora_java.NativeOggParser"))) {
                bl = true;
            }
            if ((n & 4) != 0 && string.startsWith("com.omnividea.media.")) {
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static final void setDefaultFlags(int n) {
        defaultFlags = n;
    }

    public static void unRegisterAll(int n) {
        RegistryDefaults.unRegisterProtocolPrefixList(n);
        RegistryDefaults.unRegisterContentPrefixList(n);
        RegistryDefaults.unRegisterPlugins(n);
    }

    public static void unRegisterContentPrefixList(int n) {
        if (n == 0) {
            return;
        }
        Vector vector = PackageManager.getContentPrefixList();
        List<String> list = RegistryDefaults.contentPrefixList(n);
        for (String string : list) {
            if (!vector.contains(string)) continue;
            vector.remove(string);
        }
        PackageManager.setContentPrefixList(vector);
    }

    public static void unRegisterPlugins(int n) {
        List<String> list;
        List<String> list2;
        if (n == 0) {
            return;
        }
        int[] nArray = new int[]{1, 2, 3, 4, 5};
        Registry registry = Registry.getInstance();
        for (int n2 : nArray) {
            list2 = registry.getPluginList(n2);
            list = RegistryDefaults.removePluginsFromList(n, list2);
            list2.removeAll(list);
            registry.setPluginList(n2, list2);
        }
        for (int n2 : nArray) {
            list2 = PlugInManager.getPlugInList(null, null, n2);
            list = RegistryDefaults.removePluginsFromList(n, list2);
            for (String string : list) {
                PlugInManager.removePlugIn(string, n2);
            }
        }
    }

    public static void unRegisterProtocolPrefixList(int n) {
        if (n == 0) {
            return;
        }
        Vector vector = PackageManager.getProtocolPrefixList();
        List<String> list = RegistryDefaults.protocolPrefixList(n);
        for (String string : list) {
            if (!vector.contains(string)) continue;
            vector.remove(string);
        }
        PackageManager.setProtocolPrefixList(vector);
    }
}

