/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import java.util.Vector;
import net.sf.fmj.media.rtp.DefaultRTCPReportBuilderImpl;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.service.neomedia.RTCPTerminationStrategy;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.Transformer;

public class MinThroughputRTCPTerminationStrategy
implements RTCPTerminationStrategy,
Transformer<RTCPCompoundPacket> {
    private final RTCPReportBuilder reportBuilder = new DefaultRTCPReportBuilderImpl();
    public static final int MIN_MANTISSA = 10;
    public static final int MIN_EXP = 1;

    @Override
    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket inPacket) {
        if (inPacket == null || inPacket.packets == null || inPacket.packets.length == 0) {
            return inPacket;
        }
        Vector<RTCPPacket> outPackets = new Vector<RTCPPacket>();
        block8: for (RTCPPacket p : inPacket.packets) {
            switch (p.type) {
                case 201: {
                    continue block8;
                }
                case 200: {
                    RTCPSRPacket sr = (RTCPSRPacket)p;
                    outPackets.add(sr);
                    sr.reports = new RTCPReportBlock[0];
                    continue block8;
                }
                case 206: {
                    RTCPFBPacket psfb = (RTCPFBPacket)p;
                    switch (psfb.fmt) {
                        case 15: {
                            RTCPREMBPacket remb = (RTCPREMBPacket)p;
                            remb.mantissa = 10;
                            remb.exp = 1;
                            outPackets.add(remb);
                            continue block8;
                        }
                    }
                    outPackets.add(psfb);
                    continue block8;
                }
                default: {
                    outPackets.add(p);
                }
            }
        }
        Object[] outarr = new RTCPPacket[outPackets.size()];
        outPackets.copyInto(outarr);
        RTCPCompoundPacket outPacket = new RTCPCompoundPacket((RTCPPacket[])outarr);
        return outPacket;
    }

    @Override
    public void close() {
    }

    @Override
    public RTCPCompoundPacket transform(RTCPCompoundPacket inPacket) {
        return inPacket;
    }

    @Override
    public Transformer<RTCPCompoundPacket> getRTCPCompoundPacketTransformer() {
        return this;
    }

    @Override
    public RTCPReportBuilder getRTCPReportBuilder() {
        return this.reportBuilder;
    }

    @Override
    public void setRTPTranslator(RTPTranslator translator) {
    }

    @Override
    public RTPTranslator getRTPTranslator() {
        return null;
    }
}

