/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import org.jitsi.impl.neomedia.codec.audio.silk.EnergyFLP;
import org.jitsi.impl.neomedia.codec.audio.silk.InnerProductFLP;

public class BurgModifiedFLP {
    static final int MAX_FRAME_SIZE = 544;
    static final int MAX_NB_SUBFR = 4;

    static float SKP_Silk_burg_modified_FLP(float[] A, float[] x, int x_offset, int subfr_length, int nb_subfr, float WhiteNoiseFrac, int D) {
        double nrg_f;
        double Atmp;
        int k;
        double tmp1;
        int n;
        int x_ptr_offset;
        float[] x_ptr;
        int s;
        double[] C_first_row = new double[16];
        double[] C_last_row = new double[16];
        double[] CAf = new double[17];
        double[] CAb = new double[17];
        double[] Af = new double[16];
        assert (subfr_length * nb_subfr <= 544);
        assert (nb_subfr <= 4);
        double C0 = EnergyFLP.SKP_Silk_energy_FLP(x, x_offset, nb_subfr * subfr_length);
        for (s = 0; s < nb_subfr; ++s) {
            x_ptr = x;
            x_ptr_offset = x_offset + s * subfr_length;
            for (n = 1; n < D + 1; ++n) {
                int n2 = n - 1;
                C_first_row[n2] = C_first_row[n2] + InnerProductFLP.SKP_Silk_inner_product_FLP(x_ptr, x_ptr_offset, x_ptr, x_ptr_offset + n, subfr_length - n);
            }
        }
        System.arraycopy(C_first_row, 0, C_last_row, 0, 16);
        CAb[0] = CAf[0] = C0 + (double)WhiteNoiseFrac * C0 + (double)1.0E-9f;
        for (n = 0; n < D; ++n) {
            double tmp2;
            for (s = 0; s < nb_subfr; ++s) {
                x_ptr = x;
                x_ptr_offset = x_offset + s * subfr_length;
                tmp1 = x_ptr[x_ptr_offset + n];
                tmp2 = x_ptr[x_ptr_offset + subfr_length - n - 1];
                for (k = 0; k < n; ++k) {
                    int n3 = k;
                    C_first_row[n3] = C_first_row[n3] - (double)(x_ptr[x_ptr_offset + n] * x_ptr[x_ptr_offset + n - k - 1]);
                    int n4 = k;
                    C_last_row[n4] = C_last_row[n4] - (double)(x_ptr[x_ptr_offset + subfr_length - n - 1] * x_ptr[x_ptr_offset + subfr_length - n + k]);
                    Atmp = Af[k];
                    tmp1 += (double)x_ptr[x_ptr_offset + n - k - 1] * Atmp;
                    tmp2 += (double)x_ptr[x_ptr_offset + subfr_length - n + k] * Atmp;
                }
                for (k = 0; k <= n; ++k) {
                    int n5 = k;
                    CAf[n5] = CAf[n5] - tmp1 * (double)x_ptr[x_ptr_offset + n - k];
                    int n6 = k;
                    CAb[n6] = CAb[n6] - tmp2 * (double)x_ptr[x_ptr_offset + subfr_length - n + k - 1];
                }
            }
            tmp1 = C_first_row[n];
            tmp2 = C_last_row[n];
            for (k = 0; k < n; ++k) {
                Atmp = Af[k];
                tmp1 += C_last_row[n - k - 1] * Atmp;
                tmp2 += C_first_row[n - k - 1] * Atmp;
            }
            CAf[n + 1] = tmp1;
            CAb[n + 1] = tmp2;
            double num = CAb[n + 1];
            double nrg_b = CAb[0];
            nrg_f = CAf[0];
            for (k = 0; k < n; ++k) {
                Atmp = Af[k];
                num += CAb[n - k] * Atmp;
                nrg_b += CAb[k + 1] * Atmp;
                nrg_f += CAf[k + 1] * Atmp;
            }
            assert (nrg_f > 0.0);
            assert (nrg_b > 0.0);
            double rc = -2.0 * num / (nrg_f + nrg_b);
            assert (rc > -1.0 && rc < 1.0);
            for (k = 0; k < n + 1 >> 1; ++k) {
                tmp1 = Af[k];
                tmp2 = Af[n - k - 1];
                Af[k] = tmp1 + rc * tmp2;
                Af[n - k - 1] = tmp2 + rc * tmp1;
            }
            Af[n] = rc;
            for (k = 0; k <= n + 1; ++k) {
                tmp1 = CAf[k];
                int n7 = k;
                CAf[n7] = CAf[n7] + rc * CAb[n - k + 1];
                int n8 = n - k + 1;
                CAb[n8] = CAb[n8] + rc * tmp1;
            }
        }
        nrg_f = CAf[0];
        tmp1 = 1.0;
        for (k = 0; k < D; ++k) {
            Atmp = Af[k];
            nrg_f += CAf[k + 1] * Atmp;
            tmp1 += Atmp * Atmp;
            A[k] = (float)(-Atmp);
        }
        return (float)(nrg_f -= (double)WhiteNoiseFrac * C0 * tmp1);
    }
}

