/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;

public class ImageToBuffer {
    private static BufferedImage convert(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Buffer createBuffer(Image image, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        Class<?> clazz;
        int n5;
        Object[] objectArray;
        BufferedImage bufferedImage = image instanceof BufferedImage ? (BufferedImage)image : ImageToBuffer.convert(image);
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            int[] nArray;
            objectArray = nArray = ((DataBufferInt)dataBuffer).getData();
            n5 = nArray.length;
            clazz = Format.intArray;
        } else {
            if (!(dataBuffer instanceof DataBufferByte)) throw new IllegalArgumentException("Unknown or unsupported data buffer type: " + dataBuffer);
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            objectArray = byArray;
            n5 = byArray.length;
            clazz = Format.byteArray;
        }
        int n6 = bufferedImage.getType();
        Buffer buffer = new Buffer();
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        if (n6 == 5) {
            n4 = 24;
            n3 = 1;
            n2 = 2;
            n = 3;
        } else if (n6 == 4) {
            n4 = 32;
            n3 = 255;
            n2 = 65280;
            n = 0xFF0000;
        } else if (n6 == 1) {
            n4 = 32;
            n3 = 0xFF0000;
            n2 = 65280;
            n = 255;
        } else if (n6 == 2) {
            n4 = 32;
            n3 = 0xFF0000;
            n2 = 65280;
            n = 255;
        } else if (bufferedImage.getColorModel() instanceof ComponentColorModel && bufferedImage.getSampleModel() instanceof ComponentSampleModel) {
            ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
            int[] nArray = componentSampleModel.getBandOffsets();
            if (dataBuffer instanceof DataBufferInt) {
                n4 = 32;
                n3 = 255 << nArray[0];
                n2 = 255 << nArray[1];
                n = 255 << nArray[2];
            } else {
                if (!(dataBuffer instanceof DataBufferByte)) throw new IllegalArgumentException("Unsupported buffered image type: " + n6);
                n4 = componentSampleModel.getPixelStride() * 8;
                n3 = 1 + nArray[0];
                n2 = 1 + nArray[1];
                n = 1 + nArray[2];
            }
        } else {
            if (!(bufferedImage.getColorModel() instanceof DirectColorModel)) throw new IllegalArgumentException("Unsupported buffered image type: " + n6);
            DirectColorModel directColorModel = (DirectColorModel)bufferedImage.getColorModel();
            if (!(dataBuffer instanceof DataBufferInt)) throw new IllegalArgumentException("Unsupported buffered image type: " + n6);
            n4 = 32;
            n3 = directColorModel.getRedMask();
            n2 = directColorModel.getGreenMask();
            n = directColorModel.getBlueMask();
        }
        buffer.setFormat(new RGBFormat(dimension, -1, clazz, f, n4, n3, n2, n));
        buffer.setData(objectArray);
        buffer.setLength(n5);
        buffer.setOffset(0);
        return buffer;
    }
}

